/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.UniqueStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetUtil;
import org.apache.solr.search.Filter;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.join.GraphPointsCollector;

public class CrossCollectionJoinQuery
extends Query {
    protected final String query;
    protected final String zkHost;
    protected final String solrUrl;
    protected final String collection;
    protected final String fromField;
    protected final String toField;
    protected final boolean routedByJoinKey;
    protected final long timestamp;
    protected final int ttl;
    protected SolrParams otherParams;
    protected String otherParamsString;

    public CrossCollectionJoinQuery(String query, String zkHost, String solrUrl, String collection, String fromField, String toField, boolean routedByJoinKey, int ttl, SolrParams otherParams) {
        this.query = query;
        this.zkHost = zkHost;
        this.solrUrl = solrUrl;
        this.collection = collection;
        this.fromField = fromField;
        this.toField = toField;
        this.routedByJoinKey = routedByJoinKey;
        this.timestamp = System.nanoTime();
        this.ttl = ttl;
        this.otherParams = otherParams;
        if (otherParams != null) {
            this.otherParamsString = otherParams.toString();
        }
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new CrossCollectionJoinQueryWeight((SolrIndexSearcher)searcher, scoreMode, boost);
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.query);
        result = 31 * result + Objects.hashCode(this.zkHost);
        result = 31 * result + Objects.hashCode(this.solrUrl);
        result = 31 * result + Objects.hashCode(this.collection);
        result = 31 * result + Objects.hashCode(this.fromField);
        result = 31 * result + Objects.hashCode(this.toField);
        result = 31 * result + Objects.hashCode(this.routedByJoinKey);
        result = 31 * result + Objects.hashCode(this.otherParamsString);
        return result;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((CrossCollectionJoinQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(CrossCollectionJoinQuery other) {
        return Objects.equals(this.query, other.query) && Objects.equals(this.zkHost, other.zkHost) && Objects.equals(this.solrUrl, other.solrUrl) && Objects.equals(this.collection, other.collection) && Objects.equals(this.fromField, other.fromField) && Objects.equals(this.toField, other.toField) && this.routedByJoinKey == other.routedByJoinKey && Objects.equals(this.otherParamsString, other.otherParamsString) && TimeUnit.SECONDS.convert(Math.abs(this.timestamp - other.timestamp), TimeUnit.NANOSECONDS) < (long)Math.min(this.ttl, other.ttl);
    }

    public String toString(String field) {
        return String.format(Locale.ROOT, "{!xcjf collection=%s from=%s to=%s routed=%b ttl=%d}%s", this.collection, this.fromField, this.toField, this.routedByJoinKey, this.ttl, this.query.toString());
    }

    private class CrossCollectionJoinQueryWeight
    extends ConstantScoreWeight {
        private SolrIndexSearcher searcher;
        private ScoreMode scoreMode;
        private Filter filter;

        public CrossCollectionJoinQueryWeight(SolrIndexSearcher searcher, ScoreMode scoreMode, float score) {
            super((Query)CrossCollectionJoinQuery.this, score);
            this.scoreMode = scoreMode;
            this.searcher = searcher;
        }

        private String createHashRangeFq() {
            if (CrossCollectionJoinQuery.this.routedByJoinKey) {
                ClusterState clusterState = this.searcher.getCore().getCoreContainer().getZkController().getClusterState();
                CloudDescriptor desc = this.searcher.getCore().getCoreDescriptor().getCloudDescriptor();
                Slice slice = clusterState.getCollection(desc.getCollectionName()).getSlicesMap().get(desc.getShardId());
                DocRouter.Range range = slice.getRange();
                int min = range.min & 0xFFFF0000;
                int max = range.max | 0xFFFF;
                return String.format(Locale.ROOT, "{!hash_range f=%s l=%d u=%d}", CrossCollectionJoinQuery.this.fromField, min, max);
            }
            return null;
        }

        private TupleStream createCloudSolrStream(SolrClientCache solrClientCache) throws IOException {
            String streamZkHost = CrossCollectionJoinQuery.this.zkHost != null ? CrossCollectionJoinQuery.this.zkHost : this.searcher.getCore().getCoreContainer().getZkController().getZkServerAddress();
            ModifiableSolrParams params = new ModifiableSolrParams(CrossCollectionJoinQuery.this.otherParams);
            params.set("q", CrossCollectionJoinQuery.this.query);
            String fq = this.createHashRangeFq();
            if (fq != null) {
                params.add("fq", fq);
            }
            params.set("fl", CrossCollectionJoinQuery.this.fromField);
            params.set("sort", CrossCollectionJoinQuery.this.fromField + " asc");
            params.set("qt", "/export");
            params.set("wt", "javabin");
            StreamContext streamContext = new StreamContext();
            streamContext.setSolrClientCache(solrClientCache);
            CloudSolrStream cloudSolrStream = new CloudSolrStream(streamZkHost, CrossCollectionJoinQuery.this.collection, params);
            UniqueStream uniqueStream = new UniqueStream(cloudSolrStream, new FieldEqualitor(CrossCollectionJoinQuery.this.fromField));
            ((TupleStream)uniqueStream).setStreamContext(streamContext);
            return uniqueStream;
        }

        private TupleStream createSolrStream() {
            StreamExpression searchExpr = new StreamExpression("search").withParameter(CrossCollectionJoinQuery.this.collection).withParameter(new StreamExpressionNamedParameter("q", CrossCollectionJoinQuery.this.query));
            String fq = this.createHashRangeFq();
            if (fq != null) {
                searchExpr.withParameter(new StreamExpressionNamedParameter("fq", fq));
            }
            searchExpr.withParameter(new StreamExpressionNamedParameter("fl", CrossCollectionJoinQuery.this.fromField)).withParameter(new StreamExpressionNamedParameter("sort", CrossCollectionJoinQuery.this.fromField + " asc")).withParameter(new StreamExpressionNamedParameter("qt", "/export"));
            for (Map.Entry<String, String[]> entry : CrossCollectionJoinQuery.this.otherParams) {
                for (String value : entry.getValue()) {
                    searchExpr.withParameter(new StreamExpressionNamedParameter(entry.getKey(), value));
                }
            }
            StreamExpression uniqueExpr = new StreamExpression("unique");
            uniqueExpr.withParameter(searchExpr).withParameter(new StreamExpressionNamedParameter("over", CrossCollectionJoinQuery.this.fromField));
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("expr", uniqueExpr.toString());
            params.set("qt", "/stream");
            params.set("wt", "javabin");
            return new SolrStream(CrossCollectionJoinQuery.this.solrUrl + "/" + CrossCollectionJoinQuery.this.collection, params);
        }

        private DocSet getDocSet() throws IOException {
            JoinKeyCollector collector;
            SolrClientCache solrClientCache = this.searcher.getCore().getCoreContainer().getSolrClientCache();
            TupleStream solrStream = CrossCollectionJoinQuery.this.zkHost != null || CrossCollectionJoinQuery.this.solrUrl == null ? this.createCloudSolrStream(solrClientCache) : this.createSolrStream();
            FieldType fieldType = this.searcher.getSchema().getFieldType(CrossCollectionJoinQuery.this.toField);
            if (fieldType.isPointField()) {
                collector = new PointJoinKeyCollector(this.searcher);
            } else {
                Terms terms = this.searcher.getSlowAtomicReader().terms(CrossCollectionJoinQuery.this.toField);
                if (terms == null) {
                    return DocSet.EMPTY;
                }
                collector = new TermsJoinKeyCollector(fieldType, terms, this.searcher);
            }
            try {
                solrStream.open();
                while (true) {
                    Tuple tuple = solrStream.read();
                    if (tuple.EXCEPTION) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, tuple.getException());
                    }
                    if (tuple.EOF) {
                        break;
                    }
                    Object value = tuple.get(CrossCollectionJoinQuery.this.fromField);
                    if (null == value) continue;
                    collector.collect(value);
                }
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            finally {
                solrStream.close();
            }
            return collector.getDocSet();
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            DocIdSet readerSet;
            if (this.filter == null) {
                this.filter = this.getDocSet().getTopFilter();
            }
            if ((readerSet = this.filter.getDocIdSet(context, null)) == null) {
                return null;
            }
            DocIdSetIterator readerSetIterator = readerSet.iterator();
            if (readerSetIterator == null) {
                return null;
            }
            return new ConstantScoreScorer((Weight)this, this.score(), this.scoreMode, readerSetIterator);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    private class PointJoinKeyCollector
    extends GraphPointsCollector
    implements JoinKeyCollector {
        SolrIndexSearcher searcher;

        public PointJoinKeyCollector(SolrIndexSearcher searcher) {
            super(searcher.getSchema().getField(CrossCollectionJoinQuery.this.toField), null, null);
            this.searcher = searcher;
        }

        @Override
        public void collect(Object value) throws IOException {
            if (!(value instanceof Long) && !(value instanceof Integer)) {
                throw new UnsupportedOperationException("Unsupported field type for XCJFQuery");
            }
            this.set.add(((Number)value).longValue());
        }

        @Override
        public DocSet getDocSet() throws IOException {
            Query query = this.getResultQuery(this.searcher.getSchema().getField(CrossCollectionJoinQuery.this.toField), false);
            if (query == null) {
                return DocSet.EMPTY;
            }
            return DocSetUtil.createDocSet(this.searcher, query, null);
        }
    }

    private class TermsJoinKeyCollector
    implements JoinKeyCollector {
        FieldType fieldType;
        SolrIndexSearcher searcher;
        TermsEnum termsEnum;
        BytesRefBuilder bytes;
        PostingsEnum postingsEnum;
        FixedBitSet bitSet;

        public TermsJoinKeyCollector(FieldType fieldType, Terms terms, SolrIndexSearcher searcher) throws IOException {
            this.fieldType = fieldType;
            this.searcher = searcher;
            this.termsEnum = terms.iterator();
            this.bytes = new BytesRefBuilder();
            this.bitSet = new FixedBitSet(searcher.maxDoc());
        }

        @Override
        public void collect(Object value) throws IOException {
            this.fieldType.readableToIndexed((String)value, this.bytes);
            if (this.termsEnum.seekExact(this.bytes.get())) {
                this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
                this.bitSet.or((DocIdSetIterator)this.postingsEnum);
            }
        }

        @Override
        public DocSet getDocSet() throws IOException {
            if (this.searcher.getIndexReader().hasDeletions()) {
                this.bitSet.and(this.searcher.getLiveDocSet().getBits());
            }
            return new BitDocSet(this.bitSet);
        }
    }

    private static interface JoinKeyCollector {
        public void collect(Object var1) throws IOException;

        public DocSet getDocSet() throws IOException;
    }
}

