/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.security.AttributeOnlyServletContext;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.DelegationTokenKerberosFilter;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.security.KerberosFilter;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.eclipse.jetty.client.api.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosPlugin
extends AuthenticationPlugin
implements HttpClientBuilderPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Krb5HttpClientBuilder kerberosBuilder = new Krb5HttpClientBuilder();
    private Filter kerberosFilter;
    public static final String NAME_RULES_PARAM = "solr.kerberos.name.rules";
    public static final String COOKIE_DOMAIN_PARAM = "solr.kerberos.cookie.domain";
    public static final String COOKIE_PATH_PARAM = "solr.kerberos.cookie.path";
    public static final String PRINCIPAL_PARAM = "solr.kerberos.principal";
    public static final String KEYTAB_PARAM = "solr.kerberos.keytab";
    public static final String TOKEN_VALID_PARAM = "solr.kerberos.token.valid";
    public static final String COOKIE_PORT_AWARE_PARAM = "solr.kerberos.cookie.portaware";
    public static final String IMPERSONATOR_PREFIX = "solr.kerberos.impersonator.user.";
    public static final String DELEGATION_TOKEN_ENABLED = "solr.kerberos.delegation.token.enabled";
    public static final String DELEGATION_TOKEN_KIND = "solr.kerberos.delegation.token.kind";
    public static final String DELEGATION_TOKEN_VALIDITY = "solr.kerberos.delegation.token.validity";
    public static final String DELEGATION_TOKEN_SECRET_PROVIDER = "solr.kerberos.delegation.token.signer.secret.provider";
    public static final String DELEGATION_TOKEN_SECRET_PROVIDER_ZK_PATH = "solr.kerberos.delegation.token.signer.secret.provider.zookeper.path";
    public static final String DELEGATION_TOKEN_SECRET_MANAGER_ZNODE_WORKING_PATH = "solr.kerberos.delegation.token.secret.manager.znode.working.path";
    public static final String DELEGATION_TOKEN_TYPE_DEFAULT = "solr-dt";
    public static final String IMPERSONATOR_DO_AS_HTTP_PARAM = "doAs";
    public static final String IMPERSONATOR_USER_NAME = "solr.impersonator.user.name";
    public static final String ORIGINAL_USER_PRINCIPAL_HEADER = "originalUserPrincipal";
    static final String DELEGATION_TOKEN_ZK_CLIENT = "solr.kerberos.delegation.token.zk.client";
    private final CoreContainer coreContainer;

    public KerberosPlugin(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        try {
            FilterConfig conf = this.getInitFilterConfig(pluginConfig, false);
            this.kerberosFilter.init(conf);
        }
        catch (ServletException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing kerberos authentication plugin: " + (Object)((Object)e));
        }
    }

    @VisibleForTesting
    protected FilterConfig getInitFilterConfig(Map<String, Object> pluginConfig, boolean skipKerberosChecking) {
        String usePortStr;
        boolean needPortAwareCookies;
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "kerberos");
        this.putParam(params, "kerberos.name.rules", NAME_RULES_PARAM, "DEFAULT");
        this.putParam(params, "token.valid", TOKEN_VALID_PARAM, "30");
        this.putParam(params, "cookie.path", COOKIE_PATH_PARAM, "/");
        if (!skipKerberosChecking) {
            this.putParam(params, "kerberos.principal", PRINCIPAL_PARAM, null);
            this.putParam(params, "kerberos.keytab", KEYTAB_PARAM, null);
        } else {
            this.putParamOptional(params, "kerberos.principal", PRINCIPAL_PARAM);
            this.putParamOptional(params, "kerberos.keytab", KEYTAB_PARAM);
        }
        String delegationTokenStr = System.getProperty(DELEGATION_TOKEN_ENABLED, null);
        boolean delegationTokenEnabled = delegationTokenStr == null ? false : Boolean.parseBoolean(delegationTokenStr);
        ZkController controller = this.coreContainer.getZkController();
        if (delegationTokenEnabled) {
            this.putParam(params, "delegation-token.token-kind", DELEGATION_TOKEN_KIND, DELEGATION_TOKEN_TYPE_DEFAULT);
            if (this.coreContainer.isZooKeeperAware()) {
                this.putParam(params, "signer.secret.provider", DELEGATION_TOKEN_SECRET_PROVIDER, "zookeeper");
                if ("zookeeper".equals(params.get("signer.secret.provider"))) {
                    String zkHost = controller.getZkServerAddress();
                    this.putParam(params, "token.validity", DELEGATION_TOKEN_VALIDITY, "36000");
                    params.put("zk-dt-secret-manager.enable", "true");
                    String chrootPath = zkHost.contains("/") ? zkHost.substring(zkHost.indexOf("/")) : "";
                    String znodeWorkingPath = chrootPath + "/security" + "/zkdtsm";
                    znodeWorkingPath = znodeWorkingPath.startsWith("/") ? znodeWorkingPath.substring(1) : znodeWorkingPath;
                    this.putParam(params, "zk-dt-secret-manager.znodeWorkingPath", DELEGATION_TOKEN_SECRET_MANAGER_ZNODE_WORKING_PATH, znodeWorkingPath);
                    this.putParam(params, "signer.secret.provider.zookeeper.path", DELEGATION_TOKEN_SECRET_PROVIDER_ZK_PATH, "/token");
                    this.getHttpClientBuilder(SolrHttpClientBuilder.create());
                }
            } else {
                log.info("CoreContainer is not ZooKeeperAware, not setting ZK-related delegation token properties");
            }
        }
        boolean bl = needPortAwareCookies = (usePortStr = System.getProperty(COOKIE_PORT_AWARE_PARAM, null)) == null ? false : Boolean.parseBoolean(usePortStr);
        if (!needPortAwareCookies || !this.coreContainer.isZooKeeperAware()) {
            this.putParam(params, "cookie.domain", COOKIE_DOMAIN_PARAM, null);
        } else {
            String host = System.getProperty(COOKIE_DOMAIN_PARAM, null);
            if (host == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required parameter 'solr.kerberos.cookie.domain'.");
            }
            int port = controller.getHostPort();
            params.put("cookie.domain", host + ":" + port);
        }
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (!key.startsWith(IMPERSONATOR_PREFIX)) continue;
            if (!delegationTokenEnabled) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Impersonator configuration requires delegation tokens to be enabled: " + key);
            }
            params.put(key, System.getProperty(key));
        }
        params.put("delegation-token.json-mapper." + JsonGenerator.Feature.AUTO_CLOSE_TARGET, "false");
        final AttributeOnlyServletContext servletContext = new AttributeOnlyServletContext();
        if (controller != null) {
            servletContext.setAttribute(DELEGATION_TOKEN_ZK_CLIENT, controller.getZkClient());
        }
        this.kerberosFilter = delegationTokenEnabled ? new DelegationTokenKerberosFilter() : new KerberosFilter(this.coreContainer);
        log.info("Params: {}", params);
        FilterConfig conf = new FilterConfig(){

            public ServletContext getServletContext() {
                return servletContext;
            }

            public Enumeration<String> getInitParameterNames() {
                return new IteratorEnumeration(params.keySet().iterator());
            }

            public String getInitParameter(String param) {
                return (String)params.get(param);
            }

            public String getFilterName() {
                return "KerberosFilter";
            }
        };
        return conf;
    }

    private void putParam(Map<String, String> params, String internalParamName, String externalParamName, String defaultValue) {
        String value = System.getProperty(externalParamName, defaultValue);
        if (value == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required parameter '" + externalParamName + "'.");
        }
        params.put(internalParamName, value);
    }

    private void putParamOptional(Map<String, String> params, String internalParamName, String externalParamName) {
        String value = System.getProperty(externalParamName);
        if (value != null) {
            params.put(internalParamName, value);
        }
    }

    @Override
    public boolean doAuthenticate(ServletRequest req, ServletResponse rsp, FilterChain chain) throws Exception {
        log.debug("Request to authenticate using kerberos: {}", (Object)req);
        this.kerberosFilter.doFilter(req, rsp, chain);
        String requestContinuesAttr = (String)req.getAttribute("org.apache.solr.security.authentication.requestcontinues");
        if (requestContinuesAttr == null) {
            log.warn("Could not find {}", (Object)"org.apache.solr.security.authentication.requestcontinues");
            return false;
        }
        return Boolean.parseBoolean(requestContinuesAttr);
    }

    @Override
    protected boolean interceptInternodeRequest(HttpRequest httpRequest, HttpContext httpContext) {
        return this.intercept((arg_0, arg_1) -> ((HttpRequest)httpRequest).setHeader(arg_0, arg_1));
    }

    @Override
    protected boolean interceptInternodeRequest(Request request) {
        return this.intercept((arg_0, arg_1) -> ((Request)request).header(arg_0, arg_1));
    }

    private boolean intercept(BiConsumer<String, String> header) {
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        if (info != null && (info.getAction() == SolrDispatchFilter.Action.FORWARD || info.getAction() == SolrDispatchFilter.Action.REMOTEQUERY) && info.getUserPrincipal() != null) {
            if (log.isInfoEnabled()) {
                log.info("Setting original user principal: {}", (Object)info.getUserPrincipal().getName());
            }
            header.accept(ORIGINAL_USER_PRINCIPAL_HEADER, info.getUserPrincipal().getName());
            return true;
        }
        return false;
    }

    @Override
    public SolrHttpClientBuilder getHttpClientBuilder(SolrHttpClientBuilder builder) {
        return this.kerberosBuilder.getBuilder(builder);
    }

    @Override
    public void setup(Http2SolrClient client) {
        HttpListenerFactory.RequestResponseListener listener = new HttpListenerFactory.RequestResponseListener(){

            @Override
            public void onQueued(Request request) {
                KerberosPlugin.this.interceptInternodeRequest(request);
            }
        };
        client.addListenerFactory(() -> listener);
        this.kerberosBuilder.setup(client);
    }

    @Override
    public void close() {
        this.kerberosFilter.destroy();
        this.kerberosBuilder.close();
    }

    protected Filter getKerberosFilter() {
        return this.kerberosFilter;
    }

    protected void setKerberosFilter(Filter kerberosFilter) {
        this.kerberosFilter = kerberosFilter;
    }
}

