/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.cloud.api.collections.AliasCmd;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.api.collections.RoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;

public class CreateAliasCmd
extends AliasCmd {
    private static boolean anyRoutingParams(ZkNodeProps message) {
        return message.keySet().stream().anyMatch(k -> k.startsWith("router."));
    }

    public CreateAliasCmd(OverseerCollectionMessageHandler ocmh) {
        super(ocmh);
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String aliasName = message.getStr("name");
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        if (zkStateReader.aliasesManager != null) {
            zkStateReader.aliasesManager.update();
        }
        if (!CreateAliasCmd.anyRoutingParams(message)) {
            this.callCreatePlainAlias(message, aliasName, zkStateReader);
        } else {
            this.callCreateRoutedAlias(message, aliasName, zkStateReader, state);
        }
        Thread.sleep(100L);
    }

    private void callCreatePlainAlias(ZkNodeProps message, String aliasName, ZkStateReader zkStateReader) {
        List<String> canonicalCollectionList = this.parseCollectionsParameter(message.get("collections"));
        if (canonicalCollectionList.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'collections' parameter doesn't contain any collection names.");
        }
        String canonicalCollectionsString = StrUtils.join(canonicalCollectionList, ',');
        this.validateAllCollectionsExistAndNoDuplicates(canonicalCollectionList, zkStateReader);
        zkStateReader.aliasesManager.applyModificationAndExportToZk(aliases -> aliases.cloneWithCollectionAlias(aliasName, canonicalCollectionsString));
    }

    private List<String> parseCollectionsParameter(Object colls) {
        if (colls == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing collections param");
        }
        if (colls instanceof List) {
            return (List)colls;
        }
        return StrUtils.splitSmart(colls.toString(), ",", true).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private void callCreateRoutedAlias(ZkNodeProps message, String aliasName, ZkStateReader zkStateReader, ClusterState state) throws Exception {
        if (!message.getProperties().keySet().containsAll(RoutedAlias.MINIMAL_REQUIRED_PARAMS)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A routed alias requires these params: " + RoutedAlias.MINIMAL_REQUIRED_PARAMS + " plus some create-collection prefixed ones.");
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        message.getProperties().forEach((key, value) -> props.put((String)key, String.valueOf(value)));
        RoutedAlias routedAlias = RoutedAlias.fromProps(aliasName, props);
        if (routedAlias == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Tried to create a routed alias with no type!");
        }
        if (!props.keySet().containsAll(routedAlias.getRequiredParams())) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not all required params were supplied. Missing params: " + StrUtils.join(Sets.difference(routedAlias.getRequiredParams(), props.keySet()), ','));
        }
        String initialColl = routedAlias.computeInitialCollectionName();
        this.ensureAliasCollection(aliasName, zkStateReader, state, routedAlias.getAliasMetadata(), initialColl);
        zkStateReader.aliasesManager.applyModificationAndExportToZk(aliases -> aliases.cloneWithCollectionAlias(aliasName, initialColl).cloneWithCollectionAliasProperties(aliasName, routedAlias.getAliasMetadata()));
    }

    private void ensureAliasCollection(String aliasName, ZkStateReader zkStateReader, ClusterState state, Map<String, String> aliasProperties, String initialCollectionName) throws Exception {
        CreateAliasCmd.createCollectionAndWait(state, aliasName, aliasProperties, initialCollectionName, this.ocmh);
        this.validateAllCollectionsExistAndNoDuplicates(Collections.singletonList(initialCollectionName), zkStateReader);
    }

    private void validateAllCollectionsExistAndNoDuplicates(List<String> collectionList, ZkStateReader zkStateReader) {
        String collectionStr = StrUtils.join(collectionList, ',');
        if (new HashSet<String>(collectionList).size() != collectionList.size()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Can't create collection alias for collections='%s', since it contains duplicates", collectionStr));
        }
        ClusterState clusterState = zkStateReader.getClusterState();
        Set<String> aliasNames = zkStateReader.getAliases().getCollectionAliasListMap().keySet();
        for (String collection : collectionList) {
            if (clusterState.getCollectionOrNull(collection) != null || aliasNames.contains(collection)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Can't create collection alias for collections='%s', '%s' is not an existing collection or alias", collectionStr, collection));
        }
    }
}

