/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.NonExistentCoreException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.handler.admin.MetricsHistoryHandler;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCollectionCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Set<String> okayExceptions = Collections.singleton(NonExistentCoreException.class.getName());
    private final OverseerCollectionMessageHandler ocmh;
    private final TimeSource timeSource;

    public DeleteCollectionCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
        this.timeSource = ocmh.cloudManager.getTimeSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        block26: {
            Object o = message.get("invokedByRoutedAlias");
            if (o != null) {
                ((Runnable)o).run();
            }
            String extCollection = message.getStr("name");
            ZkStateReader zkStateReader = this.ocmh.zkStateReader;
            if (zkStateReader.aliasesManager != null) {
                zkStateReader.aliasesManager.update();
            }
            boolean followAliases = message.getBool("followAliases", false);
            List<String> aliasReferences = this.checkAliasReference(zkStateReader, extCollection, followAliases);
            Aliases aliases = zkStateReader.getAliases();
            String collection = followAliases ? aliases.resolveSimpleAlias(extCollection) : extCollection;
            this.checkNotColocatedWith(zkStateReader, collection);
            boolean deleteHistory = message.getBool("deleteMetricsHistory", true);
            boolean removeCounterNode = true;
            try {
                String configSetName;
                MetricsHistoryHandler historyHandler;
                SolrZkClient zkClient = zkStateReader.getZkClient();
                SolrSnapshotManager.cleanupCollectionLevelSnapshots(zkClient, collection);
                if (zkStateReader.getClusterState().getCollectionOrNull(collection) == null && zkStateReader.getZkClient().exists("/collections/" + collection, true).booleanValue()) {
                    return;
                }
                if (deleteHistory && (historyHandler = this.ocmh.overseer.getCoreContainer().getMetricsHistoryHandler()) != null) {
                    String registry = SolrMetricManager.getRegistryName(SolrInfoBean.Group.collection, collection);
                    historyHandler.removeHistory(registry);
                }
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", CoreAdminParams.CoreAdminAction.UNLOAD.toString());
                params.set("deleteInstanceDir", true);
                params.set("deleteDataDir", true);
                params.set("deleteMetricsHistory", deleteHistory);
                String asyncId = message.getStr("async");
                ZkNodeProps internalMsg = message.plus("name", collection);
                List<Replica> failedReplicas = this.ocmh.collectionCmd(internalMsg, params, results, null, asyncId, okayExceptions);
                for (Replica failedReplica : failedReplicas) {
                    boolean isSharedFS = failedReplica.getBool("shared_storage", false) && failedReplica.get("dataDir") != null;
                    if (!isSharedFS) continue;
                    removeCounterNode = false;
                    break;
                }
                ZkNodeProps m = new ZkNodeProps("operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collection);
                this.ocmh.overseer.offerStateUpdate(Utils.toJSON(m));
                zkStateReader.waitForState(collection, 60L, TimeUnit.SECONDS, collectionState -> collectionState == null);
                if (!aliasReferences.isEmpty()) {
                    this.ocmh.zkStateReader.aliasesManager.applyModificationAndExportToZk(a -> {
                        for (String alias : aliasReferences) {
                            a = a.cloneWithCollectionAlias(alias, null);
                        }
                        return a;
                    });
                }
                if (!ConfigSetsHandler.isAutoGeneratedConfigSet(configSetName = zkStateReader.readConfigName(collection))) break block26;
                boolean configSetIsUsedByOtherCollection = false;
                for (Map.Entry<String, DocCollection> entry : zkStateReader.getClusterState().getCollectionsMap().entrySet()) {
                    String otherConfigSetName = null;
                    try {
                        otherConfigSetName = zkStateReader.readConfigName(entry.getKey());
                    }
                    catch (KeeperException keeperException) {
                        // empty catch block
                    }
                    if (!configSetName.equals(otherConfigSetName)) continue;
                    configSetIsUsedByOtherCollection = true;
                    break;
                }
                if (!configSetIsUsedByOtherCollection) {
                    zkStateReader.getConfigManager().deleteConfigDir(configSetName);
                }
            }
            finally {
                try {
                    String collectionPath = ZkStateReader.getCollectionPathRoot(collection);
                    if (zkStateReader.getZkClient().exists(collectionPath, true).booleanValue()) {
                        if (removeCounterNode) {
                            zkStateReader.getZkClient().clean(collectionPath);
                        } else {
                            String counterNodePath = Assign.getCounterNodePath(collection);
                            zkStateReader.getZkClient().clean(collectionPath, s -> !s.equals(counterNodePath));
                        }
                    }
                }
                catch (InterruptedException e) {
                    SolrException.log(log, "Cleaning up collection in zk was interrupted:" + collection, e);
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException e) {
                    SolrException.log(log, "Problem cleaning up collection in zk:" + collection, e);
                }
            }
        }
    }

    private List<String> checkAliasReference(ZkStateReader zkStateReader, String extCollection, boolean followAliases) throws Exception {
        Aliases aliases = zkStateReader.getAliases();
        List<String> aliasesRefs = DeleteCollectionCmd.referencedByAlias(extCollection, aliases, followAliases);
        ArrayList<String> aliasesToDelete = new ArrayList<String>();
        if (aliasesRefs.size() > 0) {
            String collection;
            zkStateReader.aliasesManager.update();
            aliases = zkStateReader.getAliases();
            aliasesRefs = DeleteCollectionCmd.referencedByAlias(extCollection, aliases, followAliases);
            String string = collection = followAliases ? aliases.resolveSimpleAlias(extCollection) : extCollection;
            if (aliasesRefs.size() > 0) {
                for (String alias : aliasesRefs) {
                    if (!extCollection.equals(alias)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection : " + collection + " is part of aliases: " + aliasesRefs + ", remove or modify the aliases before removing this collection.");
                    }
                    aliasesToDelete.add(alias);
                }
            }
        }
        return aliasesToDelete;
    }

    public static List<String> referencedByAlias(String extCollection, Aliases aliases, boolean followAliases) throws IllegalArgumentException {
        Objects.requireNonNull(aliases);
        String collection = followAliases ? aliases.resolveSimpleAlias(extCollection) : extCollection;
        return aliases.getCollectionAliasListMap().entrySet().stream().filter(e -> !((String)e.getKey()).equals(collection)).filter(e -> ((List)e.getValue()).contains(collection) || ((List)e.getValue()).contains(extCollection)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private void checkNotColocatedWith(ZkStateReader zkStateReader, String collection) throws Exception {
        DocCollection colocatedCollection;
        String colocatedWith;
        DocCollection docCollection = zkStateReader.getClusterState().getCollectionOrNull(collection);
        if (docCollection != null && (colocatedWith = docCollection.getStr("COLOCATED_WITH")) != null && (colocatedCollection = zkStateReader.getClusterState().getCollectionOrNull(colocatedWith)) != null && collection.equals(colocatedCollection.getStr("withCollection"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " is co-located with collection: " + colocatedWith + " remove the link using modify collection API or delete the co-located collection: " + colocatedWith);
        }
    }
}

