/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerRoleCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;
    private final CollectionParams.CollectionAction operation;
    private final OverseerNodePrioritizer overseerPrioritizer;

    public OverseerRoleCmd(OverseerCollectionMessageHandler ocmh, CollectionParams.CollectionAction operation, OverseerNodePrioritizer prioritizer) {
        this.ocmh = ocmh;
        this.operation = operation;
        this.overseerPrioritizer = prioritizer;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        SolrZkClient zkClient = zkStateReader.getZkClient();
        Map roles = null;
        String node = message.getStr("node");
        String roleName = message.getStr("role");
        boolean nodeExists = false;
        nodeExists = zkClient.exists("/roles.json", true);
        roles = nodeExists ? (Map)Utils.fromJSON(zkClient.getData("/roles.json", null, new Stat(), true)) : new LinkedHashMap(1);
        ArrayList<String> nodeList = (ArrayList<String>)roles.get(roleName);
        if (nodeList == null) {
            nodeList = new ArrayList<String>();
            roles.put(roleName, nodeList);
        }
        if (CollectionParams.CollectionAction.ADDROLE == this.operation) {
            log.info("Overseer role added to {}", (Object)node);
            if (!nodeList.contains(node)) {
                nodeList.add(node);
            }
        } else if (CollectionParams.CollectionAction.REMOVEROLE == this.operation) {
            log.info("Overseer role removed from {}", (Object)node);
            nodeList.remove(node);
        }
        if (nodeExists) {
            zkClient.setData("/roles.json", Utils.toJSON(roles), true);
        } else {
            zkClient.create("/roles.json", Utils.toJSON(roles), CreateMode.PERSISTENT, true);
        }
        new Thread(() -> {
            try {
                this.overseerPrioritizer.prioritizeOverseerNodes(this.ocmh.myId);
            }
            catch (Exception e) {
                log.error("Error in prioritizing Overseer", (Throwable)e);
            }
        }).start();
    }
}

