/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.common.MapWriter;

public class ActionContext
implements MapWriter {
    private final SolrCloudManager cloudManager;
    private final AutoScaling.Trigger source;
    private final Map<String, Object> properties;

    public ActionContext(SolrCloudManager cloudManager, AutoScaling.Trigger source, Map<String, Object> properties) {
        this.cloudManager = cloudManager;
        this.source = source;
        this.properties = properties;
    }

    public SolrCloudManager getCloudManager() {
        return this.cloudManager;
    }

    public AutoScaling.Trigger getSource() {
        return this.source;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"source", this.source.getName());
        if (this.properties != null) {
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                ew.put((CharSequence)("properties." + entry.getKey()), entry.getValue());
            }
        }
    }
}

