/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.TriggerActionBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.TestInjection;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutePlanAction
extends TriggerActionBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PREFIX = "op-";
    static final int DEFAULT_TASK_TIMEOUT_SECONDS = 120;
    public static final String TASK_TIMEOUT_SECONDS = "taskTimeoutSeconds";
    public static final String TASK_TIMEOUT_FAIL = "taskTimeoutFail";
    int taskTimeoutSeconds;
    boolean taskTimeoutFail;

    public ExecutePlanAction() {
        TriggerUtils.validProperties(this.validProperties, TASK_TIMEOUT_SECONDS, TASK_TIMEOUT_FAIL);
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        super.configure(loader, cloudManager, properties);
        String str = String.valueOf(properties.getOrDefault(TASK_TIMEOUT_SECONDS, 120));
        this.taskTimeoutSeconds = Integer.parseInt(str);
        str = String.valueOf(properties.getOrDefault(TASK_TIMEOUT_FAIL, false));
        this.taskTimeoutFail = Boolean.parseBoolean(str);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(TriggerEvent event, ActionContext context) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("-- processing event: {} with context properties: {}", (Object)event, context.getProperties());
        }
        SolrCloudManager cloudManager = context.getCloudManager();
        List operations = (List)context.getProperty("operations");
        if (operations == null || operations.isEmpty()) {
            log.info("No operations to execute for event: {}", (Object)event);
            return;
        }
        try {
            int counter = 0;
            for (SolrRequest operation : operations) {
                if (log.isDebugEnabled()) {
                    log.debug("Executing operation: {}", (Object)operation.getParams());
                }
                try {
                    SolrResponse response = null;
                    if (operation instanceof CollectionAdminRequest.AsyncCollectionAdminRequest) {
                        CollectionAdminRequest.AsyncCollectionAdminRequest req = (CollectionAdminRequest.AsyncCollectionAdminRequest)operation;
                        req.setWaitForFinalState(true);
                        String asyncId = event.getSource() + '/' + event.getId() + '/' + counter;
                        String znode = this.saveAsyncId(cloudManager.getDistribStateManager(), event, asyncId);
                        log.trace("Saved requestId: {} in znode: {}", (Object)asyncId, (Object)znode);
                        req.setAsyncId(asyncId);
                        if (TestInjection.delayInExecutePlanAction != null) {
                            cloudManager.getTimeSource().sleep(TestInjection.delayInExecutePlanAction.intValue());
                        }
                        CollectionAdminRequest.RequestStatusResponse statusResponse = null;
                        RequestStatusState state = RequestStatusState.FAILED;
                        if (!TestInjection.failInExecutePlanAction) {
                            SolrResponse asyncResponse = cloudManager.request(req);
                            if (asyncResponse.getResponse().get("error") != null) {
                                throw new IOException("" + asyncResponse.getResponse().get("error"));
                            }
                            asyncId = (String)asyncResponse.getResponse().get("requestid");
                            statusResponse = ExecutePlanAction.waitForTaskToFinish(cloudManager, asyncId, this.taskTimeoutSeconds, TimeUnit.SECONDS);
                        }
                        if (statusResponse != null) {
                            state = statusResponse.getRequestStatus();
                            if (TestInjection.delayInExecutePlanAction != null && (long)TestInjection.delayInExecutePlanAction.intValue() > TimeUnit.MILLISECONDS.convert(this.taskTimeoutSeconds, TimeUnit.SECONDS)) {
                                state = RequestStatusState.RUNNING;
                            }
                            if (TestInjection.failInExecutePlanAction) {
                                state = RequestStatusState.FAILED;
                            }
                            if (state == RequestStatusState.COMPLETED || state == RequestStatusState.FAILED || state == RequestStatusState.NOT_FOUND) {
                                try {
                                    cloudManager.getDistribStateManager().removeData(znode, -1);
                                }
                                catch (Exception e) {
                                    log.warn("Unexpected exception while trying to delete znode: {}", (Object)znode, (Object)e);
                                }
                            }
                            response = statusResponse;
                        }
                        if (state == RequestStatusState.RUNNING || state == RequestStatusState.SUBMITTED) {
                            String msg = String.format(Locale.ROOT, "Task %s is still running after " + this.taskTimeoutSeconds + " seconds. Consider increasing " + TASK_TIMEOUT_SECONDS + " action property or `waitFor` of the trigger %s. Operation: %s", asyncId, event.source, req);
                            if (this.taskTimeoutFail) {
                                throw new IOException(msg);
                            }
                            log.warn(msg);
                        } else if (state == RequestStatusState.FAILED) {
                            try {
                                cloudManager.getDistribStateManager().removeData(znode, -1);
                                throw new IOException("Task " + asyncId + " failed: " + (statusResponse != null ? statusResponse : " timed out. Operation: " + req));
                            }
                            catch (Exception e) {
                                log.warn("Unexpected exception while trying to delete znode: {}", (Object)znode, (Object)e);
                            }
                            throw new IOException("Task " + asyncId + " failed: " + (statusResponse != null ? statusResponse : " timed out. Operation: " + req));
                        }
                    } else {
                        response = cloudManager.request(operation);
                    }
                    NamedList<Object> result = response.getResponse();
                    context.getProperties().compute("responses", (s, o) -> {
                        ArrayList<NamedList> responses = (ArrayList<NamedList>)o;
                        if (responses == null) {
                            responses = new ArrayList<NamedList>(operations.size());
                        }
                        responses.add(result);
                        return responses;
                    });
                    ++counter;
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected exception executing operation: " + operation.getParams(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ExecutePlanAction was interrupted", (Throwable)e);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected exception executing operation: " + operation.getParams(), (Throwable)e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected exception while processing event: " + event, (Throwable)e);
        }
    }

    static CollectionAdminRequest.RequestStatusResponse waitForTaskToFinish(SolrCloudManager cloudManager, String requestId, long duration, TimeUnit timeUnit) throws IOException, InterruptedException {
        long timeoutSeconds = timeUnit.toSeconds(duration);
        RequestStatusState state = RequestStatusState.NOT_FOUND;
        CollectionAdminRequest.RequestStatusResponse statusResponse = null;
        int i = 0;
        while ((long)i < timeoutSeconds) {
            try {
                statusResponse = (CollectionAdminRequest.RequestStatusResponse)cloudManager.request(CollectionAdminRequest.requestStatus(requestId));
                state = statusResponse.getRequestStatus();
                if (state == RequestStatusState.COMPLETED || state == RequestStatusState.FAILED) {
                    log.trace("Task with requestId={} finished with state={} in {}s", new Object[]{requestId, state, i * 5});
                    cloudManager.request(CollectionAdminRequest.deleteAsyncId(requestId));
                    return statusResponse;
                }
                if (state == RequestStatusState.NOT_FOUND) {
                    log.warn("Task with requestId={} was not found on overseer", (Object)requestId);
                    cloudManager.request(CollectionAdminRequest.deleteAsyncId(requestId));
                    return statusResponse;
                }
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause instanceof IllegalStateException && rootCause.getMessage().contains("Connection pool shut down")) {
                    throw e;
                }
                if (rootCause instanceof TimeoutException && rootCause.getMessage().contains("Could not connect to ZooKeeper")) {
                    throw e;
                }
                if (rootCause instanceof SolrServerException) {
                    throw e;
                }
                log.error("Unexpected Exception while querying status of requestId={}", (Object)requestId, (Object)e);
                throw e;
            }
            if (i > 0 && i % 5 == 0) {
                log.trace("Task with requestId={} still not complete after {}s. Last state={}", new Object[]{requestId, i * 5, state});
            }
            cloudManager.getTimeSource().sleep(5000L);
            ++i;
        }
        log.debug("Task with requestId={} did not complete within {} seconds. Last state={}", new Object[]{timeoutSeconds, requestId, state});
        return statusResponse;
    }

    private String saveAsyncId(DistribStateManager stateManager, TriggerEvent event, String asyncId) throws InterruptedException, AlreadyExistsException, IOException, KeeperException {
        String parentPath = "/autoscaling/triggerState/" + event.getSource() + "/" + this.getName();
        try {
            stateManager.makePath(parentPath);
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
        return stateManager.createData(parentPath + "/" + PREFIX, Utils.toJSON(Collections.singletonMap("requestid", asyncId)), CreateMode.PERSISTENT_SEQUENTIAL);
    }
}

