/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.math3.util.Precision;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.Checksum;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.ShardBackupMetadata;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.SnapShooter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalShardBackup {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SolrCore solrCore;
    private BackupFilePaths incBackupFiles;
    private BackupRepository backupRepo;
    private ShardBackupId prevShardBackupId;
    private ShardBackupId shardBackupId;
    private Optional<String> commitNameOption;

    public IncrementalShardBackup(BackupRepository backupRepo, SolrCore solrCore, BackupFilePaths incBackupFiles, ShardBackupId prevShardBackupId, ShardBackupId shardBackupId, Optional<String> commitNameOption) {
        this.backupRepo = backupRepo;
        this.solrCore = solrCore;
        this.incBackupFiles = incBackupFiles;
        this.prevShardBackupId = prevShardBackupId;
        this.shardBackupId = shardBackupId;
        this.commitNameOption = commitNameOption;
    }

    public NamedList backup() throws Exception {
        IndexCommit indexCommit = this.getAndSaveIndexCommit();
        try {
            NamedList namedList = this.backup(indexCommit);
            return namedList;
        }
        finally {
            this.solrCore.getDeletionPolicy().releaseCommitPoint(indexCommit.getGeneration());
        }
    }

    private IndexCommit getAndSaveIndexCommit() throws IOException {
        if (this.commitNameOption.isPresent()) {
            return SnapShooter.getAndSaveNamedIndexCommit(this.solrCore, this.commitNameOption.get());
        }
        IndexDeletionPolicyWrapper delPolicy = this.solrCore.getDeletionPolicy();
        IndexCommit commit = delPolicy.getAndSaveLatestCommit();
        if (null == commit) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Index does not yet have any commits for core " + this.solrCore.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Using latest commit: generation={}", (Object)commit.getGeneration());
        }
        return commit;
    }

    private IndexCommit getAndSaveLatestIndexCommit(IndexDeletionPolicyWrapper delPolicy) {
        IndexCommit commit = delPolicy.getAndSaveLatestCommit();
        if (null == commit) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Index does not yet have any commits for core " + this.solrCore.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Using latest commit: generation={}", (Object)commit.getGeneration());
        }
        return commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedList backup(IndexCommit indexCommit) throws Exception {
        assert (indexCommit != null);
        URI backupLocation = this.incBackupFiles.getBackupLocation();
        log.info("Creating backup snapshot at {} shardBackupMetadataFile:{}", (Object)backupLocation, (Object)this.shardBackupId);
        NamedList<Object> details = new NamedList<Object>();
        details.add("startTime", Instant.now().toString());
        Collection files = indexCommit.getFileNames();
        Directory dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.solrCore.getSolrConfig().indexConfig.lockType);
        try {
            BackupStats stats = this.incrementalCopy(files, dir);
            details.add("indexFileCount", stats.fileCount);
            details.add("uploadedIndexFileCount", stats.uploadedFileCount);
            details.add("indexSizeMB", stats.getIndexSizeMB());
            details.add("uploadedIndexFileMB", stats.getTotalUploadedMB());
        }
        finally {
            this.solrCore.getDirectoryFactory().release(dir);
        }
        CloudDescriptor cd = this.solrCore.getCoreDescriptor().getCloudDescriptor();
        if (cd != null) {
            details.add("shard", cd.getShardId());
        }
        details.add("endTime", Instant.now().toString());
        details.add("shardBackupId", this.shardBackupId.getIdAsString());
        log.info("Done creating backup snapshot at {} shardBackupMetadataFile:{}", (Object)backupLocation, (Object)this.shardBackupId);
        return details;
    }

    private ShardBackupMetadata getPrevBackupPoint() throws IOException {
        if (this.prevShardBackupId == null) {
            return ShardBackupMetadata.empty();
        }
        return ShardBackupMetadata.from(this.backupRepo, this.incBackupFiles.getShardBackupMetadataDir(), this.prevShardBackupId);
    }

    private BackupStats incrementalCopy(Collection<String> indexFiles, Directory dir) throws IOException {
        ShardBackupMetadata oldBackupPoint = this.getPrevBackupPoint();
        ShardBackupMetadata currentBackupPoint = ShardBackupMetadata.empty();
        URI indexDir = this.incBackupFiles.getIndexDir();
        BackupStats backupStats = new BackupStats();
        for (String fileName : indexFiles) {
            Optional<ShardBackupMetadata.BackedFile> opBackedFile = oldBackupPoint.getFile(fileName);
            Checksum originalFileCS = this.backupRepo.checksum(dir, fileName);
            if (opBackedFile.isPresent()) {
                ShardBackupMetadata.BackedFile backedFile = opBackedFile.get();
                Checksum existedFileCS = backedFile.fileChecksum;
                if (existedFileCS.equals(originalFileCS)) {
                    currentBackupPoint.addBackedFile(opBackedFile.get());
                    backupStats.skippedUploadingFile(existedFileCS);
                    continue;
                }
            }
            String backedFileName = UUID.randomUUID().toString();
            this.backupRepo.copyIndexFileFrom(dir, fileName, indexDir, backedFileName);
            currentBackupPoint.addBackedFile(backedFileName, fileName, originalFileCS);
            backupStats.uploadedFile(originalFileCS);
        }
        currentBackupPoint.store(this.backupRepo, this.incBackupFiles.getShardBackupMetadataDir(), this.shardBackupId);
        return backupStats;
    }

    private static class BackupStats {
        private int fileCount;
        private int uploadedFileCount;
        private long indexSize;
        private long totalUploadedBytes;

        private BackupStats() {
        }

        public void uploadedFile(Checksum file) {
            ++this.fileCount;
            ++this.uploadedFileCount;
            this.indexSize += file.size;
            this.totalUploadedBytes += file.size;
        }

        public void skippedUploadingFile(Checksum existedFile) {
            ++this.fileCount;
            this.indexSize += existedFile.size;
        }

        public double getIndexSizeMB() {
            return Precision.round((double)((double)this.indexSize / 1048576.0), (int)3);
        }

        public double getTotalUploadedMB() {
            return Precision.round((double)((double)this.totalUploadedBytes / 1048576.0), (int)3);
        }
    }
}

