/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.api.ApiSupport;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.NestedRequestHandler;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestHandlerBase
implements SolrRequestHandler,
SolrInfoBean,
SolrMetricProducer,
NestedRequestHandler,
ApiSupport {
    protected NamedList initArgs = null;
    protected SolrParams defaults;
    protected SolrParams appends;
    protected SolrParams invariants;
    protected boolean httpCaching = true;
    private Meter numErrors = new Meter();
    private Meter numServerErrors = new Meter();
    private Meter numClientErrors = new Meter();
    private Meter numTimeouts = new Meter();
    private Counter requests = new Counter();
    private final Map<String, Counter> shardPurposes = new ConcurrentHashMap<String, Counter>();
    private Timer requestTimes = new Timer();
    private Timer distribRequestTimes = new Timer();
    private Timer localRequestTimes = new Timer();
    private Counter totalTime = new Counter();
    private Counter distribTotalTime = new Counter();
    private Counter localTotalTime = new Counter();
    private final long handlerStart;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PluginInfo pluginInfo;
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();
    protected SolrMetricsContext solrMetricsContext;

    @SuppressForbidden(reason="Need currentTimeMillis, used only for stats output")
    public RequestHandlerBase() {
        this.handlerStart = System.currentTimeMillis();
    }

    @Override
    public void init(NamedList args) {
        this.initArgs = args;
        if (args != null) {
            this.defaults = RequestHandlerBase.getSolrParamsFromNamedList(args, "defaults");
            this.appends = RequestHandlerBase.getSolrParamsFromNamedList(args, "appends");
            this.invariants = RequestHandlerBase.getSolrParamsFromNamedList(args, "invariants");
        }
        if (this.initArgs != null) {
            Object caching = this.initArgs.get("httpCaching");
            this.httpCaching = caching != null ? Boolean.parseBoolean(caching.toString()) : true;
        }
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        this.numErrors = this.solrMetricsContext.meter(this, "errors", this.getCategory().toString(), scope);
        this.numServerErrors = this.solrMetricsContext.meter(this, "serverErrors", this.getCategory().toString(), scope);
        this.numClientErrors = this.solrMetricsContext.meter(this, "clientErrors", this.getCategory().toString(), scope);
        this.numTimeouts = this.solrMetricsContext.meter(this, "timeouts", this.getCategory().toString(), scope);
        this.requests = this.solrMetricsContext.counter(this, "requests", this.getCategory().toString(), scope);
        MetricsMap metricsMap = new MetricsMap(map -> this.shardPurposes.forEach((k, v) -> map.putNoEx((CharSequence)k, v.getCount())));
        this.solrMetricsContext.gauge(this, metricsMap, true, "shardRequests", this.getCategory().toString(), scope);
        this.requestTimes = this.solrMetricsContext.timer(this, "requestTimes", this.getCategory().toString(), scope);
        this.distribRequestTimes = this.solrMetricsContext.timer(this, "requestTimes", this.getCategory().toString(), scope, "distrib");
        this.localRequestTimes = this.solrMetricsContext.timer(this, "requestTimes", this.getCategory().toString(), scope, "local");
        this.totalTime = this.solrMetricsContext.counter(this, "totalTime", this.getCategory().toString(), scope);
        this.distribTotalTime = this.solrMetricsContext.counter(this, "totalTime", this.getCategory().toString(), scope, "distrib");
        this.localTotalTime = this.solrMetricsContext.counter(this, "totalTime", this.getCategory().toString(), scope, "local");
        this.solrMetricsContext.gauge(this, () -> this.handlerStart, true, "handlerStart", this.getCategory().toString(), scope);
    }

    public static SolrParams getSolrParamsFromNamedList(NamedList args, String key) {
        Object o = args.get(key);
        if (o != null && o instanceof NamedList) {
            return ((NamedList)o).toSolrParams();
        }
        return null;
    }

    public NamedList getInitArgs() {
        return this.initArgs;
    }

    public abstract void handleRequestBody(SolrQueryRequest var1, SolrQueryResponse var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.requests.inc();
        boolean distrib = req.getParams().getBool("distrib", req.getCore() != null ? req.getCore().getCoreContainer().isZooKeeperAware() : false);
        if (req.getParams().getBool("isShard", false)) {
            this.shardPurposes.computeIfAbsent("total", name -> new Counter()).inc();
            int purpose = req.getParams().getInt("shards.purpose", 0);
            if (purpose != 0) {
                String[] names;
                for (String n : names = SolrPluginUtils.getRequestPurposeNames(purpose)) {
                    this.shardPurposes.computeIfAbsent(n, name -> new Counter()).inc();
                }
            }
        }
        Timer.Context timer = this.requestTimes.time();
        Timer.Context dTimer = distrib ? this.distribRequestTimes.time() : this.localRequestTimes.time();
        try {
            TestInjection.injectLeaderTragedy(req.getCore());
            if (this.pluginInfo != null && this.pluginInfo.attributes.containsKey("useParams")) {
                req.getContext().put("useParams", this.pluginInfo.attributes.get("useParams"));
            }
            SolrPluginUtils.setDefaults(this, req, this.defaults, this.appends, this.invariants);
            req.getContext().remove("useParams");
            rsp.setHttpCaching(this.httpCaching);
            this.handleRequestBody(req, rsp);
            NamedList<Object> header = rsp.getResponseHeader();
            if (header != null && Boolean.TRUE.equals(header.getBooleanArg("partialResults"))) {
                this.numTimeouts.mark();
                rsp.setHttpCaching(false);
            }
        }
        catch (Exception e2) {
            SolrException e2;
            boolean isTragic;
            if (req.getCore() != null && (isTragic = req.getCore().getCoreContainer().checkTragicException(req.getCore()))) {
                if (e2 instanceof SolrException) {
                    assert (((SolrException)e2).code() == 500);
                } else {
                    e2 = new SolrException(SolrException.ErrorCode.SERVER_ERROR, e2.getMessage(), (Throwable)e2);
                }
            }
            boolean incrementErrors = true;
            boolean isServerError = true;
            if (e2 instanceof SolrException) {
                SolrException se = e2;
                if (se.code() == SolrException.ErrorCode.CONFLICT.code) {
                    incrementErrors = false;
                } else if (se.code() >= 400 && se.code() < 500) {
                    isServerError = false;
                }
            } else if (e2 instanceof SyntaxError) {
                isServerError = false;
                e2 = new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e2);
            }
            rsp.setException(e2);
            if (incrementErrors) {
                SolrException.log(log, e2);
                this.numErrors.mark();
                if (isServerError) {
                    this.numServerErrors.mark();
                } else {
                    this.numClientErrors.mark();
                }
            }
        }
        finally {
            dTimer.stop();
            long elapsed = timer.stop();
            this.totalTime.inc(elapsed);
            if (distrib) {
                this.distribTotalTime.inc(elapsed);
            } else {
                this.localTotalTime.inc(elapsed);
            }
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public abstract String getDescription();

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.QUERY;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        return null;
    }

    public static SolrRequestHandler getRequestHandler(String handlerName, PluginBag<SolrRequestHandler> reqHandlers) {
        if (handlerName == null) {
            return null;
        }
        SolrRequestHandler handler = reqHandlers.get(handlerName);
        int idx = 0;
        if (handler == null) {
            while ((idx = handlerName.indexOf(47, idx + 1)) > 0) {
                String firstPart = handlerName.substring(0, idx);
                handler = reqHandlers.get(firstPart);
                if (handler == null || !(handler instanceof NestedRequestHandler)) continue;
                return ((NestedRequestHandler)((Object)handler)).getSubHandler(handlerName.substring(idx));
            }
        }
        return handler;
    }

    public void setPluginInfo(PluginInfo pluginInfo) {
        if (this.pluginInfo == null) {
            this.pluginInfo = pluginInfo;
        }
    }

    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    @Override
    public Collection<Api> getApis() {
        return ImmutableList.of((Object)new ApiBag.ReqHandlerToApi(this, ApiBag.constructSpec(this.pluginInfo)));
    }
}

