/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.ConfigOverlay;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestParams;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.pkg.PackageAPI;
import org.apache.solr.pkg.PackageListeners;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaManager;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrConfigHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String CONFIGSET_EDITING_DISABLED_ARG = "disable.configEdit";
    public static final boolean configEditing_disabled = Boolean.getBoolean("disable.configEdit");
    private static final Map<String, SolrConfig.SolrPluginInfo> namedPlugins;
    private Lock reloadLock = new ReentrantLock(true);
    private boolean isImmutableConfigSet = false;
    private static Set<String> subPaths;
    public static final String SET_PROPERTY = "set-property";
    public static final String UNSET_PROPERTY = "unset-property";
    public static final String SET_USER_PROPERTY = "set-user-property";
    public static final String UNSET_USER_PROPERTY = "unset-user-property";
    public static final String SET = "set";
    public static final String UPDATE = "update";
    public static final String CREATE = "create";
    private static Set<String> cmdPrefixes;

    public Lock getReloadLock() {
        return this.reloadLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        RequestHandlerUtils.setWt(req, "json");
        String httpMethod = (String)req.getContext().get("httpMethod");
        Command command = new Command(req, rsp, httpMethod);
        if ("POST".equals(httpMethod)) {
            if (configEditing_disabled || this.isImmutableConfigSet) {
                String reason = configEditing_disabled ? "due to disable.configEdit" : "because ConfigSet is immutable";
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, " solrconfig editing is not enabled " + reason);
            }
            try {
                command.handlePOST();
            }
            finally {
                RequestHandlerUtils.addExperimentalFormatWarning(rsp);
            }
        } else {
            command.handleGET();
        }
    }

    @Override
    public void inform(SolrCore core) {
        this.isImmutableConfigSet = SolrConfigHandler.getImmutable(core);
    }

    public static boolean getImmutable(SolrCore core) {
        NamedList configSetProperties = core.getConfigSetProperties();
        if (configSetProperties == null) {
            return false;
        }
        Object immutable = configSetProperties.get("immutable");
        return immutable != null && Boolean.parseBoolean(immutable.toString());
    }

    public static String validateName(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.') continue;
            return StrUtils.formatString("''{0}'' name should only have chars [a-zA-Z_-.0-9] ", s);
        }
        return null;
    }

    @Override
    public SolrRequestHandler getSubHandler(String path) {
        if (subPaths.contains(path)) {
            return this;
        }
        if (path.startsWith("/params/")) {
            return this;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Edit solrconfig.xml";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForAllReplicasState(String collection, ZkController zkController, String prop, int expectedVersion, int maxWaitSecs) {
        RTimer timer = new RTimer();
        ArrayList<PerReplicaCallable> concurrentTasks = new ArrayList<PerReplicaCallable>();
        for (String coreUrl : SolrConfigHandler.getActiveReplicaCoreUrls(zkController, collection)) {
            PerReplicaCallable e = new PerReplicaCallable(coreUrl, prop, expectedVersion, maxWaitSecs);
            concurrentTasks.add(e);
        }
        if (concurrentTasks.isEmpty()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info(StrUtils.formatString("Waiting up to {0} secs for {1} replicas to set the property {2} to be of version {3} for collection {4}", maxWaitSecs, concurrentTasks.size(), prop, expectedVersion, collection));
        }
        int poolSize = Math.min(concurrentTasks.size(), 10);
        ExecutorService parallelExecutor = ExecutorUtil.newMDCAwareFixedThreadPool(poolSize, new SolrNamedThreadFactory("solrHandlerExecutor"));
        try {
            List results = parallelExecutor.invokeAll(concurrentTasks, maxWaitSecs, TimeUnit.SECONDS);
            ArrayList<String> failedList = null;
            for (int f = 0; f < results.size(); ++f) {
                Boolean success = false;
                Future next = results.get(f);
                if (next.isDone() && !next.isCancelled()) {
                    try {
                        success = (Boolean)next.get();
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
                if (success.booleanValue()) continue;
                String coreUrl = ((PerReplicaCallable)concurrentTasks.get((int)f)).coreUrl;
                log.warn("Core {} could not get the expected version {}", (Object)coreUrl, (Object)expectedVersion);
                if (failedList == null) {
                    failedList = new ArrayList<String>();
                }
                failedList.add(coreUrl);
            }
            if (failedList != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, StrUtils.formatString("{0} out of {1} the property {2} to be of version {3} within {4} seconds! Failed cores: {5}", failedList.size(), concurrentTasks.size() + 1, prop, expectedVersion, maxWaitSecs, failedList));
            }
        }
        catch (InterruptedException ie) {
            log.warn(StrUtils.formatString("Core  was interrupted . trying to set the property {1} to version {2} to propagate to {3} replicas for collection {4}", prop, expectedVersion, concurrentTasks.size(), collection));
            Thread.currentThread().interrupt();
        }
        finally {
            ExecutorUtil.shutdownAndAwaitTermination(parallelExecutor);
        }
        if (log.isInfoEnabled()) {
            log.info("Took {}ms to set the property {} to be of version {} for collection {}", new Object[]{timer.getTime(), prop, expectedVersion, collection});
        }
    }

    public static List<String> getActiveReplicaCoreUrls(ZkController zkController, String collection) {
        ArrayList<String> activeReplicaCoreUrls = new ArrayList<String>();
        ClusterState clusterState = zkController.getZkStateReader().getClusterState();
        Set<String> liveNodes = clusterState.getLiveNodes();
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (docCollection != null && docCollection.getActiveSlices() != null && docCollection.getActiveSlices().size() > 0) {
            Collection<Slice> activeSlices = docCollection.getActiveSlices();
            for (Slice next : activeSlices) {
                Map<String, Replica> replicasMap = next.getReplicasMap();
                if (replicasMap == null) continue;
                for (Map.Entry<String, Replica> entry : replicasMap.entrySet()) {
                    Replica replica = entry.getValue();
                    if (replica.getState() != Replica.State.ACTIVE || !liveNodes.contains(replica.getNodeName())) continue;
                    activeReplicaCoreUrls.add(replica.getCoreUrl());
                }
            }
        }
        return activeReplicaCoreUrls;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        switch (ctx.getHttpMethod()) {
            case "GET": {
                return PermissionNameProvider.Name.CONFIG_READ_PERM;
            }
            case "POST": {
                return PermissionNameProvider.Name.CONFIG_EDIT_PERM;
            }
        }
        return null;
    }

    @Override
    public Collection<Api> getApis() {
        return ApiBag.wrapRequestHandlers(this, "core.config", "core.config.Commands", "core.config.Params", "core.config.Params.Commands");
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    static {
        HashMap<String, SolrConfig.SolrPluginInfo> map = new HashMap<String, SolrConfig.SolrPluginInfo>();
        for (SolrConfig.SolrPluginInfo plugin : SolrConfig.plugins) {
            if (!plugin.options.contains((Object)SolrConfig.PluginOpts.REQUIRE_NAME) && !plugin.options.contains((Object)SolrConfig.PluginOpts.REQUIRE_NAME_IN_OVERLAY)) continue;
            map.put(plugin.getCleanTag().toLowerCase(Locale.ROOT), plugin);
        }
        namedPlugins = Collections.unmodifiableMap(map);
        subPaths = new HashSet<String>(Arrays.asList("/overlay", "/params", "/updateHandler", "/query", "/jmx", "/requestDispatcher", "/znodeVersion"));
        for (SolrConfig.SolrPluginInfo solrPluginInfo : SolrConfig.plugins) {
            subPaths.add("/" + solrPluginInfo.getCleanTag());
        }
        cmdPrefixes = ImmutableSet.of((Object)CREATE, (Object)UPDATE, (Object)"delete", (Object)"add");
    }

    private static class PerReplicaCallable
    extends SolrRequest
    implements Callable<Boolean> {
        String coreUrl;
        String prop;
        int expectedZkVersion;
        Number remoteVersion = null;
        int maxWait;

        PerReplicaCallable(String coreUrl, String prop, int expectedZkVersion, int maxWait) {
            super(SolrRequest.METHOD.GET, "/config/znodeVersion");
            this.coreUrl = coreUrl;
            this.expectedZkVersion = expectedZkVersion;
            this.prop = prop;
            this.maxWait = maxWait;
        }

        @Override
        public SolrParams getParams() {
            return new ModifiableSolrParams().set(this.prop, this.expectedZkVersion).set("wt", "javabin");
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Boolean call() throws Exception {
            timer = new RTimer();
            attempts = 0;
            solr = new HttpSolrClient.Builder(this.coreUrl).build();
            var4_4 = null;
            while (true) {
                block18: {
                    try {
                        timeElapsed = (long)timer.getTime() / 1000L;
                        if (timeElapsed >= (long)this.maxWait) {
                            var7_9 = false;
                            if (solr == null) return var7_9;
                            if (var4_4 == null) break block18;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) break;
                        SolrConfigHandler.access$300().warn("Failed to get /schema/zkversion from {} due to: ", (Object)this.coreUrl, (Object)e);
                    }
                    catch (Throwable var5_8) {
                        try {
                            var4_4 = var5_8;
                            throw var5_8;
                        }
                        catch (Throwable var9_12) {
                            if (solr == null) throw var9_12;
                            if (var4_4 == null) {
                                solr.close();
                                throw var9_12;
                            }
                            try {
                                solr.close();
                                throw var9_12;
                            }
                            catch (Throwable var10_13) {
                                var4_4.addSuppressed(var10_13);
                                throw var9_12;
                            }
                        }
                    }
                    try {
                        solr.close();
                        return var7_9;
                    }
                    catch (Throwable var8_11) {
                        var4_4.addSuppressed(var8_11);
                        return var7_9;
                    }
                }
                solr.close();
                return var7_9;
lbl-1000:
                // 1 sources

                {
                    SolrConfigHandler.access$300().info("Time elapsed : {} secs, maxWait {}", (Object)timeElapsed, (Object)this.maxWait);
                    Thread.sleep(100L);
                    resp = solr.httpUriRequest((SolrRequest)this).future.get();
                    if (resp != null && (m = (Map)resp.get("znodeVersion")) != null) {
                        this.remoteVersion = (Number)m.get(this.prop);
                        if (this.remoteVersion != null && this.remoteVersion.intValue() >= this.expectedZkVersion) break;
                    }
                    ++attempts;
                    if (!SolrConfigHandler.access$300().isInfoEnabled()) continue;
                    SolrConfigHandler.access$300().info(StrUtils.formatString("Could not get expectedVersion {0} from {1} for prop {2}   after {3} attempts", new Object[]{this.expectedZkVersion, this.coreUrl, this.prop, attempts}));
                }
            }
            if (solr == null) return true;
            if (var4_4 != null) {
                try {
                    solr.close();
                    return true;
                }
                catch (Throwable var5_7) {
                    var4_4.addSuppressed(var5_7);
                    return true;
                }
            }
            solr.close();
            return true;
        }

        protected SolrResponse createResponse(SolrClient client) {
            return null;
        }
    }

    private class Command {
        private final SolrQueryRequest req;
        private final SolrQueryResponse resp;
        private final String method;
        private String path;
        List<String> parts;

        private Command(SolrQueryRequest req, SolrQueryResponse resp, String httpMethod) {
            this.req = req;
            this.resp = resp;
            this.method = httpMethod;
            this.path = (String)req.getContext().get("path");
            if (this.path == null) {
                this.path = this.getDefaultPath();
            }
            this.parts = StrUtils.splitSmart(this.path, '/', true);
        }

        private String getDefaultPath() {
            return "/config";
        }

        private void handleGET() {
            if (this.parts.size() == 1) {
                this.resp.add("config", this.getConfigDetails(null, this.req));
            } else if ("overlay".equals(this.parts.get(1))) {
                this.resp.add("overlay", this.req.getCore().getSolrConfig().getOverlay());
            } else if ("params".equals(this.parts.get(1))) {
                if (this.parts.size() == 3) {
                    RequestParams params = this.req.getCore().getSolrConfig().getRequestParams();
                    RequestParams.ParamSet p = params.getParams(this.parts.get(2));
                    LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                    m.put("znodeVersion", params.getZnodeVersion());
                    if (p != null) {
                        m.put("params", Utils.makeMap(this.parts.get(2), p.toMap(new LinkedHashMap<String, Object>())));
                    }
                    this.resp.add("response", m);
                } else {
                    this.resp.add("response", this.req.getCore().getSolrConfig().getRequestParams());
                }
            } else if ("znodeVersion".equals(this.parts.get(1))) {
                this.resp.add("znodeVersion", Utils.makeMap("overlay", this.req.getCore().getSolrConfig().getOverlay().getZnodeVersion(), "params", this.req.getCore().getSolrConfig().getRequestParams().getZnodeVersion()));
                boolean isStale = false;
                int expectedVersion = this.req.getParams().getInt("overlay", -1);
                int actualVersion = this.req.getCore().getSolrConfig().getOverlay().getZnodeVersion();
                if (expectedVersion > actualVersion) {
                    log.info("expecting overlay version {} but my version is {}", (Object)expectedVersion, (Object)actualVersion);
                    isStale = true;
                } else if (expectedVersion != -1) {
                    log.info("I already have the expected version {} of config", (Object)expectedVersion);
                }
                expectedVersion = this.req.getParams().getInt("params", -1);
                actualVersion = this.req.getCore().getSolrConfig().getRequestParams().getZnodeVersion();
                if (expectedVersion > actualVersion) {
                    log.info("expecting params version {} but my version is {}", (Object)expectedVersion, (Object)actualVersion);
                    isStale = true;
                } else if (expectedVersion != -1) {
                    log.info("I already have the expected version {} of params", (Object)expectedVersion);
                }
                if (isStale && this.req.getCore().getResourceLoader() instanceof ZkSolrResourceLoader) {
                    new Thread(() -> {
                        if (!SolrConfigHandler.this.reloadLock.tryLock()) {
                            log.info("Another reload is in progress . Not doing anything");
                            return;
                        }
                        try {
                            log.info("Trying to update my configs");
                            SolrCore.getConfListener(this.req.getCore(), (ZkSolrResourceLoader)this.req.getCore().getResourceLoader()).run();
                        }
                        catch (Exception e) {
                            log.error("Unable to refresh conf ", (Throwable)e);
                        }
                        finally {
                            SolrConfigHandler.this.reloadLock.unlock();
                        }
                    }, SolrConfigHandler.class.getSimpleName() + "-refreshconf").start();
                } else if (log.isInfoEnabled()) {
                    log.info("isStale {} , resourceloader {}", (Object)isStale, (Object)this.req.getCore().getResourceLoader().getClass().getName());
                }
            } else {
                Map<String, Object> pluginNameVsPluginInfo;
                Map<String, Object> m = this.getConfigDetails(this.parts.get(1), this.req);
                Map<String, Object> val = Utils.makeMap(this.parts.get(1), m.get(this.parts.get(1)));
                String componentName = this.req.getParams().get("componentName");
                if (componentName != null && (pluginNameVsPluginInfo = (Map<String, Object>)val.get(this.parts.get(1))) != null) {
                    Map<String, Object> o = pluginNameVsPluginInfo instanceof MapSerializable ? pluginNameVsPluginInfo : pluginNameVsPluginInfo.get(componentName);
                    Map<String, Object> pluginInfo = o instanceof MapSerializable ? ((MapSerializable)((Object)o)).toMap(new LinkedHashMap<String, Object>()) : o;
                    val.put(this.parts.get(1), pluginNameVsPluginInfo instanceof PluginInfo ? pluginInfo : Utils.makeMap(componentName, pluginInfo));
                    if (this.req.getParams().getBool("meta", false)) {
                        List<PackageListeners.Listener> listeners = this.req.getCore().getPackageListeners().getListeners();
                        for (PackageListeners.Listener listener : listeners) {
                            Map<String, PackageAPI.PkgVersion> infos = listener.packageDetails();
                            if (infos == null || infos.isEmpty()) continue;
                            infos.forEach((s, mapWriter) -> {
                                if (s.equals(pluginInfo.get("class"))) {
                                    pluginInfo.put("_packageinfo_", mapWriter);
                                }
                            });
                        }
                    }
                }
                this.resp.add("config", val);
            }
        }

        private Map<String, Object> getConfigDetails(String componentType, SolrQueryRequest req) {
            String componentName = componentType == null ? null : req.getParams().get("componentName");
            boolean showParams = req.getParams().getBool("expandParams", false);
            Map<String, Object> map = this.req.getCore().getSolrConfig().toMap(new LinkedHashMap<String, Object>());
            if (componentType != null && !"requestHandler".equals(componentType)) {
                return map;
            }
            LinkedHashMap<String, PluginInfo> reqHandlers = (LinkedHashMap<String, PluginInfo>)map.get("requestHandler");
            if (reqHandlers == null) {
                reqHandlers = new LinkedHashMap<String, PluginInfo>();
                map.put("requestHandler", reqHandlers);
            }
            List<PluginInfo> plugins = this.req.getCore().getImplicitHandlers();
            for (PluginInfo pluginInfo : plugins) {
                if (!"requestHandler".equals(pluginInfo.type) || reqHandlers.containsKey(pluginInfo.name)) continue;
                reqHandlers.put(pluginInfo.name, pluginInfo);
            }
            if (!showParams) {
                return map;
            }
            for (Object object : reqHandlers.entrySet()) {
                Map.Entry e = (Map.Entry)object;
                if (componentName != null && !e.getKey().equals(componentName)) continue;
                Map<String, Object> m = this.expandUseParams(req, e.getValue());
                e.setValue(m);
            }
            return map;
        }

        private Map<String, Object> expandUseParams(SolrQueryRequest req, Object plugin) {
            Map<String, Object> pluginInfo = null;
            if (plugin instanceof Map) {
                pluginInfo = (Map<String, Object>)plugin;
            } else if (plugin instanceof PluginInfo) {
                pluginInfo = ((PluginInfo)plugin).toMap(new LinkedHashMap<String, Object>());
            }
            String useParams = (String)pluginInfo.get("useParams");
            String useParamsInReq = req.getOriginalParams().get("useParams");
            if (useParams != null || useParamsInReq != null) {
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                pluginInfo.put("_useParamsExpanded_", m);
                ArrayList<String> params = new ArrayList<String>();
                if (useParams != null) {
                    params.addAll(StrUtils.splitSmart(useParams, ','));
                }
                if (useParamsInReq != null) {
                    params.addAll(StrUtils.splitSmart(useParamsInReq, ','));
                }
                for (String param : params) {
                    RequestParams.ParamSet p = this.req.getCore().getSolrConfig().getRequestParams().getParams(param);
                    if (p != null) {
                        m.put(param, p);
                        continue;
                    }
                    m.put(param, "[NOT AVAILABLE]");
                }
                LocalSolrQueryRequest r = new LocalSolrQueryRequest(req.getCore(), req.getOriginalParams());
                r.getContext().put("useParams", useParams);
                NamedList nl = new PluginInfo((String)"requestHandler", pluginInfo).initArgs;
                SolrPluginUtils.setDefaults(r, RequestHandlerBase.getSolrParamsFromNamedList(nl, "defaults"), RequestHandlerBase.getSolrParamsFromNamedList(nl, "appends"), RequestHandlerBase.getSolrParamsFromNamedList(nl, "invariants"));
                MapSolrParams mask = new MapSolrParams((Map<String, String>)ImmutableMap.builder().put((Object)"componentName", (Object)"").put((Object)"expandParams", (Object)"").build());
                pluginInfo.put("_effectiveParams_", SolrParams.wrapDefaults(mask, r.getParams()));
            }
            return pluginInfo;
        }

        private void handlePOST() throws IOException {
            List<CommandOperation> ops = CommandOperation.readCommands(this.req.getContentStreams(), this.resp.getValues());
            if (ops == null) {
                return;
            }
            try {
                while (true) {
                    ArrayList<CommandOperation> opsCopy = new ArrayList<CommandOperation>(ops.size());
                    for (CommandOperation op : ops) {
                        opsCopy.add(op.getCopy());
                    }
                    try {
                        if (this.parts.size() > 1 && "params".equals(this.parts.get(1))) {
                            RequestParams params = RequestParams.getFreshRequestParams(this.req.getCore().getResourceLoader(), this.req.getCore().getSolrConfig().getRequestParams());
                            this.handleParams(opsCopy, params);
                        } else {
                            ConfigOverlay overlay = SolrConfig.getConfigOverlay(this.req.getCore().getResourceLoader());
                            this.handleCommands(opsCopy, overlay);
                        }
                    }
                    catch (ZkController.ResourceModifiedInZkException e) {
                        if (!log.isInfoEnabled()) continue;
                        log.info("Race condition, the node is modified in ZK by someone else", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.resp.setException(e);
                this.resp.add("errorMessages", Collections.singletonList(SchemaManager.getErrorStr(e)));
            }
        }

        private void handleParams(ArrayList<CommandOperation> ops, RequestParams params) {
            block11: for (CommandOperation op : ops) {
                switch (op.name) {
                    case "set": 
                    case "update": {
                        Map<String, Object> map = op.getDataMap();
                        if (op.hasError()) break;
                        for (Map.Entry entry : map.entrySet()) {
                            Map val;
                            String key = (String)entry.getKey();
                            if (Strings.isNullOrEmpty((String)key)) {
                                op.addError("null key ");
                                continue;
                            }
                            String err = SolrConfigHandler.validateName(key = key.trim());
                            if (err != null) {
                                op.addError(err);
                                continue;
                            }
                            try {
                                val = (Map)entry.getValue();
                            }
                            catch (Exception e1) {
                                op.addError("invalid params for key : " + key);
                                continue;
                            }
                            if (val.containsKey("")) {
                                op.addError("Empty keys are not allowed in params");
                                continue;
                            }
                            RequestParams.ParamSet old = params.getParams(key);
                            if (op.name.equals(SolrConfigHandler.UPDATE)) {
                                if (old == null) {
                                    op.addError(StrUtils.formatString("unknown paramset {0} cannot update ", key));
                                    continue;
                                }
                                params = params.setParams(key, old.update(val));
                                continue;
                            }
                            Long version = old == null ? 0L : old.getVersion() + 1L;
                            params = params.setParams(key, RequestParams.createParamSet(val, version));
                        }
                        continue block11;
                    }
                    case "delete": {
                        List<String> name = op.getStrs("");
                        if (op.hasError()) break;
                        for (String string : name) {
                            if (params.getParams(string) == null) {
                                op.addError(StrUtils.formatString("Could not delete. No such params ''{0}'' exist", string));
                            }
                            params = params.setParams(string, null);
                        }
                        continue block11;
                    }
                    default: {
                        op.unknownOperation();
                    }
                }
            }
            List<Map> errs = CommandOperation.captureErrors(ops);
            if (!errs.isEmpty()) {
                throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, "error processing params", errs);
            }
            SolrResourceLoader loader = this.req.getCore().getResourceLoader();
            if (loader instanceof ZkSolrResourceLoader) {
                ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)loader;
                if (ops.isEmpty()) {
                    ZkController.touchConfDir(zkLoader);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("persisting params data : {}", (Object)Utils.toJSONString(params.toMap(new LinkedHashMap<String, Object>())));
                    }
                    int latestVersion = ZkController.persistConfigResourceToZooKeeper(zkLoader, params.getZnodeVersion(), "params.json", params.toByteArray(), true);
                    log.debug("persisted to version : {} ", (Object)latestVersion);
                    SolrConfigHandler.waitForAllReplicasState(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName(), this.req.getCore().getCoreContainer().getZkController(), "params", latestVersion, 30);
                }
            } else {
                SolrResourceLoader.persistConfLocally(loader, "params.json", params.toByteArray());
                this.req.getCore().getSolrConfig().refreshRequestParams();
            }
        }

        private void handleCommands(List<CommandOperation> ops, ConfigOverlay overlay) throws IOException {
            block12: for (CommandOperation op : ops) {
                switch (op.name) {
                    case "set-property": {
                        overlay = this.applySetProp(op, overlay);
                        continue block12;
                    }
                    case "unset-property": {
                        overlay = this.applyUnset(op, overlay);
                        continue block12;
                    }
                    case "set-user-property": {
                        overlay = this.applySetUserProp(op, overlay);
                        continue block12;
                    }
                    case "unset-user-property": {
                        overlay = this.applyUnsetUserProp(op, overlay);
                        continue block12;
                    }
                }
                List<String> pcs = StrUtils.splitSmart(op.name.toLowerCase(Locale.ROOT), '-');
                if (pcs.size() != 2) {
                    op.addError(StrUtils.formatString("Unknown operation ''{0}'' ", op.name));
                    continue;
                }
                String prefix = pcs.get(0);
                String name = pcs.get(1);
                if (cmdPrefixes.contains(prefix) && namedPlugins.containsKey(name)) {
                    SolrConfig.SolrPluginInfo info = (SolrConfig.SolrPluginInfo)namedPlugins.get(name);
                    if ("delete".equals(prefix)) {
                        overlay = this.deleteNamedComponent(op, overlay, info.getCleanTag());
                        continue;
                    }
                    overlay = this.updateNamedPlugin(info, op, overlay, prefix.equals(SolrConfigHandler.CREATE) || prefix.equals("add"));
                    continue;
                }
                op.unknownOperation();
            }
            List<Map> errs = CommandOperation.captureErrors(ops);
            if (!errs.isEmpty()) {
                log.error("ERROR:{}", (Object)Utils.toJSONString(errs));
                throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, "error processing commands", errs);
            }
            SolrResourceLoader loader = this.req.getCore().getResourceLoader();
            if (loader instanceof ZkSolrResourceLoader) {
                int latestVersion = ZkController.persistConfigResourceToZooKeeper((ZkSolrResourceLoader)loader, overlay.getZnodeVersion(), "configoverlay.json", overlay.toByteArray(), true);
                log.debug("Executed config commands successfully and persisted to ZK {}", ops);
                SolrConfigHandler.waitForAllReplicasState(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName(), this.req.getCore().getCoreContainer().getZkController(), "overlay", latestVersion, 30);
            } else {
                SolrResourceLoader.persistConfLocally(loader, "configoverlay.json", overlay.toByteArray());
                this.req.getCore().getCoreContainer().reload(this.req.getCore().getName(), this.req.getCore().uniqueId);
                log.info("Executed config commands successfully and persisted to File System {}", ops);
            }
        }

        private ConfigOverlay deleteNamedComponent(CommandOperation op, ConfigOverlay overlay, String typ) {
            String name = op.getStr("");
            if (op.hasError()) {
                return overlay;
            }
            if (overlay.getNamedPlugins(typ).containsKey(name)) {
                return overlay.deleteNamedPlugin(name, typ);
            }
            op.addError(StrUtils.formatString("NO such {0} ''{1}'' ", typ, name));
            return overlay;
        }

        private ConfigOverlay updateNamedPlugin(SolrConfig.SolrPluginInfo info, CommandOperation op, ConfigOverlay overlay, boolean isCeate) {
            String name = op.getStr("name");
            String clz = info.options.contains((Object)SolrConfig.PluginOpts.REQUIRE_CLASS) ? op.getStr("class") : op.getStr("class", null);
            op.getMap("defaults", null);
            op.getMap("invariants", null);
            op.getMap("appends", null);
            if (op.hasError()) {
                return overlay;
            }
            if (info.clazz == PluginBag.RuntimeLib.class) {
                if (!PluginBag.RuntimeLib.isEnabled()) {
                    op.addError("Solr not started with -Denable.runtime.lib=true");
                    return overlay;
                }
                try (PluginBag.RuntimeLib rtl = new PluginBag.RuntimeLib(this.req.getCore());){
                    rtl.init(new PluginInfo(info.tag, op.getDataMap()));
                }
                catch (Exception e) {
                    op.addError(e.getMessage());
                    log.error("can't load this plugin ", (Throwable)e);
                    return overlay;
                }
            }
            if (!this.verifyClass(op, clz, info.clazz)) {
                return overlay;
            }
            if (this.pluginExists(info, overlay, name)) {
                if (isCeate) {
                    op.addError(StrUtils.formatString(" ''{0}'' already exists . Do an ''{1}'' , if you want to change it ", name, "update-" + info.getTagCleanLower()));
                    return overlay;
                }
                return overlay.addNamedPlugin(op.getDataMap(), info.getCleanTag());
            }
            if (isCeate) {
                return overlay.addNamedPlugin(op.getDataMap(), info.getCleanTag());
            }
            op.addError(StrUtils.formatString(" ''{0}'' does not exist . Do an ''{1}'' , if you want to create it ", name, "create-" + info.getTagCleanLower()));
            return overlay;
        }

        private boolean pluginExists(SolrConfig.SolrPluginInfo info, ConfigOverlay overlay, String name) {
            List<PluginInfo> l = this.req.getCore().getSolrConfig().getPluginInfos(info.clazz.getName());
            for (PluginInfo pluginInfo : l) {
                if (!name.equals(pluginInfo.name)) continue;
                return true;
            }
            return overlay.getNamedPlugins(info.getCleanTag()).containsKey(name);
        }

        private boolean verifyClass(CommandOperation op, String clz, Class expected) {
            if (clz == null) {
                return true;
            }
            if (!"true".equals(String.valueOf(op.getStr("runtimeLib", null)))) {
                PluginInfo info = new PluginInfo("requestHandler", op.getDataMap());
                try {
                    if (expected == Expressible.class) {
                        SolrResourceLoader resourceLoader = info.pkgName == null ? this.req.getCore().getResourceLoader() : this.req.getCore().getResourceLoader(info.pkgName);
                        resourceLoader.findClass(info.className, expected);
                    } else {
                        this.req.getCore().createInitInstance(info, expected, clz, "");
                    }
                }
                catch (Exception e) {
                    log.error("Error checking plugin : ", (Throwable)e);
                    op.addError(e.getMessage());
                    return false;
                }
            }
            return true;
        }

        private ConfigOverlay applySetUserProp(CommandOperation op, ConfigOverlay overlay) {
            Map<String, Object> m = op.getDataMap();
            if (op.hasError()) {
                return overlay;
            }
            for (Map.Entry<String, Object> e : m.entrySet()) {
                String name = e.getKey();
                Object val = e.getValue();
                overlay = overlay.setUserProperty(name, val);
            }
            return overlay;
        }

        private ConfigOverlay applyUnsetUserProp(CommandOperation op, ConfigOverlay overlay) {
            List<String> name = op.getStrs("");
            if (op.hasError()) {
                return overlay;
            }
            for (String o : name) {
                if (!overlay.getUserProps().containsKey(o)) {
                    op.addError(StrUtils.formatString("No such property ''{0}''", name));
                    continue;
                }
                overlay = overlay.unsetUserProperty(o);
            }
            return overlay;
        }

        private ConfigOverlay applyUnset(CommandOperation op, ConfigOverlay overlay) {
            List<String> name = op.getStrs("");
            if (op.hasError()) {
                return overlay;
            }
            for (String o : name) {
                if (!ConfigOverlay.isEditableProp(o, false, null)) {
                    op.addError(StrUtils.formatString("''{0}'' is not an editable property", name));
                    continue;
                }
                overlay = overlay.unsetProperty(o);
            }
            return overlay;
        }

        private ConfigOverlay applySetProp(CommandOperation op, ConfigOverlay overlay) {
            Map<String, Object> m = op.getDataMap();
            if (op.hasError()) {
                return overlay;
            }
            for (Map.Entry<String, Object> e : m.entrySet()) {
                Object val;
                String name;
                block14: {
                    name = e.getKey();
                    val = e.getValue();
                    Class typ = ConfigOverlay.checkEditable(name, false, null);
                    if (typ == null) {
                        op.addError(StrUtils.formatString("''{0}'' is not an editable property", name));
                        continue;
                    }
                    if (val != null) {
                        if (typ == String.class) {
                            val = val.toString();
                        }
                        String typeErr = "Property {0} must be of {1} type ";
                        if (typ == Boolean.class) {
                            try {
                                val = Boolean.parseBoolean(val.toString());
                                break block14;
                            }
                            catch (Exception exp) {
                                op.addError(StrUtils.formatString(typeErr, name, typ.getSimpleName()));
                                continue;
                            }
                        }
                        if (typ == Integer.class) {
                            try {
                                val = Integer.parseInt(val.toString());
                                break block14;
                            }
                            catch (Exception exp) {
                                op.addError(StrUtils.formatString(typeErr, name, typ.getSimpleName()));
                                continue;
                            }
                        }
                        if (typ == Float.class) {
                            try {
                                val = Float.valueOf(Float.parseFloat(val.toString()));
                            }
                            catch (Exception exp) {
                                op.addError(StrUtils.formatString(typeErr, name, typ.getSimpleName()));
                                continue;
                            }
                        }
                    }
                }
                overlay = overlay.setProperty(name, val);
            }
            return overlay;
        }
    }
}

