/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.ShardParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.handler.component.CloudReplicaSource;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ReplicaSource;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardRequestor;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.handler.component.StandaloneReplicaSource;
import org.apache.solr.request.SolrQueryRequest;

public class HttpShardHandler
extends ShardHandler {
    public static String ONLY_NRT_REPLICAS = "distribOnlyRealtime";
    final HttpShardHandlerFactory httpShardHandlerFactory;
    private CompletionService<ShardResponse> completionService;
    private Set<Future<ShardResponse>> pending;
    private Http2SolrClient httpClient;

    public HttpShardHandler(HttpShardHandlerFactory httpShardHandlerFactory, Http2SolrClient httpClient) {
        this.httpClient = httpClient;
        this.httpShardHandlerFactory = httpShardHandlerFactory;
        this.completionService = httpShardHandlerFactory.newCompletionService();
        this.pending = new HashSet<Future<ShardResponse>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(ShardRequest sreq, String shard, ModifiableSolrParams params) {
        ShardRequestor shardRequestor = new ShardRequestor(sreq, shard, params, this);
        try {
            shardRequestor.init();
            this.pending.add(this.completionService.submit(shardRequestor));
        }
        finally {
            shardRequestor.end();
        }
    }

    protected NamedList<Object> request(String url, SolrRequest req) throws IOException, SolrServerException {
        req.setBasePath(url);
        return this.httpClient.request(req);
    }

    protected QueryRequest makeQueryRequest(ShardRequest sreq, ModifiableSolrParams params, String shard) {
        return new QueryRequest(params);
    }

    protected ShardResponse transfomResponse(ShardRequest sreq, ShardResponse rsp, String shard) {
        return rsp;
    }

    @Override
    public ShardResponse takeCompletedIncludingErrors() {
        return this.take(false);
    }

    @Override
    public ShardResponse takeCompletedOrError() {
        return this.take(true);
    }

    private ShardResponse take(boolean bailOnError) {
        while (this.pending.size() > 0) {
            try {
                Future<ShardResponse> future = this.completionService.take();
                this.pending.remove(future);
                ShardResponse rsp = future.get();
                if (bailOnError && rsp.getException() != null) {
                    return rsp;
                }
                rsp.getShardRequest().responses.add(rsp);
                if (rsp.getShardRequest().responses.size() != rsp.getShardRequest().actualShards.length) continue;
                return rsp;
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Impossible Exception", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void cancelAll() {
        for (Future<ShardResponse> future : this.pending) {
            future.cancel(false);
        }
    }

    @Override
    public void prepDistributed(ResponseBuilder rb) {
        String shards_start;
        ReplicaSource replicaSource;
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        String shards = params.get("shards");
        CoreDescriptor coreDescriptor = req.getCore().getCoreDescriptor();
        CloudDescriptor cloudDescriptor = coreDescriptor.getCloudDescriptor();
        ZkController zkController = req.getCore().getCoreContainer().getZkController();
        ReplicaListTransformer replicaListTransformer = this.httpShardHandlerFactory.getReplicaListTransformer(req);
        HttpShardHandlerFactory.WhitelistHostChecker hostChecker = this.httpShardHandlerFactory.getWhitelistHostChecker();
        if (shards != null && zkController == null && hostChecker.isWhitelistHostCheckingEnabled() && !hostChecker.hasExplicitWhitelist()) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "HttpShardHandlerFactory shardsWhitelist not configured but required (in lieu of ZkController and ClusterState) when using the 'shards' parameter. set -Dsolr.disable.shardsWhitelist=true to disable shards whitelist checks");
        }
        if (zkController != null) {
            boolean onlyNrt = Boolean.TRUE == req.getContext().get(ONLY_NRT_REPLICAS);
            replicaSource = new CloudReplicaSource.Builder().params(params).zkStateReader(zkController.getZkStateReader()).whitelistHostChecker(hostChecker).replicaListTransformer(replicaListTransformer).collection(cloudDescriptor.getCollectionName()).onlyNrt(onlyNrt).build();
            rb.slices = replicaSource.getSliceNames().toArray(new String[replicaSource.getSliceCount()]);
            if (this.canShortCircuit(rb.slices, onlyNrt, params, cloudDescriptor)) {
                rb.isDistrib = false;
                rb.shortCircuitedURL = ZkCoreNodeProps.getCoreUrl(zkController.getBaseUrl(), coreDescriptor.getName());
                return;
            }
            for (int i = 0; i < rb.slices.length; ++i) {
                if (ShardParams.getShardsTolerantAsBool(params) || !replicaSource.getReplicasBySlice(i).isEmpty()) continue;
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "no servers hosting shard: " + rb.slices[i]);
            }
        } else {
            replicaSource = new StandaloneReplicaSource.Builder().whitelistHostChecker(hostChecker).shards(shards).build();
            rb.slices = new String[replicaSource.getSliceCount()];
        }
        rb.shards = new String[rb.slices.length];
        for (int i = 0; i < rb.slices.length; ++i) {
            rb.shards[i] = HttpShardHandler.createSliceShardsStr(replicaSource.getReplicasBySlice(i));
        }
        String shards_rows = params.get("shards.rows");
        if (shards_rows != null) {
            rb.shards_rows = Integer.parseInt(shards_rows);
        }
        if ((shards_start = params.get("shards.start")) != null) {
            rb.shards_start = Integer.parseInt(shards_start);
        }
    }

    private static String createSliceShardsStr(List<String> shardUrls) {
        StringBuilder sliceShardsStr = new StringBuilder();
        boolean first = true;
        for (String shardUrl : shardUrls) {
            if (first) {
                first = false;
            } else {
                sliceShardsStr.append('|');
            }
            sliceShardsStr.append(shardUrl);
        }
        return sliceShardsStr.toString();
    }

    private boolean canShortCircuit(String[] slices, boolean onlyNrtReplicas, SolrParams params, CloudDescriptor cloudDescriptor) {
        String ourSlice = cloudDescriptor.getShardId();
        String ourCollection = cloudDescriptor.getCollectionName();
        if (!(slices.length != 1 || slices[0] == null || !slices[0].equals(ourSlice) && !slices[0].equals(ourCollection + "_" + ourSlice) || cloudDescriptor.getLastPublished() != Replica.State.ACTIVE || onlyNrtReplicas && cloudDescriptor.getReplicaType() != Replica.Type.NRT)) {
            boolean shortCircuit = params.getBool("shortCircuit", true);
            String targetHandler = params.get("shards.qt");
            shortCircuit = shortCircuit && targetHandler == null;
            return shortCircuit;
        }
        return false;
    }

    @Override
    public ShardHandlerFactory getShardHandlerFactory() {
        return this.httpShardHandlerFactory;
    }
}

