/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import java.util.Date;
import java.util.function.LongFunction;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.MapWriter;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;

class MultiFieldWriter
extends FieldWriter {
    private String field;
    private FieldType fieldType;
    private SchemaField schemaField;
    private boolean numeric;
    private CharsRefBuilder cref = new CharsRefBuilder();
    private final LongFunction<Object> bitsToValue;

    public MultiFieldWriter(String field, FieldType fieldType, SchemaField schemaField, boolean numeric) {
        this.field = field;
        this.fieldType = fieldType;
        this.schemaField = schemaField;
        this.numeric = numeric;
        this.bitsToValue = this.fieldType.isPointField() ? MultiFieldWriter.bitsToValue(fieldType) : null;
    }

    @Override
    public boolean write(SortDoc sortDoc, LeafReader reader, MapWriter.EntryWriter out, int fieldIndex) throws IOException {
        if (this.fieldType.isPointField()) {
            SortedNumericDocValues vals = DocValues.getSortedNumeric((LeafReader)reader, (String)this.field);
            if (!vals.advanceExact(sortDoc.docId)) {
                return false;
            }
            out.put((CharSequence)this.field, w -> {
                int count = vals.docValueCount();
                for (int i = 0; i < count; ++i) {
                    w.add(this.bitsToValue.apply(vals.nextValue()));
                }
            });
            return true;
        }
        SortedSetDocValues vals = DocValues.getSortedSet((LeafReader)reader, (String)this.field);
        if (vals.advance(sortDoc.docId) != sortDoc.docId) {
            return false;
        }
        out.put((CharSequence)this.field, w -> {
            long o;
            while ((o = vals.nextOrd()) != -1L) {
                BytesRef ref = vals.lookupOrd(o);
                this.fieldType.indexedToReadable(ref, this.cref);
                IndexableField f = this.fieldType.createField(this.schemaField, this.cref.toString());
                if (f == null) {
                    w.add(this.cref.toString());
                    continue;
                }
                w.add(this.fieldType.toObject(f));
            }
        });
        return true;
    }

    static LongFunction<Object> bitsToValue(FieldType fieldType) {
        switch (fieldType.getNumberType()) {
            case LONG: {
                return bits -> bits;
            }
            case DATE: {
                return bits -> new Date(bits);
            }
            case INTEGER: {
                return bits -> (int)bits;
            }
            case FLOAT: {
                return bits -> Float.valueOf(NumericUtils.sortableIntToFloat((int)((int)bits)));
            }
            case DOUBLE: {
                return bits -> NumericUtils.sortableLongToDouble((long)bits);
            }
        }
        throw new AssertionError((Object)("Unsupported NumberType: " + (Object)((Object)fieldType.getNumberType())));
    }
}

