/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request.json;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.json.JSONUtil;
import org.apache.solr.request.json.JsonQueryConverter;
import org.apache.solr.request.json.ObjectUtil;
import org.apache.solr.request.macro.MacroExpander;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;

public class RequestUtil {
    public static void processParams(SolrRequestHandler handler, SolrQueryRequest req, SolrParams defaults, SolrParams appends, SolrParams invariants) {
        String key;
        boolean hasAdditions;
        boolean searchHandler = handler instanceof SearchHandler;
        SolrParams params = req.getParams();
        if (searchHandler && req.getContentStreams() != null) {
            Map<String, String[]> map = MultiMapSolrParams.asMultiMap(params, false);
            if (!(params instanceof MultiMapSolrParams) && !(params instanceof ModifiableSolrParams)) {
                params = new MultiMapSolrParams(map);
                req.setParams(params);
            }
            String[] jsonFromParams = map.remove("json");
            for (ContentStream cs : req.getContentStreams()) {
                String contentType = cs.getContentType();
                if (contentType == null || !contentType.contains("/json")) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bad contentType for search handler :" + contentType + " request=" + req);
                }
                try {
                    String jsonString = IOUtils.toString((Reader)cs.getReader());
                    if (jsonString == null) continue;
                    MultiMapSolrParams.addParam("json", jsonString, map);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception reading content stream for request:" + req, (Throwable)e);
                }
            }
            if (jsonFromParams != null) {
                for (String json : jsonFromParams) {
                    MultiMapSolrParams.addParam("json", json, map);
                }
            }
        }
        String[] jsonS = params.getParams("json");
        boolean bl = hasAdditions = defaults != null || invariants != null || appends != null || jsonS != null;
        if (!hasAdditions && !params.getBool("expandMacros", true)) {
            return;
        }
        boolean isShard = params.getBool("isShard", false);
        Map<String, String[]> newMap = MultiMapSolrParams.asMultiMap(params, hasAdditions);
        if (jsonS != null && !isShard) {
            for (String json : jsonS) {
                RequestUtil.getParamsFromJSON(newMap, json);
            }
        }
        if (defaults != null) {
            Map<String, String[]> defaultsMap = MultiMapSolrParams.asMultiMap(defaults);
            for (Map.Entry<String, String[]> entry : defaultsMap.entrySet()) {
                key = entry.getKey();
                if (newMap.containsKey(key)) continue;
                newMap.put(key, entry.getValue());
            }
        }
        if (appends != null) {
            Map<String, String[]> appendsMap = MultiMapSolrParams.asMultiMap(appends);
            for (Map.Entry<String, String[]> entry : appendsMap.entrySet()) {
                key = entry.getKey();
                String[] stringArray = newMap.get(key);
                if (stringArray == null) {
                    newMap.put(key, entry.getValue());
                    continue;
                }
                String[] appendArr = entry.getValue();
                String[] newArr = new String[stringArray.length + appendArr.length];
                System.arraycopy(stringArray, 0, newArr, 0, stringArray.length);
                System.arraycopy(appendArr, 0, newArr, stringArray.length, appendArr.length);
                newMap.put(key, newArr);
            }
        }
        if (invariants != null) {
            newMap.putAll(MultiMapSolrParams.asMultiMap(invariants));
        }
        if (!isShard) {
            String[] doMacrosStr = newMap.get("expandMacros");
            boolean doMacros = true;
            if (doMacrosStr != null) {
                doMacros = "true".equals(doMacrosStr[0]);
            }
            if (doMacros) {
                newMap = MacroExpander.expand(newMap);
            }
        }
        MultiMapSolrParams newParams = new MultiMapSolrParams(newMap);
        req.setParams(newParams);
        if (!searchHandler) {
            return;
        }
        LinkedHashMap<String, Object> json = null;
        jsonS = newMap.get("json");
        if (jsonS != null) {
            if (json == null) {
                json = new LinkedHashMap<String, Object>();
            }
            RequestUtil.mergeJSON(json, "json", jsonS, new ObjectUtil.ConflictHandler());
        }
        for (Map.Entry<String, String[]> entry : newMap.entrySet()) {
            String string = entry.getKey();
            if (!string.startsWith("json.") || "json.nl".equals(string) || "json.wrf".equals(string)) continue;
            if (json == null) {
                json = new LinkedHashMap();
            }
            RequestUtil.mergeJSON(json, string, entry.getValue(), new ObjectUtil.ConflictHandler());
        }
        JsonQueryConverter jsonQueryConverter = new JsonQueryConverter();
        if (json != null && !isShard) {
            for (Map.Entry<String, Object> entry : json.entrySet()) {
                String key3 = (String)entry.getKey();
                String out = null;
                boolean isQuery = false;
                boolean arr = false;
                if ("query".equals(key3)) {
                    out = "q";
                    isQuery = true;
                } else if ("filter".equals(key3)) {
                    out = "fq";
                    arr = true;
                    isQuery = true;
                } else if ("fields".equals(key3)) {
                    out = "fl";
                    arr = true;
                } else if ("offset".equals(key3)) {
                    out = "start";
                } else if ("limit".equals(key3)) {
                    out = "rows";
                } else if ("sort".equals(key3)) {
                    out = "sort";
                } else {
                    if ("queries".equals(key3)) {
                        Object queriesJsonObj = entry.getValue();
                        if (queriesJsonObj instanceof Map && queriesJsonObj != null) {
                            Map queriesAsMap = (Map)queriesJsonObj;
                            for (Map.Entry<String, Object> entry2 : queriesAsMap.entrySet()) {
                                out = (String)entry2.getKey();
                                arr = true;
                                isQuery = true;
                                RequestUtil.convertJsonPropertyToLocalParams(newMap, jsonQueryConverter, entry2, out, isQuery, arr);
                            }
                            continue;
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected Map for 'queries', received " + queriesJsonObj);
                    }
                    if ("params".equals(key3) || "facet".equals(key3)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown top-level key in JSON request : " + key3);
                }
                RequestUtil.convertJsonPropertyToLocalParams(newMap, jsonQueryConverter, entry, out, isQuery, arr);
            }
        }
        if (json != null) {
            req.setJSON(json);
        }
    }

    private static void convertJsonPropertyToLocalParams(Map<String, String[]> outMap, JsonQueryConverter jsonQueryConverter, Map.Entry<String, Object> jsonProperty, String outKey, boolean isQuery, boolean arr) {
        Object val = jsonProperty.getValue();
        if (arr) {
            int i;
            String[] existing = outMap.get(outKey);
            List lst = val instanceof List ? (List)val : null;
            int existingSize = existing == null ? 0 : existing.length;
            int jsonSize = lst == null ? 1 : lst.size();
            String[] newval = new String[existingSize + jsonSize];
            for (i = 0; i < existingSize; ++i) {
                newval[i] = existing[i];
            }
            if (lst != null) {
                for (i = 0; i < jsonSize; ++i) {
                    Object v = lst.get(i);
                    newval[existingSize + i] = isQuery ? jsonQueryConverter.toLocalParams(v, outMap) : v.toString();
                }
            } else {
                newval[newval.length - 1] = isQuery ? jsonQueryConverter.toLocalParams(val, outMap) : val.toString();
            }
            outMap.put(outKey, newval);
        } else {
            outMap.put(outKey, new String[]{isQuery ? jsonQueryConverter.toLocalParams(val, outMap) : val.toString()});
        }
    }

    private static void mergeJSON(Map<String, Object> json, String queryParamName, String[] vals, ObjectUtil.ConflictHandler handler) {
        try {
            List<String> path = StrUtils.splitSmart(queryParamName, ".", true);
            path = path.subList(1, path.size());
            for (String jsonStr : vals) {
                Object o = ObjectBuilder.fromJSONStrict(jsonStr);
                if (o == null) continue;
                ObjectUtil.mergeObjects(json, path, o, handler);
            }
        }
        catch (JSONParser.ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void getParamsFromJSON(Map<String, String[]> params, String json) {
        if (json.indexOf("params") < 0) {
            return;
        }
        JSONParser parser = new JSONParser(json);
        try {
            JSONUtil.expect(parser, 7);
            boolean found = JSONUtil.advanceToMapKey(parser, "params", false);
            if (!found) {
                return;
            }
            parser.nextEvent();
            Object o = ObjectBuilder.getVal(parser);
            if (!(o instanceof Map)) {
                return;
            }
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (params.get(key) != null) continue;
                if (val == null) {
                    params.remove(key);
                    continue;
                }
                if (val instanceof List) {
                    List lst = (List)val;
                    String[] vals = new String[lst.size()];
                    for (int i = 0; i < vals.length; ++i) {
                        vals[i] = lst.get(i).toString();
                    }
                    params.put(key, vals);
                    continue;
                }
                params.put(key, new String[]{val.toString()});
            }
        }
        catch (Exception e) {
            return;
        }
    }
}

