/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrClassLoader;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.HasImplicitIndexAnalyzer;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.schema.TextField;
import org.apache.solr.util.plugin.AbstractPluginLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldTypePluginLoader
extends AbstractPluginLoader<FieldType> {
    private static final String LUCENE_MATCH_VERSION_PARAM = "luceneMatchVersion";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final IndexSchema schema;
    private final Map<String, FieldType> fieldTypes;
    private final Collection<SchemaAware> schemaAware;

    public FieldTypePluginLoader(IndexSchema schema, Map<String, FieldType> fieldTypes, Collection<SchemaAware> schemaAware) {
        super("[schema.xml] fieldType", FieldType.class, true, true);
        this.schema = schema;
        this.fieldTypes = fieldTypes;
        this.schemaAware = schemaAware;
    }

    @Override
    protected FieldType create(SolrClassLoader loader, String name, String className, ConfigNode node) throws Exception {
        FieldType ft = loader.newInstance(className, FieldType.class, new String[0]);
        ft.setTypeName(name);
        ConfigNode anode = node.child(it -> "query".equals(it.attributes().get("type")), "analyzer");
        Analyzer queryAnalyzer = this.readAnalyzer(anode);
        anode = node.child(it -> "multiterm".equals(it.attributes().get("type")), "analyzer");
        Analyzer multiAnalyzer = this.readAnalyzer(anode);
        anode = node.child(it -> it.attributes().get("type") == null || "index".equals(it.attributes().get("type")), "analyzer");
        Analyzer analyzer = this.readAnalyzer(anode);
        anode = node.child("similarity");
        SimilarityFactory simFactory = IndexSchema.readSimilarity(loader, anode);
        if (null != simFactory) {
            ft.setSimilarity(simFactory);
        }
        if (ft instanceof HasImplicitIndexAnalyzer) {
            ft.setIsExplicitAnalyzer(false);
            if (null != queryAnalyzer && null != analyzer) {
                log.warn("Ignoring index-time analyzer for field: {}", (Object)name);
            } else if (null == queryAnalyzer) {
                queryAnalyzer = analyzer;
            }
            if (null != queryAnalyzer) {
                ft.setIsExplicitQueryAnalyzer(true);
                ft.setQueryAnalyzer(queryAnalyzer);
            }
        } else {
            if (null == queryAnalyzer) {
                queryAnalyzer = analyzer;
                ft.setIsExplicitQueryAnalyzer(false);
            } else {
                ft.setIsExplicitQueryAnalyzer(true);
            }
            if (null == analyzer) {
                analyzer = queryAnalyzer;
                ft.setIsExplicitAnalyzer(false);
            } else {
                ft.setIsExplicitAnalyzer(true);
            }
            if (null != analyzer) {
                ft.setIndexAnalyzer(analyzer);
                ft.setQueryAnalyzer(queryAnalyzer);
                if (ft instanceof TextField) {
                    if (null == multiAnalyzer) {
                        multiAnalyzer = this.constructMultiTermAnalyzer(queryAnalyzer);
                        ((TextField)ft).setIsExplicitMultiTermAnalyzer(false);
                    } else {
                        ((TextField)ft).setIsExplicitMultiTermAnalyzer(true);
                    }
                    ((TextField)ft).setMultiTermAnalyzer(multiAnalyzer);
                }
            }
        }
        if (ft instanceof SchemaAware) {
            this.schemaAware.add((SchemaAware)((Object)ft));
        }
        return ft;
    }

    @Override
    protected void init(FieldType plugin, ConfigNode node) throws Exception {
        Map<String, String> params = DOMUtil.toMapExcept(node, "name");
        plugin.setArgs(this.schema, params);
    }

    @Override
    protected FieldType register(String name, FieldType plugin) throws Exception {
        log.trace("fieldtype defined: {}", (Object)plugin);
        return this.fieldTypes.put(name, plugin);
    }

    private Analyzer constructMultiTermAnalyzer(Analyzer queryAnalyzer) {
        if (queryAnalyzer == null) {
            return null;
        }
        if (!(queryAnalyzer instanceof TokenizerChain)) {
            return new KeywordAnalyzer();
        }
        return ((TokenizerChain)queryAnalyzer).getMultiTermAnalyzer();
    }

    private Analyzer readAnalyzer(ConfigNode node) {
        SolrClassLoader loader = this.schema.getSolrClassLoader();
        if (node == null) {
            return null;
        }
        String analyzerName = DOMUtil.getAttr(node, "class", null);
        List<ConfigNode> charFilterNodes = node.getAll("charFilter");
        List<ConfigNode> tokenizerNodes = node.getAll("tokenizer");
        List<ConfigNode> tokenFilterNodes = node.getAll("filter");
        if (analyzerName != null) {
            if (0 != charFilterNodes.size() || 0 != tokenizerNodes.size() || 0 != tokenFilterNodes.size()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Configuration Error: Analyzer class='" + analyzerName + "' can not be combined with nested analysis factories");
            }
            try {
                Version luceneMatchVersion;
                Class<Analyzer> clazz = loader.findClass(analyzerName, Analyzer.class);
                Analyzer analyzer = clazz.newInstance();
                String matchVersionStr = DOMUtil.getAttr(node, LUCENE_MATCH_VERSION_PARAM, null);
                Version version = luceneMatchVersion = matchVersionStr == null ? this.schema.getDefaultLuceneMatchVersion() : SolrConfig.parseLuceneVersionString(matchVersionStr);
                if (luceneMatchVersion == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Configuration Error: Analyzer '" + clazz.getName() + "' needs a '" + LUCENE_MATCH_VERSION_PARAM + "' parameter");
                }
                analyzer.setVersion(luceneMatchVersion);
                return analyzer;
            }
            catch (Exception e) {
                log.error("Cannot load analyzer: {}", (Object)analyzerName, (Object)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot load analyzer: " + analyzerName, (Throwable)e);
            }
        }
        final ArrayList charFilters = new ArrayList();
        AbstractPluginLoader<CharFilterFactory> charFilterLoader = new AbstractPluginLoader<CharFilterFactory>("[schema.xml] analyzer/charFilter", CharFilterFactory.class, false, false){

            @Override
            protected CharFilterFactory create(SolrClassLoader loader, String name, String className, ConfigNode node) throws Exception {
                Map<String, String> params = DOMUtil.toMapExcept(node, new String[0]);
                String configuredVersion = params.remove(FieldTypePluginLoader.LUCENE_MATCH_VERSION_PARAM);
                params.put(FieldTypePluginLoader.LUCENE_MATCH_VERSION_PARAM, FieldTypePluginLoader.this.parseConfiguredVersion(configuredVersion, CharFilterFactory.class.getSimpleName()).toString());
                CharFilterFactory factory = loader.newInstance(className, CharFilterFactory.class, this.getDefaultPackages(), new Class[]{Map.class}, new Object[]{params});
                factory.setExplicitLuceneMatchVersion(null != configuredVersion);
                return factory;
            }

            @Override
            protected void init(CharFilterFactory plugin, ConfigNode node) throws Exception {
                if (plugin != null) {
                    charFilters.add(plugin);
                }
            }

            @Override
            protected CharFilterFactory register(String name, CharFilterFactory plugin) {
                return null;
            }
        };
        charFilterLoader.load(loader, charFilterNodes);
        final ArrayList tokenizers = new ArrayList(1);
        AbstractPluginLoader<TokenizerFactory> tokenizerLoader = new AbstractPluginLoader<TokenizerFactory>("[schema.xml] analyzer/tokenizer", TokenizerFactory.class, false, false){

            @Override
            protected TokenizerFactory create(SolrClassLoader loader, String name, String className, ConfigNode node) throws Exception {
                Map<String, String> params = DOMUtil.toMap(node);
                String configuredVersion = params.remove(FieldTypePluginLoader.LUCENE_MATCH_VERSION_PARAM);
                params.put(FieldTypePluginLoader.LUCENE_MATCH_VERSION_PARAM, FieldTypePluginLoader.this.parseConfiguredVersion(configuredVersion, TokenizerFactory.class.getSimpleName()).toString());
                TokenizerFactory factory = loader.newInstance(className, TokenizerFactory.class, this.getDefaultPackages(), new Class[]{Map.class}, new Object[]{params});
                factory.setExplicitLuceneMatchVersion(null != configuredVersion);
                return factory;
            }

            @Override
            protected void init(TokenizerFactory plugin, ConfigNode node) throws Exception {
                if (!tokenizers.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The schema defines multiple tokenizers for: " + node);
                }
                tokenizers.add(plugin);
            }

            @Override
            protected TokenizerFactory register(String name, TokenizerFactory plugin) {
                return null;
            }
        };
        tokenizerLoader.load(loader, tokenizerNodes);
        if (tokenizers.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "analyzer without class or tokenizer");
        }
        final ArrayList filters = new ArrayList();
        AbstractPluginLoader<TokenFilterFactory> filterLoader = new AbstractPluginLoader<TokenFilterFactory>("[schema.xml] analyzer/filter", TokenFilterFactory.class, false, false){

            @Override
            protected TokenFilterFactory create(SolrClassLoader loader, String name, String className, ConfigNode node) throws Exception {
                Map<String, String> params = DOMUtil.toMap(node);
                String configuredVersion = params.remove(FieldTypePluginLoader.LUCENE_MATCH_VERSION_PARAM);
                params.put(FieldTypePluginLoader.LUCENE_MATCH_VERSION_PARAM, FieldTypePluginLoader.this.parseConfiguredVersion(configuredVersion, TokenFilterFactory.class.getSimpleName()).toString());
                TokenFilterFactory factory = loader.newInstance(className, TokenFilterFactory.class, this.getDefaultPackages(), new Class[]{Map.class}, new Object[]{params});
                factory.setExplicitLuceneMatchVersion(null != configuredVersion);
                return factory;
            }

            @Override
            protected void init(TokenFilterFactory plugin, ConfigNode node) throws Exception {
                if (plugin != null) {
                    filters.add(plugin);
                }
            }

            @Override
            protected TokenFilterFactory register(String name, TokenFilterFactory plugin) throws Exception {
                return null;
            }
        };
        filterLoader.load(loader, tokenFilterNodes);
        return new TokenizerChain(charFilters.toArray(new CharFilterFactory[charFilters.size()]), (TokenizerFactory)tokenizers.get(0), filters.toArray(new TokenFilterFactory[filters.size()]));
    }

    private Version parseConfiguredVersion(String configuredVersion, String pluginClassName) {
        Version version;
        Version version2 = version = configuredVersion != null ? SolrConfig.parseLuceneVersionString(configuredVersion) : this.schema.getDefaultLuceneMatchVersion();
        if (!version.onOrAfter(Version.LUCENE_7_0_0) && log.isWarnEnabled()) {
            log.warn("{} is using deprecated {} emulation. You should at some point declare and reindex to at least 7.0, because 6.x emulation is deprecated and will be removed in 8.0", (Object)pluginClassName, (Object)version);
        }
        return version;
    }
}

