/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SortSpec;

public final class CursorMark {
    private final SortSpec sortSpec;
    private List<Object> values = null;

    public CursorMark(IndexSchema schema, SortSpec sortSpec) {
        SchemaField uniqueKey = schema.getUniqueKeyField();
        if (null == uniqueKey) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cursor functionality is not available unless the IndexSchema defines a uniqueKey field");
        }
        Sort sort = sortSpec.getSort();
        if (null == sort) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cursor functionality requires a sort containing a uniqueKey field tie breaker");
        }
        if (!sortSpec.getSchemaFields().contains(uniqueKey)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cursor functionality requires a sort containing a uniqueKey field tie breaker");
        }
        if (0 != sortSpec.getOffset()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cursor functionality requires start=0");
        }
        for (SortField sf : sort.getSort()) {
            if (!sf.getType().equals((Object)SortField.Type.DOC)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cursor functionality can not be used with internal doc ordering sort: _docid_");
        }
        if (sort.getSort().length != sortSpec.getSchemaFields().size()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cursor SortSpec failure: sort length != SchemaFields: " + sort.getSort().length + " != " + sortSpec.getSchemaFields().size());
        }
        this.sortSpec = sortSpec;
        this.values = null;
    }

    private CursorMark(CursorMark previous) {
        this.sortSpec = previous.sortSpec;
        this.values = null;
    }

    public CursorMark createNext(List<Object> nextSortValues) {
        CursorMark next = new CursorMark(this);
        next.setSortValues(nextSortValues);
        return next;
    }

    public void setSortValues(List<Object> input) {
        if (null == input) {
            this.values = null;
        } else {
            if (input.size() != this.sortSpec.getSort().getSort().length) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cursor SortSpec failure: sort values != sort length: " + input.size() + " != " + this.sortSpec.getSort().getSort().length);
            }
            this.values = new ArrayList<Object>(input);
        }
    }

    public List<Object> getSortValues() {
        return null == this.values ? null : new ArrayList<Object>(this.values);
    }

    public SortSpec getSortSpec() {
        return this.sortSpec;
    }

    public void parseSerializedTotem(String serialized) {
        if ("*".equals(serialized)) {
            this.values = null;
            return;
        }
        SortField[] sortFields = this.sortSpec.getSort().getSort();
        List<SchemaField> schemaFields = this.sortSpec.getSchemaFields();
        List pieces = null;
        try {
            byte[] rawData = Base64.base64ToByteArray(serialized);
            try (JavaBinCodec jbc = new JavaBinCodec();
                 ByteArrayInputStream in = new ByteArrayInputStream(rawData);){
                pieces = (List)jbc.unmarshal(in);
                boolean b = false;
                for (Object o : pieces) {
                    if (!(o instanceof BytesRefBuilder) && !(o instanceof BytesRef) && !(o instanceof String)) continue;
                    b = true;
                    break;
                }
                if (b) {
                    in.reset();
                    pieces = (List)new JavaBinCodec().unmarshal(in);
                }
            }
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to parse 'cursorMark' after totem: value must either be '*' or the 'nextCursorMark' returned by a previous search: " + serialized, (Throwable)ex);
        }
        assert (null != pieces) : "pieces wasn't parsed, nor exception thrown?";
        if (sortFields.length != pieces.size()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "cursorMark does not work with current sort (wrong size): " + serialized);
        }
        this.values = new ArrayList<Object>(sortFields.length);
        BytesRef tmpBytes = new BytesRef();
        for (int i = 0; i < sortFields.length; ++i) {
            SortField curSort = sortFields[i];
            SchemaField curField = schemaFields.get(i);
            Object rawValue = pieces.get(i);
            if (null != curField) {
                FieldType curType = curField.getType();
                rawValue = curType.unmarshalSortValue(rawValue);
            }
            this.values.add(rawValue);
        }
    }

    /*
     * Exception decompiling
     */
    public String getSerializedTotem() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FieldDoc getSearchAfterFieldDoc() {
        if (null == this.values) {
            return null;
        }
        return new FieldDoc(Integer.MAX_VALUE, 0.0f, this.values.toArray());
    }
}

