/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.search.SyntaxError;

public class LuceneQParser
extends QParser {
    SolrQueryParser lparser;

    public LuceneQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        String qstr = this.getString();
        if (qstr == null || qstr.length() == 0) {
            return null;
        }
        String defaultField = this.getParam("df");
        this.lparser = new SolrQueryParser(this, defaultField);
        this.lparser.setDefaultOperator(QueryParsing.parseOP(this.getParam("q.op")));
        this.lparser.setSplitOnWhitespace(StrUtils.parseBool(this.getParam("sow"), false));
        this.lparser.setAllowSubQueryParsing(true);
        return this.lparser.parse(qstr);
    }

    @Override
    public String[] getDefaultHighlightFields() {
        String[] stringArray;
        if (this.lparser == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.lparser.getDefaultField();
        }
        return stringArray;
    }
}

