/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.uninverting.UninvertingReader;

public class SolrFieldCacheBean
implements SolrInfoBean,
SolrMetricProducer {
    private boolean disableEntryList = Boolean.getBoolean("disableSolrFieldCacheMBeanEntryList");
    private boolean disableJmxEntryList = Boolean.getBoolean("disableSolrFieldCacheMBeanEntryListJmx");
    private SolrMetricsContext solrMetricsContext;
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        return "Provides introspection of the Solr FieldCache ";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.CACHE;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext;
        MetricsMap metricsMap = new MetricsMap(map -> {
            if (!this.disableEntryList && !this.disableJmxEntryList) {
                UninvertingReader.FieldCacheStats fieldCacheStats = UninvertingReader.getUninvertedStats();
                String[] entries = fieldCacheStats.info;
                map.put((CharSequence)"entries_count", entries.length);
                map.put((CharSequence)"total_size", fieldCacheStats.totalSize);
                for (int i = 0; i < entries.length; ++i) {
                    String entry = entries[i];
                    map.put((CharSequence)("entry#" + i), entry);
                }
            } else {
                map.put((CharSequence)"entries_count", UninvertingReader.getUninvertedStatsSize());
            }
        });
        this.solrMetricsContext.gauge(this, metricsMap, true, "fieldCache", SolrInfoBean.Category.CACHE.toString(), scope);
    }
}

