/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.facet.FacetBucket;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetRequestSortedMerger;
import org.apache.solr.search.facet.HLLAgg;

public class FacetFieldMerger
extends FacetRequestSortedMerger<FacetField> {
    FacetBucket missingBucket;
    FacetBucket allBuckets;
    FacetMerger numBuckets;
    int[] numReturnedPerShard;
    int numReturnedBuckets;

    public FacetFieldMerger(FacetField freq) {
        super(freq);
    }

    @Override
    public void merge(Object facetResult, FacetMerger.Context mcontext) {
        super.merge(facetResult, mcontext);
        if (this.numReturnedPerShard == null) {
            this.numReturnedPerShard = new int[mcontext.numShards];
        }
        this.merge((SimpleOrderedMap)facetResult, mcontext);
    }

    protected void merge(SimpleOrderedMap facetResult, FacetMerger.Context mcontext) {
        Object nb;
        Object o;
        if (((FacetField)this.freq).missing && (o = facetResult.get("missing")) != null) {
            if (this.missingBucket == null) {
                this.missingBucket = this.newBucket(null, mcontext);
            }
            this.missingBucket.mergeBucket((SimpleOrderedMap)o, mcontext);
        }
        if (((FacetField)this.freq).allBuckets && (o = facetResult.get("allBuckets")) != null) {
            if (this.allBuckets == null) {
                this.allBuckets = this.newBucket(null, mcontext);
            }
            this.allBuckets.mergeBucket((SimpleOrderedMap)o, mcontext);
        }
        List bucketList = (List)facetResult.get("buckets");
        this.numReturnedPerShard[mcontext.shardNum] = bucketList.size();
        this.numReturnedBuckets += bucketList.size();
        this.mergeBucketList(bucketList, mcontext);
        if (((FacetField)this.freq).numBuckets && (nb = facetResult.get("numBuckets")) != null) {
            if (this.numBuckets == null) {
                this.numBuckets = new HLLAgg("hll_merger").createFacetMerger(nb);
            }
            this.numBuckets.merge(nb, mcontext);
        }
    }

    @Override
    public Object getMergedResult() {
        SimpleOrderedMap<Serializable> result = new SimpleOrderedMap<Serializable>();
        if (this.numBuckets != null) {
            result.add("numBuckets", Long.valueOf(((Number)this.numBuckets.getMergedResult()).longValue()));
        }
        this.sortBuckets(((FacetField)this.freq).sort);
        long first = ((FacetField)this.freq).offset;
        long end = ((FacetField)this.freq).limit >= 0L ? first + (long)((int)((FacetField)this.freq).limit) : Integer.MAX_VALUE;
        long last = Math.min((long)this.sortedBuckets.size(), end);
        ArrayList<SimpleOrderedMap> resultBuckets = new ArrayList<SimpleOrderedMap>(Math.max(0, (int)(last - first)));
        boolean refine = ((FacetField)this.freq).refine != null && ((FacetField)this.freq).refine != FacetRequest.RefineMethod.NONE;
        int off = (int)((FacetField)this.freq).offset;
        int lim = ((FacetField)this.freq).limit >= 0L ? (int)((FacetField)this.freq).limit : Integer.MAX_VALUE;
        for (FacetBucket bucket : this.sortedBuckets) {
            if (bucket.getCount() < ((FacetField)this.freq).mincount || refine && !this.isBucketComplete(bucket, this.mcontext)) continue;
            if (off > 0) {
                --off;
                continue;
            }
            if (resultBuckets.size() >= lim) break;
            resultBuckets.add(bucket.getMergedBucket());
        }
        result.add("buckets", resultBuckets);
        if (this.missingBucket != null) {
            result.add("missing", this.missingBucket.getMergedBucket());
        }
        if (this.allBuckets != null) {
            result.add("allBuckets", this.allBuckets.getMergedBucket());
        }
        return result;
    }

    @Override
    public void finish(FacetMerger.Context mcontext) {
    }

    @Override
    Map<String, Object> getRefinementSpecial(FacetMerger.Context mcontext, Map<String, Object> refinement, Collection<String> tagsWithPartial) {
        if (!tagsWithPartial.isEmpty() && ((FacetField)this.freq).missing) {
            refinement = this.getRefinementSpecial(mcontext, refinement, tagsWithPartial, this.missingBucket, "missing");
        }
        return refinement;
    }

    private Map<String, Object> getRefinementSpecial(FacetMerger.Context mcontext, Map<String, Object> refinement, Collection<String> tagsWithPartial, FacetBucket bucket, String label) {
        Map<String, Object> bucketRefinement = bucket.getRefinement(mcontext, tagsWithPartial);
        if (bucketRefinement != null) {
            refinement = refinement == null ? new HashMap<String, Map<String, Object>>(2) : refinement;
            refinement.put(label, bucketRefinement);
        }
        return refinement;
    }

    private static class FacetNumBucketsMerger
    extends FacetMerger {
        long sumBuckets;
        long shardsMissingSum;
        long shardsTruncatedSum;
        Set<Object> values;

        private FacetNumBucketsMerger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            SimpleOrderedMap map = (SimpleOrderedMap)facetResult;
            long numBuckets = ((Number)map.get("numBuckets")).longValue();
            this.sumBuckets += numBuckets;
            List vals = (List)map.get("vals");
            if (vals != null) {
                if (this.values == null) {
                    this.values = new HashSet<Object>(vals.size() * 4);
                }
                this.values.addAll(vals);
                if (numBuckets > (long)this.values.size()) {
                    this.shardsTruncatedSum += numBuckets - (long)this.values.size();
                }
            } else {
                this.shardsMissingSum += numBuckets;
            }
        }

        @Override
        public void finish(FacetMerger.Context mcontext) {
        }

        @Override
        public Object getMergedResult() {
            long exactCount = this.values == null ? 0L : (long)this.values.size();
            return exactCount + this.shardsMissingSum + this.shardsTruncatedSum;
        }
    }
}

