/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import com.google.common.annotations.VisibleForTesting;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStreamImpl;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.prefix.HeatmapFacetCounter;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.AbstractSpatialPrefixTreeFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.RptWithGeometrySpatialField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialRecursivePrefixTreeFieldType;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetParser;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.util.DistanceUnits;
import org.apache.solr.util.SpatialUtils;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetHeatmap
extends FacetRequest {
    public static final String GEOM_PARAM = "geom";
    public static final String LEVEL_PARAM = "gridLevel";
    public static final String DIST_ERR_PCT_PARAM = "distErrPct";
    public static final String DIST_ERR_PARAM = "distErr";
    public static final String MAX_CELLS_PARAM = "maxCells";
    public static final String FORMAT_PARAM = "format";
    public static final String FORMAT_PNG = "png";
    public static final String FORMAT_INTS2D = "ints2D";
    public static final double DEFAULT_DIST_ERR_PCT = 0.15;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Object> argsMap;
    private final PrefixTreeStrategy strategy;
    private final Shape boundsShape;
    private final int gridLevel;
    private final int maxCells;
    private final String format;

    FacetHeatmap(Map<String, Object> argsMap, PrefixTreeStrategy strategy, Shape boundsShape, int gridLevel, int maxCells, String format) {
        this.argsMap = argsMap;
        this.strategy = strategy;
        this.boundsShape = boundsShape;
        this.gridLevel = gridLevel;
        this.maxCells = maxCells;
        this.format = format;
    }

    @Override
    public Map<String, Object> getFacetDescription() {
        return this.argsMap;
    }

    @Override
    public FacetProcessor createFacetProcessor(FacetContext fcontext) {
        return new FacetHeatmapProcessor(fcontext);
    }

    private static Object formatCountsVal(String format, int columns, int rows, int[] counts, FacetDebugInfo debugInfo) {
        if (counts == null) {
            return null;
        }
        boolean hasNonZero = false;
        for (int count : counts) {
            if (count <= 0) continue;
            hasNonZero = true;
            break;
        }
        if (!hasNonZero) {
            return null;
        }
        switch (format) {
            case "ints2D": {
                return FacetHeatmap.asInts2D(columns, rows, counts);
            }
            case "png": {
                return FacetHeatmap.asPngBytes(columns, rows, counts, debugInfo);
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown format: " + format);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new FacetMerger(){
            NamedList<Object> mergedResult;
            int[] counts;

            @Override
            public void merge(Object facetResult, FacetMerger.Context mcontext) {
                NamedList facetResultNL = (NamedList)facetResult;
                this.counts = FacetHeatmap.addPngToIntArray((byte[])facetResultNL.remove("counts_png"), this.counts);
                if (this.mergedResult == null) {
                    this.mergedResult = facetResultNL;
                }
            }

            @Override
            public void finish(FacetMerger.Context mcontext) {
            }

            @Override
            public Object getMergedResult() {
                this.mergedResult.add("counts_" + FacetHeatmap.this.format, FacetHeatmap.formatCountsVal(FacetHeatmap.this.format, (Integer)this.mergedResult.get("columns"), (Integer)this.mergedResult.get("rows"), this.counts, null));
                return this.mergedResult;
            }
        };
    }

    @VisibleForTesting
    static int[] addPngToIntArray(byte[] pngBytes, int[] counts) {
        if (pngBytes == null) {
            return counts;
        }
        BufferedImage image = PngHelper.readImage(pngBytes);
        int columns = image.getWidth();
        int rows = image.getHeight();
        if (counts == null) {
            counts = new int[columns * rows];
        } else assert (counts.length == columns * rows);
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                int n = c * rows + r;
                counts[n] = counts[n] + PngHelper.getCountAtColumnRow(image, rows, c, r);
            }
        }
        return counts;
    }

    @VisibleForTesting
    static List<List<Integer>> asInts2D(final int columns, final int rows, final int[] counts) {
        return new AbstractList<List<Integer>>(){

            @Override
            public List<Integer> get(int rowIdx) {
                boolean hasNonZero = false;
                final int y = rows - rowIdx - 1;
                for (int c = 0; c < columns; ++c) {
                    if (counts[c * rows + y] <= 0) continue;
                    hasNonZero = true;
                    break;
                }
                if (!hasNonZero) {
                    return null;
                }
                return new AbstractList<Integer>(){

                    @Override
                    public Integer get(int columnIdx) {
                        return counts[columnIdx * rows + y];
                    }

                    @Override
                    public int size() {
                        return columns;
                    }
                };
            }

            @Override
            public int size() {
                return rows;
            }
        };
    }

    @VisibleForTesting
    static byte[] asPngBytes(int columns, int rows, int[] counts, FacetDebugInfo debugInfo) {
        long startTimeNano = System.nanoTime();
        BufferedImage image = PngHelper.newImage(columns, rows);
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                PngHelper.writeCountAtColumnRow(image, rows, c, r, counts[c * rows + r]);
            }
        }
        byte[] bytes = PngHelper.writeImage(image);
        long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNano);
        if (log.isDebugEnabled()) {
            log.debug("heatmap nativeSize={} pngSize={} pngTime={}", new Object[]{counts.length * 4, bytes.length, durationMs});
        }
        if (debugInfo != null) {
            debugInfo.putInfoItem("heatmap png timing", durationMs);
        }
        return bytes;
    }

    @VisibleForTesting
    static class PngHelper {
        static final ImageReaderSpi imageReaderSpi;

        PngHelper() {
        }

        static BufferedImage readImage(final byte[] bytes) {
            ImageInputStreamImpl imageInputStream = new ImageInputStreamImpl(){

                @Override
                public int read() throws IOException {
                    this.checkClosed();
                    this.bitOffset = 0;
                    if (this.streamPos >= (long)bytes.length) {
                        return -1;
                    }
                    return bytes[(int)this.streamPos++];
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    this.checkClosed();
                    this.bitOffset = 0;
                    if (this.streamPos >= (long)bytes.length) {
                        return -1;
                    }
                    int copyLen = Math.min(len, bytes.length - (int)this.streamPos);
                    System.arraycopy(bytes, (int)this.streamPos, b, off, copyLen);
                    this.streamPos += (long)copyLen;
                    return copyLen;
                }

                @Override
                public long length() {
                    return bytes.length;
                }

                @Override
                public boolean isCached() {
                    return true;
                }

                @Override
                public boolean isCachedMemory() {
                    return true;
                }
            };
            try {
                ImageReader imageReader = imageReaderSpi.createReaderInstance();
                imageReader.setInput(imageInputStream, false, true);
                return imageReader.read(0);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Problem reading png heatmap: " + e);
            }
        }

        static byte[] writeImage(BufferedImage image) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(image.getWidth() * image.getHeight() + 1024);
            try {
                ImageIO.write((RenderedImage)image, FacetHeatmap.FORMAT_PNG, baos);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "While generating PNG: " + e);
            }
            return baos.toByteArray();
        }

        static BufferedImage newImage(int columns, int rows) {
            return new BufferedImage(columns, rows, 6);
        }

        static void writeCountAtColumnRow(BufferedImage image, int rows, int c, int r, int val) {
            image.setRGB(c, rows - 1 - r, val ^ 0xFF000000);
        }

        static int getCountAtColumnRow(BufferedImage image, int rows, int c, int r) {
            return image.getRGB(c, rows - 1 - r) ^ 0xFF000000;
        }

        static {
            Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByFormatName(FacetHeatmap.FORMAT_PNG);
            if (!imageReaders.hasNext()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find png image reader, neaded for heatmaps!");
            }
            ImageReader imageReader = imageReaders.next();
            imageReaderSpi = imageReader.getOriginatingProvider();
        }
    }

    private class FacetHeatmapProcessor
    extends FacetProcessor {
        public FacetHeatmapProcessor(FacetContext fcontext) {
            super(fcontext, FacetHeatmap.this);
        }

        @Override
        public void process() throws IOException {
            HeatmapFacetCounter.Heatmap heatmap;
            super.process();
            try {
                heatmap = HeatmapFacetCounter.calcFacets((PrefixTreeStrategy)FacetHeatmap.this.strategy, (IndexReaderContext)this.fcontext.searcher.getTopReaderContext(), (Bits)this.getTopAcceptDocs(this.fcontext.base, this.fcontext.searcher), (Shape)FacetHeatmap.this.boundsShape, (int)FacetHeatmap.this.gridLevel, (int)FacetHeatmap.this.maxCells);
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.toString(), (Throwable)e);
            }
            this.response = new SimpleOrderedMap();
            this.response.add(FacetHeatmap.LEVEL_PARAM, FacetHeatmap.this.gridLevel);
            this.response.add("columns", heatmap.columns);
            this.response.add("rows", heatmap.rows);
            this.response.add("minX", heatmap.region.getMinX());
            this.response.add("maxX", heatmap.region.getMaxX());
            this.response.add("minY", heatmap.region.getMinY());
            this.response.add("maxY", heatmap.region.getMaxY());
            String format = this.fcontext.isShard() ? FacetHeatmap.FORMAT_PNG : FacetHeatmap.this.format;
            this.response.add("counts_" + format, FacetHeatmap.formatCountsVal(format, heatmap.columns, heatmap.rows, heatmap.counts, this.fcontext.getDebugInfo()));
        }

        private Bits getTopAcceptDocs(DocSet docSet, SolrIndexSearcher searcher) throws IOException {
            if (docSet.size() == searcher.numDocs()) {
                return null;
            }
            if (docSet.size() == 0) {
                return new Bits.MatchNoBits(searcher.maxDoc());
            }
            if (docSet instanceof BitDocSet) {
                return ((BitDocSet)docSet).getBits();
            }
            FixedBitSet bits = new FixedBitSet(searcher.maxDoc());
            DocIterator iter = docSet.iterator();
            while (iter.hasNext()) {
                bits.set(iter.nextDoc());
            }
            return bits;
        }
    }

    static class Parser
    extends FacetParser<FacetHeatmap> {
        Parser(FacetParser parent, String key) {
            super(parent, key);
        }

        @Override
        public FacetHeatmap parse(Object argsObj) {
            int gridLevel;
            DistanceUnits distanceUnits;
            PrefixTreeStrategy strategy;
            assert (this.facet == null);
            if (!(argsObj instanceof Map)) {
                throw this.err("Missing heatmap arguments");
            }
            Map argsMap = (Map)argsObj;
            String fieldName = this.getField(argsMap);
            SchemaField schemaField = this.getSchema().getField(fieldName);
            FieldType type = schemaField.getType();
            if (type instanceof AbstractSpatialPrefixTreeFieldType) {
                AbstractSpatialPrefixTreeFieldType rptType = (AbstractSpatialPrefixTreeFieldType)type;
                strategy = (PrefixTreeStrategy)rptType.getStrategy(fieldName);
                distanceUnits = rptType.getDistanceUnits();
            } else if (type instanceof RptWithGeometrySpatialField) {
                RptWithGeometrySpatialField rptSdvType = (RptWithGeometrySpatialField)type;
                strategy = ((CompositeSpatialStrategy)rptSdvType.getStrategy(fieldName)).getIndexStrategy();
                distanceUnits = rptSdvType.getDistanceUnits();
            } else {
                throw this.err("heatmap field needs to be of type " + SpatialRecursivePrefixTreeFieldType.class + " or " + RptWithGeometrySpatialField.class);
            }
            SpatialContext ctx = strategy.getSpatialContext();
            String geomStr = this.getString(argsMap, FacetHeatmap.GEOM_PARAM, null);
            Rectangle boundsShape = geomStr == null ? ctx.getWorldBounds() : SpatialUtils.parseGeomSolrException(geomStr, ctx);
            Long gridLevelObj = this.getLongOrNull(argsMap, FacetHeatmap.LEVEL_PARAM, false);
            int maxGridLevel = strategy.getGrid().getMaxLevels();
            if (gridLevelObj != null) {
                gridLevel = gridLevelObj.intValue();
                if (gridLevel <= 0 || gridLevel > maxGridLevel) {
                    throw this.err("gridLevel should be > 0 and <= " + maxGridLevel);
                }
            } else {
                SpatialArgs spatialArgs = new SpatialArgs(SpatialOperation.Intersects, (Shape)(boundsShape == null ? ctx.getWorldBounds() : boundsShape));
                Double distErrObj = this.getDoubleOrNull(argsMap, FacetHeatmap.DIST_ERR_PARAM, false);
                if (distErrObj != null) {
                    spatialArgs.setDistErr(Double.valueOf(distErrObj * distanceUnits.multiplierFromThisUnitToDegrees()));
                }
                spatialArgs.setDistErrPct(this.getDoubleOrNull(argsMap, FacetHeatmap.DIST_ERR_PCT_PARAM, false));
                double distErr = spatialArgs.resolveDistErr(ctx, 0.15);
                if (distErr <= 0.0) {
                    throw this.err("distErrPct or distErr should be > 0 or instead provide gridLevel=" + maxGridLevel + " if you insist on maximum detail");
                }
                gridLevel = strategy.getGrid().getLevelForDistance(distErr);
            }
            int maxCells = (int)this.getLong(argsMap, FacetHeatmap.MAX_CELLS_PARAM, 100000L);
            String format = this.getString(argsMap, FacetHeatmap.FORMAT_PARAM, FacetHeatmap.FORMAT_INTS2D);
            if (!format.equals(FacetHeatmap.FORMAT_INTS2D) && !format.equals(FacetHeatmap.FORMAT_PNG)) {
                throw this.err("format should be ints2D or png");
            }
            this.facet = new FacetHeatmap(argsMap, strategy, (Shape)boundsShape, gridLevel, maxCells, format);
            this.parseCommonParams(argsObj);
            return (FacetHeatmap)this.facet;
        }
    }
}

