/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandles;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.util.Collection;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.FastOutputStream;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MemOutputStream;
import org.apache.solr.update.TransactionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CdcrTransactionLog
extends TransactionLog {
    private boolean isReplaying;
    long startVersion;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean debug = log.isDebugEnabled();

    CdcrTransactionLog(File tlogFile, Collection<String> globalStrings) {
        super(tlogFile, globalStrings);
        String filename = tlogFile.getName();
        this.startVersion = Math.abs(Long.parseLong(filename.substring(filename.lastIndexOf(46) + 1)));
        this.isReplaying = false;
    }

    CdcrTransactionLog(File tlogFile, Collection<String> globalStrings, boolean openExisting) {
        super(tlogFile, globalStrings, openExisting);
        String filename = tlogFile.getName();
        this.startVersion = Math.abs(Long.parseLong(filename.substring(filename.lastIndexOf(46) + 1)));
        int n = this.numRecords = openExisting ? this.readNumRecords() : 0;
        if (openExisting && this.numRecords == 0) {
            this.isReplaying = true;
        }
    }

    @Override
    public int numRecords() {
        return super.numRecords();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readNumRecords() {
        try {
            if (!this.endsWithCommit()) return 0;
            long size = this.fos.size();
            long pos = size - 4L - (long)"SOLR_TLOG_END".length() - 1L - 4L;
            if (pos < 0L) {
                return 0;
            }
            try (TransactionLog.ChannelFastInputStream is = new TransactionLog.ChannelFastInputStream(this.channel, pos);){
                int n = is.readInt();
                return n;
            }
        }
        catch (IOException e) {
            log.error("Error while reading number of records in tlog {}", (Object)this, (Object)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(AddUpdateCommand cmd, long prevPointer) {
        assert (-1L <= prevPointer && (cmd.isInPlaceUpdate() || -1L == prevPointer));
        TransactionLog.LogCodec codec = new TransactionLog.LogCodec(this, resolver);
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        try {
            this.checkWriteHeader(codec, sdoc);
            int bufSize = this.lastAddSize;
            bufSize = Math.min(0x100000, bufSize + (bufSize >> 3) + 256);
            MemOutputStream out = new MemOutputStream(new byte[bufSize]);
            codec.init(out);
            if (cmd.isInPlaceUpdate()) {
                codec.writeTag((byte)-128, 6);
                codec.writeInt(8);
                codec.writeLong(cmd.getVersion());
                codec.writeLong(prevPointer);
                codec.writeLong(cmd.prevVersion);
                if (cmd.getReq().getParamString().contains("cdcr.update")) {
                    codec.writePrimitive(true);
                } else {
                    codec.writePrimitive(false);
                }
                codec.writeSolrInputDocument(cmd.getSolrInputDocument());
            } else {
                codec.writeTag((byte)-128, 4);
                codec.writeInt(1);
                codec.writeLong(cmd.getVersion());
                if (cmd.getReq().getParamString().contains("cdcr.update")) {
                    codec.writePrimitive(true);
                } else {
                    codec.writePrimitive(false);
                }
                codec.writeSolrInputDocument(cmd.getSolrInputDocument());
            }
            this.lastAddSize = (int)out.size();
            CdcrTransactionLog cdcrTransactionLog = this;
            synchronized (cdcrTransactionLog) {
                long pos = this.fos.size();
                assert (pos != 0L);
                out.writeAll(this.fos);
                this.endRecord(pos);
                return pos;
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error logging add", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long writeDelete(DeleteUpdateCommand cmd) {
        TransactionLog.LogCodec codec = new TransactionLog.LogCodec(this, resolver);
        try {
            this.checkWriteHeader(codec, null);
            BytesRef br = cmd.getIndexedId();
            MemOutputStream out = new MemOutputStream(new byte[20 + br.length]);
            codec.init(out);
            codec.writeTag((byte)-128, 4);
            codec.writeInt(2);
            codec.writeLong(cmd.getVersion());
            codec.writeByteArray(br.bytes, br.offset, br.length);
            if (cmd.getReq().getParamString().contains("cdcr.update")) {
                codec.writePrimitive(true);
            } else {
                codec.writePrimitive(false);
            }
            CdcrTransactionLog cdcrTransactionLog = this;
            synchronized (cdcrTransactionLog) {
                long pos = this.fos.size();
                assert (pos != 0L);
                out.writeAll(this.fos);
                this.endRecord(pos);
                return pos;
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long writeDeleteByQuery(DeleteUpdateCommand cmd) {
        TransactionLog.LogCodec codec = new TransactionLog.LogCodec(this, resolver);
        try {
            this.checkWriteHeader(codec, null);
            MemOutputStream out = new MemOutputStream(new byte[20 + cmd.query.length()]);
            codec.init(out);
            codec.writeTag((byte)-128, 4);
            codec.writeInt(3);
            codec.writeLong(cmd.getVersion());
            codec.writeStr(cmd.query);
            if (cmd.getReq().getParamString().contains("cdcr.update")) {
                codec.writePrimitive(true);
            } else {
                codec.writePrimitive(false);
            }
            CdcrTransactionLog cdcrTransactionLog = this;
            synchronized (cdcrTransactionLog) {
                long pos = this.fos.size();
                out.writeAll(this.fos);
                this.endRecord(pos);
                return pos;
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public long writeCommit(CommitUpdateCommand cmd) {
        TransactionLog.LogCodec codec = new TransactionLog.LogCodec(this, resolver);
        CdcrTransactionLog cdcrTransactionLog = this;
        synchronized (cdcrTransactionLog) {
            try {
                long pos = this.fos.size();
                if (pos == 0L) {
                    this.writeLogHeader(codec);
                    pos = this.fos.size();
                }
                codec.init(this.fos);
                codec.writeTag((byte)-128, 4);
                codec.writeInt(4);
                codec.writeLong(cmd.getVersion());
                codec.writeTag((byte)6);
                this.fos.writeInt(this.numRecords + 1);
                codec.writeStr("SOLR_TLOG_END");
                this.endRecord(pos);
                this.fos.flush();
                assert (this.fos.size() == this.channel.size());
                this.isReplaying = false;
                return pos;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    @Override
    public TransactionLog.LogReader getReader(long startingPos) {
        return new CdcrLogReader(startingPos);
    }

    @Override
    public void incref() {
        if (this.refcount.getAndIncrement() == 0) {
            this.reopenOutputStream();
        }
    }

    @Override
    public boolean try_incref() {
        this.incref();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.debug) {
                log.debug("Closing tlog {}", (Object)this);
            }
            CdcrTransactionLog cdcrTransactionLog = this;
            synchronized (cdcrTransactionLog) {
                if (this.fos != null) {
                    this.fos.flush();
                    this.fos.close();
                    this.fos = null;
                    this.os = null;
                    this.channel = null;
                    this.raf = null;
                }
            }
            if (this.deleteOnClose) {
                try {
                    Files.deleteIfExists(this.tlogFile.toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        finally {
            assert (ObjectReleaseTracker.release(this));
        }
    }

    synchronized void reopenOutputStream() {
        try {
            if (this.debug) {
                log.debug("Re-opening tlog's output stream: {}", (Object)this);
            }
            this.raf = new RandomAccessFile(this.tlogFile, "rw");
            this.channel = this.raf.getChannel();
            long start = this.raf.length();
            this.raf.seek(start);
            this.os = Channels.newOutputStream(this.channel);
            this.fos = new FastOutputStream(this.os, new byte[65536], 0);
            this.fos.setWritten(start);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public class CdcrLogReader
    extends TransactionLog.LogReader {
        private int numRecords;

        public CdcrLogReader(long startingPos) {
            super(CdcrTransactionLog.this, startingPos);
            this.numRecords = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object next() throws IOException, InterruptedException {
            Object o = super.next();
            if (o != null) {
                ++this.numRecords;
                if (CdcrTransactionLog.this.isReplaying) {
                    CdcrTransactionLog cdcrTransactionLog = CdcrTransactionLog.this;
                    synchronized (cdcrTransactionLog) {
                        CdcrTransactionLog.this.numRecords = this.numRecords;
                    }
                }
            }
            return o;
        }
    }
}

