/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CdcrTransactionLog;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.TransactionLog;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcrUpdateLog
extends UpdateLog {
    protected final Map<CdcrLogReader, CdcrLogPointer> logPointers = new ConcurrentHashMap<CdcrLogReader, CdcrLogPointer>();
    private CdcrLogReader bufferToggle;
    public static String LOG_FILENAME_PATTERN = "%s.%019d.%1d";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean debug = log.isDebugEnabled();

    @Override
    public void init(UpdateHandler uhandler, SolrCore core) {
        for (CdcrLogReader reader : this.logPointers.keySet()) {
            reader.close();
        }
        this.logPointers.clear();
        super.init(uhandler, core);
    }

    @Override
    public TransactionLog newTransactionLog(File tlogFile, Collection<String> globalStrings, boolean openExisting) {
        return new CdcrTransactionLog(tlogFile, globalStrings, openExisting);
    }

    @Override
    protected void addOldLog(TransactionLog oldLog, boolean removeOld) {
        TransactionLog log;
        int nrec;
        if (oldLog == null) {
            return;
        }
        this.numOldRecords += oldLog.numRecords();
        int currRecords = this.numOldRecords;
        if (oldLog != this.tlog && this.tlog != null) {
            currRecords += this.tlog.numRecords();
        }
        while (removeOld && this.logs.size() > 0 && (currRecords - (nrec = (log = (TransactionLog)this.logs.peekLast()).numRecords()) >= this.numRecordsToKeep || this.logs.size() >= 10) && !this.hasLogPointer(log)) {
            currRecords -= nrec;
            this.numOldRecords -= nrec;
            TransactionLog last = (TransactionLog)this.logs.removeLast();
            last.deleteOnClose = true;
            last.close();
        }
        oldLog.deleteOnClose = false;
        oldLog.decref();
        this.logs.addFirst(oldLog);
    }

    private boolean hasLogPointer(TransactionLog tlog) {
        for (CdcrLogPointer pointer : this.logPointers.values()) {
            if (!pointer.isInitialised()) {
                return true;
            }
            if (pointer.tlogFile != tlog.tlogFile) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getLastLogId() {
        if (this.id != -1L) {
            return this.id;
        }
        if (this.tlogFiles.length == 0) {
            return -1L;
        }
        String last = this.tlogFiles[this.tlogFiles.length - 1];
        if (TLOG_NAME.length() + 1 > last.lastIndexOf(46)) {
            return Long.parseLong(last.substring(TLOG_NAME.length() + 1));
        }
        return Long.parseLong(last.substring(TLOG_NAME.length() + 1, last.lastIndexOf(46)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddUpdateCommand cmd, boolean clearCaches) {
        CdcrUpdateLog cdcrUpdateLog = this;
        synchronized (cdcrUpdateLog) {
            if ((cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                this.ensureLog(cmd.getVersion());
            }
        }
        super.add(cmd, clearCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteUpdateCommand cmd) {
        CdcrUpdateLog cdcrUpdateLog = this;
        synchronized (cdcrUpdateLog) {
            if ((cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                this.ensureLog(cmd.getVersion());
            }
        }
        super.delete(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByQuery(DeleteUpdateCommand cmd) {
        CdcrUpdateLog cdcrUpdateLog = this;
        synchronized (cdcrUpdateLog) {
            if ((cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                this.ensureLog(cmd.getVersion());
            }
        }
        super.deleteByQuery(cmd);
    }

    public CdcrLogReader newLogReader() {
        return new CdcrLogReader(new ArrayList(this.logs), this.tlog);
    }

    public void enableBuffer() {
        if (this.bufferToggle == null) {
            this.bufferToggle = this.newLogReader();
        }
    }

    public void disableBuffer() {
        if (this.bufferToggle != null) {
            this.bufferToggle.close();
            this.bufferToggle = null;
        }
    }

    public CdcrLogReader getBufferToggle() {
        return this.bufferToggle;
    }

    public boolean isBuffering() {
        return this.bufferToggle != null;
    }

    protected void ensureLog(long startVersion) {
        if (this.tlog == null) {
            long absoluteVersion = Math.abs(startVersion);
            if (this.tlog == null) {
                String newLogName = String.format(Locale.ROOT, LOG_FILENAME_PATTERN, TLOG_NAME, this.id, absoluteVersion);
                this.tlog = new CdcrTransactionLog(new File(this.tlogDir, newLogName), this.globalStrings);
            }
            for (CdcrLogReader reader : this.logPointers.keySet()) {
                reader.push(this.tlog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedUpdates resetForRecovery() {
        CdcrUpdateLog cdcrUpdateLog = this;
        synchronized (cdcrUpdateLog) {
            BufferedUpdates bufferedUpdates = new BufferedUpdates();
            if (this.state == UpdateLog.State.BUFFERING && this.tlog != null) {
                bufferedUpdates.tlog = this.tlog.tlogFile;
                bufferedUpdates.offset = this.recoveryInfo.positionOfStart;
            }
            for (CdcrLogReader reader : this.logPointers.keySet()) {
                reader.close();
            }
            this.logPointers.clear();
            this.doClose(this.prevTlog);
            this.doClose(this.tlog);
            for (TransactionLog log : this.logs) {
                if (log == this.prevTlog || log == this.tlog) continue;
                this.doClose(log);
            }
            this.logs.clear();
            this.newestLogsOnStartup.clear();
            this.prevTlog = null;
            this.tlog = null;
            this.prevMapLog2 = null;
            this.prevMapLog = null;
            this.map.clear();
            if (this.prevMap != null) {
                this.prevMap.clear();
            }
            if (this.prevMap2 != null) {
                this.prevMap2.clear();
            }
            this.tlogFiles = null;
            this.numOldRecords = 0;
            this.oldDeletes.clear();
            this.deleteByQueries.clear();
            return bufferedUpdates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initForRecovery(File bufferedTlog, long offset) {
        this.tlogFiles = this.getLogList(this.tlogDir);
        this.id = this.getLastLogId() + 1L;
        if (this.debug) {
            log.debug("UpdateHandler init: tlogDir={}, existing tlogs={}, next id={}", new Object[]{this.tlogDir, Arrays.asList(this.tlogFiles), this.id});
        }
        TransactionLog oldLog = null;
        for (String oldLogName : this.tlogFiles) {
            File f = new File(this.tlogDir, oldLogName);
            try {
                oldLog = this.newTransactionLog(f, null, true);
                this.addOldLog(oldLog, false);
            }
            catch (Exception e) {
                SolrException.log(log, "Failure to open existing log file (non fatal) " + f, e);
                CdcrUpdateLog.deleteFile(f);
            }
        }
        for (TransactionLog ll : this.logs) {
            this.newestLogsOnStartup.addFirst(ll);
            if (this.newestLogsOnStartup.size() < 2) continue;
            break;
        }
        UpdateLog.RecentUpdates startingUpdates = this.getRecentUpdates();
        long latestVersion = startingUpdates.getMaxRecentVersion();
        try {
            int i;
            this.startingVersions = startingUpdates.getVersions(this.numRecordsToKeep);
            for (i = startingUpdates.deleteList.size() - 1; i >= 0; --i) {
                UpdateLog.DeleteUpdate du = startingUpdates.deleteList.get(i);
                this.oldDeletes.put(new BytesRef(du.id), new UpdateLog.LogPtr(-1L, du.version));
            }
            for (i = startingUpdates.deleteByQueryList.size() - 1; i >= 0; --i) {
                UpdateLog.Update update = startingUpdates.deleteByQueryList.get(i);
                List dbq = (List)update.log.lookup(update.pointer);
                long version = (Long)dbq.get(1);
                String q = (String)dbq.get(2);
                this.trackDeleteByQuery(q, version);
            }
        }
        finally {
            startingUpdates.close();
        }
        if (bufferedTlog != null) {
            this.copyBufferedUpdates(bufferedTlog, offset, latestVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBufferedUpdates(File tlogSrc, long offsetSrc, long latestVersion) {
        block18: {
            this.recoveryInfo = new UpdateLog.RecoveryInfo();
            this.state = UpdateLog.State.BUFFERING;
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("update.distrib", DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString());
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.uhandler.core, params);
            CdcrTransactionLog src = new CdcrTransactionLog(tlogSrc, null, true);
            TransactionLog.LogReader tlogReader = src.getReader(offsetSrc);
            try {
                int oper;
                int operationAndFlags = 0;
                block15: while (true) {
                    Object o;
                    if ((o = tlogReader.next()) == null) {
                        break block18;
                    }
                    List entry = (List)o;
                    operationAndFlags = (Integer)entry.get(0);
                    oper = operationAndFlags & 0xF;
                    long version = (Long)entry.get(1);
                    if (version <= latestVersion) {
                        log.debug("Dropping buffered operation - version {} < {}", (Object)version, (Object)latestVersion);
                        continue;
                    }
                    switch (oper) {
                        case 1: {
                            SolrInputDocument sdoc = (SolrInputDocument)entry.get(entry.size() - 1);
                            UpdateCommand cmd = new AddUpdateCommand(req);
                            ((AddUpdateCommand)cmd).solrDoc = sdoc;
                            cmd.setVersion(version);
                            cmd.setFlags(UpdateCommand.BUFFERING);
                            this.add((AddUpdateCommand)cmd);
                            continue block15;
                        }
                        case 2: {
                            byte[] idBytes = (byte[])entry.get(2);
                            UpdateCommand cmd = new DeleteUpdateCommand(req);
                            ((DeleteUpdateCommand)cmd).setIndexedId(new BytesRef(idBytes));
                            cmd.setVersion(version);
                            cmd.setFlags(UpdateCommand.BUFFERING);
                            this.delete((DeleteUpdateCommand)cmd);
                            continue block15;
                        }
                        case 3: {
                            String query = (String)entry.get(2);
                            UpdateCommand cmd = new DeleteUpdateCommand(req);
                            ((DeleteUpdateCommand)cmd).query = query;
                            cmd.setVersion(version);
                            cmd.setFlags(UpdateCommand.BUFFERING);
                            this.deleteByQuery((DeleteUpdateCommand)cmd);
                            continue block15;
                        }
                    }
                    break;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid Operation! " + oper);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to copy buffered updates", (Throwable)e);
            }
            finally {
                try {
                    tlogReader.close();
                }
                finally {
                    this.doClose(src);
                }
            }
        }
    }

    private void doClose(TransactionLog theLog) {
        if (theLog != null) {
            theLog.deleteOnClose = false;
            theLog.decref();
            theLog.forceClose();
        }
    }

    @Override
    public void close(boolean committed, boolean deleteOnClose) {
        for (CdcrLogReader reader : new ArrayList<CdcrLogReader>(this.logPointers.keySet())) {
            reader.close();
        }
        super.close(committed, deleteOnClose);
    }

    public class CdcrLogReader {
        private TransactionLog currentTlog;
        private TransactionLog.LogReader tlogReader;
        private final LinkedBlockingDeque<TransactionLog> tlogs = new LinkedBlockingDeque();
        private final CdcrLogPointer pointer;
        private long lastPositionInTLog = 0L;
        private long lastVersion = -1L;
        private long nextToLastVersion = -1L;
        private long numRecordsReadInCurrentTlog = 0L;

        private CdcrLogReader(List<TransactionLog> tlogs, TransactionLog tlog) {
            this.tlogs.addAll(tlogs);
            if (tlog != null) {
                this.tlogs.push(tlog);
            }
            this.pointer = new CdcrLogPointer();
            CdcrUpdateLog.this.logPointers.put(this, this.pointer);
            this.currentTlog = this.tlogs.peekLast();
            if (this.currentTlog != null) {
                this.tlogReader = this.currentTlog.getReader(0L);
                this.pointer.set(this.currentTlog.tlogFile);
                this.numRecordsReadInCurrentTlog = 0L;
                log.debug("Init new tlog reader for {} - tlogReader = {}", (Object)this.currentTlog.tlogFile, (Object)this.tlogReader);
            }
        }

        private void push(TransactionLog tlog) {
            this.tlogs.push(tlog);
            if (this.currentTlog == null && !this.tlogs.isEmpty()) {
                this.currentTlog = this.tlogs.peekLast();
                this.tlogReader = this.currentTlog.getReader(0L);
                this.pointer.set(this.currentTlog.tlogFile);
                this.numRecordsReadInCurrentTlog = 0L;
                log.debug("Init new tlog reader for {} - tlogReader = {}", (Object)this.currentTlog.tlogFile, (Object)this.tlogReader);
            }
        }

        public CdcrLogReader getSubReader() {
            CdcrLogReader clone = new CdcrLogReader(new ArrayList<TransactionLog>(), this.tlogs.peekLast());
            clone.tlogs.clear();
            clone.tlogs.addAll(this.tlogs);
            clone.lastPositionInTLog = this.lastPositionInTLog;
            clone.numRecordsReadInCurrentTlog = this.numRecordsReadInCurrentTlog;
            clone.lastVersion = this.lastVersion;
            clone.nextToLastVersion = this.nextToLastVersion;
            if (this.tlogReader != null) {
                clone.tlogReader.close();
                clone.tlogReader = this.currentTlog.getReader(this.tlogReader.currentPos());
            }
            return clone;
        }

        public void forwardSeek(CdcrLogReader subReader) {
            if (subReader.tlogReader == null) {
                return;
            }
            this.tlogReader.close();
            while (this.tlogs.peekLast().id < subReader.tlogs.peekLast().id) {
                this.tlogs.removeLast();
                this.currentTlog = this.tlogs.peekLast();
            }
            assert (this.tlogs.peekLast().id == subReader.tlogs.peekLast().id) : this.tlogs.peekLast().id + " != " + subReader.tlogs.peekLast().id;
            this.pointer.set(this.currentTlog.tlogFile);
            this.lastPositionInTLog = subReader.lastPositionInTLog;
            this.numRecordsReadInCurrentTlog = subReader.numRecordsReadInCurrentTlog;
            this.lastVersion = subReader.lastVersion;
            this.nextToLastVersion = subReader.nextToLastVersion;
            this.tlogReader = this.currentTlog.getReader(subReader.tlogReader.currentPos());
        }

        public Object next() throws IOException, InterruptedException {
            while (!this.tlogs.isEmpty()) {
                this.lastPositionInTLog = this.tlogReader.currentPos();
                Object o = this.tlogReader.next();
                if (o != null) {
                    this.pointer.set(this.currentTlog.tlogFile);
                    this.nextToLastVersion = this.lastVersion;
                    this.lastVersion = this.getVersion(o);
                    ++this.numRecordsReadInCurrentTlog;
                    return o;
                }
                if (this.tlogs.size() > 1) {
                    this.tlogReader.close();
                    this.tlogs.removeLast();
                    this.currentTlog = this.tlogs.peekLast();
                    this.tlogReader = this.currentTlog.getReader(0L);
                    this.pointer.set(this.currentTlog.tlogFile);
                    this.numRecordsReadInCurrentTlog = 0L;
                    log.debug("Init new tlog reader for {} - tlogReader = {}", (Object)this.currentTlog.tlogFile, (Object)this.tlogReader);
                    continue;
                }
                return null;
            }
            return null;
        }

        public boolean seek(long targetVersion) throws IOException, InterruptedException {
            Object o;
            targetVersion = Math.abs(targetVersion);
            if (this.tlogs.isEmpty() || !this.seekTLog(targetVersion)) {
                return false;
            }
            while ((o = this.next()) != null) {
                if (this.getVersion(o) < targetVersion) continue;
                this.resetToLastPosition();
                return true;
            }
            return true;
        }

        private boolean seekTLog(long targetVersion) {
            if (targetVersion < ((CdcrTransactionLog)this.tlogs.peekLast()).startVersion) {
                return false;
            }
            this.tlogReader.close();
            TransactionLog last = null;
            while (this.tlogs.size() > 1 && ((CdcrTransactionLog)this.tlogs.peekLast()).startVersion < targetVersion) {
                last = this.tlogs.pollLast();
            }
            if (last != null) {
                this.tlogs.addLast(last);
            }
            this.currentTlog = this.tlogs.peekLast();
            this.tlogReader = this.currentTlog.getReader(0L);
            this.pointer.set(this.currentTlog.tlogFile);
            this.numRecordsReadInCurrentTlog = 0L;
            return true;
        }

        private long getVersion(Object o) {
            List entry = (List)o;
            return Math.abs((Long)entry.get(1));
        }

        public void resetToLastPosition() {
            try {
                if (this.tlogReader != null) {
                    this.tlogReader.fis.seek(this.lastPositionInTLog);
                    --this.numRecordsReadInCurrentTlog;
                    this.lastVersion = this.nextToLastVersion;
                }
            }
            catch (IOException e) {
                log.error("Failed to seek last position in tlog", (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to seek last position in tlog", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumberOfRemainingRecords() {
            long numRemainingRecords = 0L;
            LinkedBlockingDeque<TransactionLog> linkedBlockingDeque = this.tlogs;
            synchronized (linkedBlockingDeque) {
                for (TransactionLog tlog : this.tlogs) {
                    numRemainingRecords += (long)(tlog.numRecords() - 1);
                }
            }
            return numRemainingRecords - this.numRecordsReadInCurrentTlog;
        }

        public void close() {
            if (this.tlogReader != null) {
                this.tlogReader.close();
                this.tlogReader = null;
                this.currentTlog = null;
            }
            this.tlogs.clear();
            CdcrUpdateLog.this.logPointers.remove(this);
        }

        public long getLastVersion() {
            return this.lastVersion == 0L ? this.nextToLastVersion : this.lastVersion;
        }
    }

    private static class CdcrLogPointer {
        File tlogFile = null;

        private CdcrLogPointer() {
        }

        private void set(File tlogFile) {
            this.tlogFile = tlogFile;
        }

        private boolean isInitialised() {
            return this.tlogFile != null;
        }

        public String toString() {
            return "CdcrLogPointer(" + this.tlogFile + ")";
        }
    }

    public static class BufferedUpdates {
        public File tlog;
        public long offset;
    }
}

