/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneFieldUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SOURCE_PARAM = "source";
    public static final String DEST_PARAM = "dest";
    public static final String PATTERN_PARAM = "pattern";
    public static final String REPLACEMENT_PARAM = "replacement";
    private FieldMutatingUpdateProcessorFactory.SelectorParams srcInclusions = new FieldMutatingUpdateProcessorFactory.SelectorParams();
    private Collection<FieldMutatingUpdateProcessorFactory.SelectorParams> srcExclusions = new ArrayList<FieldMutatingUpdateProcessorFactory.SelectorParams>();
    private FieldMutatingUpdateProcessor.FieldNameSelector srcSelector = null;
    private String dest = null;
    private Pattern pattern = null;

    protected final FieldMutatingUpdateProcessor.FieldNameSelector getSourceSelector() {
        if (null != this.srcSelector) {
            return this.srcSelector;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "selector was never initialized,  inform(SolrCore) never called???");
    }

    @Override
    public void init(NamedList args) {
        if (0 <= args.indexOf(SOURCE_PARAM, 0) && 0 <= args.indexOf(DEST_PARAM, 0)) {
            this.initSourceSelectorSyntax(args);
        } else if (0 <= args.indexOf(PATTERN_PARAM, 0) && 0 <= args.indexOf(REPLACEMENT_PARAM, 0)) {
            this.initSimpleRegexReplacement(args);
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A combination of either 'source' + 'dest', or 'replacement' + 'pattern' init params are mandatory");
        }
        if (0 < args.size()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected init param(s): '" + args.getName(0) + "'");
        }
        super.init(args);
    }

    private void initSimpleRegexReplacement(NamedList args) {
        if (0 <= args.indexOf(SOURCE_PARAM, 0) || 0 <= args.indexOf(DEST_PARAM, 0)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Short hand syntax must not be mixed with full syntax. Found pattern and replacement but also found source or dest");
        }
        assert (args.indexOf(SOURCE_PARAM, 0) < 0);
        Object patt = args.remove(PATTERN_PARAM);
        Object replacement = args.remove(REPLACEMENT_PARAM);
        if (null == patt || null == replacement) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init params 'pattern' and 'replacement' are both mandatory if 'source' and 'dest' are not both specified");
        }
        if (0 != args.size()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init params 'replacement' and 'pattern' must be children of 'dest' to be combined with other options.");
        }
        if (!(replacement instanceof String)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'replacement' must be a string (i.e. <str>)");
        }
        if (!(patt instanceof String)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'pattern' must be a string (i.e. <str>)");
        }
        this.dest = replacement.toString();
        try {
            this.pattern = Pattern.compile(patt.toString());
        }
        catch (PatternSyntaxException pe) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param pattern is not a valid regex pattern: " + patt, (Throwable)pe);
        }
        this.srcInclusions = new FieldMutatingUpdateProcessorFactory.SelectorParams();
        this.srcInclusions.fieldRegex = Collections.singletonList(this.pattern);
    }

    private void initSourceSelectorSyntax(NamedList args) {
        if (0 <= args.indexOf(PATTERN_PARAM, 0) || 0 <= args.indexOf(REPLACEMENT_PARAM, 0)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Short hand syntax must not be mixed with full syntax. Found source and dest but also found pattern or replacement");
        }
        Object d = args.remove(DEST_PARAM);
        assert (null != d);
        List sources = args.getAll(SOURCE_PARAM);
        assert (null != sources);
        if (1 == sources.size() && sources.get(0) instanceof NamedList) {
            NamedList selectorConfig = (NamedList)args.remove(SOURCE_PARAM);
            this.srcInclusions = CloneFieldUpdateProcessorFactory.parseSelectorParams(selectorConfig);
            List excList = selectorConfig.getAll("exclude");
            for (Object excObj : excList) {
                if (null == excObj) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'source' child 'exclude' can not be null");
                }
                if (!(excObj instanceof NamedList)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'source' child 'exclude' must be <lst/>");
                }
                NamedList exc = (NamedList)excObj;
                this.srcExclusions.add(CloneFieldUpdateProcessorFactory.parseSelectorParams(exc));
                if (0 < exc.size()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'source' has unexpected 'exclude' sub-param(s): '" + selectorConfig.getName(0) + "'");
                }
                selectorConfig.remove("exclude");
            }
            if (0 < selectorConfig.size()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'source' contains unexpected child param(s): '" + selectorConfig.getName(0) + "'");
            }
            sources.remove(0);
        }
        if (1 <= sources.size()) {
            this.srcInclusions.fieldName = new HashSet<String>(args.removeConfigArgs(SOURCE_PARAM));
        }
        if (this.srcInclusions == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init params do not specify anything to clone, please supply either source and dest or pattern and replacement. See javadocsfor CloneFieldUpdateProcessorFactory for further details.");
        }
        if (d instanceof NamedList) {
            NamedList destList = (NamedList)d;
            Object patt = destList.remove(PATTERN_PARAM);
            Object replacement = destList.remove(REPLACEMENT_PARAM);
            if (null == patt || null == replacement) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'dest' children 'pattern' and 'replacement' are both mandatoryand can not be null");
            }
            if (!(patt instanceof String) || !(replacement instanceof String)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'dest' children 'pattern' and 'replacement' must both be strings (i.e. <str>)");
            }
            if (0 != destList.size()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'dest' has unexpected children: '" + destList.getName(0) + "'");
            }
            try {
                this.pattern = Pattern.compile(patt.toString());
            }
            catch (PatternSyntaxException pe) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'dest' child 'pattern is not a valid regex pattern: " + patt, (Throwable)pe);
            }
            this.dest = replacement.toString();
        } else if (d instanceof String) {
            this.dest = d.toString();
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'dest' must either be a string (i.e. <str>) or a list (i.e. <lst>) containing 'pattern' and 'replacement");
        }
    }

    @Override
    public void inform(SolrCore core) {
        this.srcSelector = FieldMutatingUpdateProcessor.createFieldNameSelector(core.getResourceLoader(), core, this.srcInclusions, FieldMutatingUpdateProcessor.SELECT_NO_FIELDS);
        for (FieldMutatingUpdateProcessorFactory.SelectorParams exc : this.srcExclusions) {
            this.srcSelector = FieldMutatingUpdateProcessor.wrap(this.srcSelector, FieldMutatingUpdateProcessor.createFieldNameSelector(core.getResourceLoader(), core, exc, FieldMutatingUpdateProcessor.SELECT_NO_FIELDS));
        }
    }

    @Override
    public final UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        final FieldMutatingUpdateProcessor.FieldNameSelector srcSelector = this.getSourceSelector();
        return new UpdateRequestProcessor(next){

            @Override
            public void processAdd(AddUpdateCommand cmd) throws IOException {
                SolrInputDocument doc = cmd.getSolrInputDocument();
                HashMap<String, SolrInputField> destMap = new HashMap<String, SolrInputField>();
                for (String string : doc.getFieldNames()) {
                    SolrInputField targetField;
                    Collection<Object> srcFieldValues;
                    if (!srcSelector.shouldMutate(string) || (srcFieldValues = doc.getFieldValues(string)) == null || srcFieldValues.isEmpty()) continue;
                    String resolvedDest = CloneFieldUpdateProcessorFactory.this.dest;
                    if (CloneFieldUpdateProcessorFactory.this.pattern != null) {
                        Matcher matcher = CloneFieldUpdateProcessorFactory.this.pattern.matcher(string);
                        if (matcher.find()) {
                            resolvedDest = matcher.replaceAll(CloneFieldUpdateProcessorFactory.this.dest);
                        } else {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("CloneFieldUpdateProcessor.srcSelector.shouldMutate('{}') returned true, but replacement pattern did not match, field skipped.", (Object)string);
                            continue;
                        }
                    }
                    SolrInputField destField = doc.containsKey(resolvedDest) ? doc.getField(resolvedDest) : ((targetField = (SolrInputField)destMap.get(resolvedDest)) == null ? new SolrInputField(resolvedDest) : targetField);
                    for (Object val : srcFieldValues) {
                        destField.addValue(val);
                    }
                    destMap.put(resolvedDest, destField);
                }
                for (Map.Entry entry : destMap.entrySet()) {
                    doc.put((String)entry.getKey(), (SolrInputField)entry.getValue());
                }
                super.processAdd(cmd);
            }
        };
    }

    private static FieldMutatingUpdateProcessorFactory.SelectorParams parseSelectorParams(NamedList args) {
        return FieldMutatingUpdateProcessorFactory.parseSelectorParams(args);
    }
}

