/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreCommitOptimizeUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_RESPONSE_MSG = "Explicit commit/optimize requests are forbidden!";
    protected SolrException.ErrorCode errorCode;
    protected String responseMsg;
    protected boolean ignoreOptimizeOnly = false;

    @Override
    public void init(NamedList args) {
        SolrParams params;
        SolrParams solrParams = params = args != null ? args.toSolrParams() : null;
        if (params == null) {
            this.errorCode = SolrException.ErrorCode.FORBIDDEN;
            this.responseMsg = DEFAULT_RESPONSE_MSG;
            this.ignoreOptimizeOnly = false;
            return;
        }
        this.ignoreOptimizeOnly = params.getBool("ignoreOptimizeOnly", false);
        int statusCode = params.getInt("statusCode", SolrException.ErrorCode.FORBIDDEN.code);
        if (statusCode == 200) {
            this.errorCode = null;
            this.responseMsg = params.get("responseMessage");
        } else {
            this.errorCode = SolrException.ErrorCode.getErrorCode(statusCode);
            if (this.errorCode == SolrException.ErrorCode.UNKNOWN) {
                StringBuilder validCodes = new StringBuilder();
                int appended = 0;
                for (SolrException.ErrorCode code : SolrException.ErrorCode.values()) {
                    if (code == SolrException.ErrorCode.UNKNOWN) continue;
                    if (appended++ > 0) {
                        validCodes.append(", ");
                    }
                    validCodes.append(code.code);
                }
                throw new IllegalArgumentException("Configured status code " + statusCode + " not supported! Please choose one of: " + validCodes.toString());
            }
            this.responseMsg = params.get("responseMessage", DEFAULT_RESPONSE_MSG);
        }
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new IgnoreCommitOptimizeUpdateProcessor(rsp, this, next);
    }

    static class IgnoreCommitOptimizeUpdateProcessor
    extends UpdateRequestProcessor {
        private final SolrQueryResponse rsp;
        private final SolrException.ErrorCode errorCode;
        private final String responseMsg;
        private final boolean ignoreOptimizeOnly;

        IgnoreCommitOptimizeUpdateProcessor(SolrQueryResponse rsp, IgnoreCommitOptimizeUpdateProcessorFactory factory, UpdateRequestProcessor next) {
            super(next);
            this.rsp = rsp;
            this.errorCode = factory.errorCode;
            this.responseMsg = factory.responseMsg;
            this.ignoreOptimizeOnly = factory.ignoreOptimizeOnly;
        }

        @Override
        public void processCommit(CommitUpdateCommand cmd) throws IOException {
            String cmdType;
            if (this.ignoreOptimizeOnly && !cmd.optimize) {
                if (this.next != null) {
                    this.next.processCommit(cmd);
                }
                return;
            }
            if (cmd.getReq().getParams().getBool("commit_end_point", false)) {
                if (this.next != null) {
                    this.next.processCommit(cmd);
                }
                return;
            }
            String string = cmdType = cmd.optimize ? "optimize" : "commit";
            if (this.errorCode != null) {
                log.info("{} from client application ignored with error code: {}", (Object)cmdType, (Object)this.errorCode.code);
                this.rsp.setException(new SolrException(this.errorCode, this.responseMsg));
            } else {
                log.info("{} from client application ignored with status code: 200", (Object)cmdType);
                if (this.responseMsg != null) {
                    NamedList<Object> responseHeader = this.rsp.getResponseHeader();
                    if (responseHeader != null) {
                        responseHeader.add("msg", this.responseMsg);
                    } else {
                        responseHeader = new SimpleOrderedMap<Object>();
                        responseHeader.add("msg", this.responseMsg);
                        this.rsp.addResponseHeader(responseHeader);
                    }
                }
            }
        }
    }
}

