/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.processor.AllValuesOrNoneFieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class ParseBooleanFieldUpdateProcessorFactory
extends FieldMutatingUpdateProcessorFactory {
    private static final String TRUE_VALUES_PARAM = "trueValue";
    private static final String FALSE_VALUES_PARAM = "falseValue";
    private static final String CASE_SENSITIVE_PARAM = "caseSensitive";
    private final Set<String> trueValues = new HashSet<String>(Arrays.asList("true"));
    private final Set<String> falseValues = new HashSet<String>(Arrays.asList("false"));
    private boolean caseSensitive = false;

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new AllValuesOrNoneFieldMutatingUpdateProcessor(this.getSelector(), next){

            @Override
            protected Object mutateValue(Object srcVal) {
                Object parsed = ParseBooleanFieldUpdateProcessorFactory.parsePossibleBoolean(srcVal, ParseBooleanFieldUpdateProcessorFactory.this.caseSensitive, ParseBooleanFieldUpdateProcessorFactory.this.trueValues, ParseBooleanFieldUpdateProcessorFactory.this.falseValues);
                return parsed != null ? parsed : SKIP_FIELD_VALUE_LIST_SINGLETON;
            }
        };
    }

    @Override
    public void init(NamedList args) {
        Collection<String> falseValuesParam;
        Collection<String> trueValuesParam;
        Object caseSensitiveParam = args.remove(CASE_SENSITIVE_PARAM);
        if (null != caseSensitiveParam) {
            this.caseSensitive = caseSensitiveParam instanceof Boolean ? (Boolean)caseSensitiveParam : Boolean.parseBoolean(caseSensitiveParam.toString());
        }
        if (!(trueValuesParam = args.removeConfigArgs(TRUE_VALUES_PARAM)).isEmpty()) {
            this.trueValues.clear();
            for (String trueVal : trueValuesParam) {
                this.trueValues.add(this.caseSensitive ? trueVal : trueVal.toLowerCase(Locale.ROOT));
            }
        }
        if (!(falseValuesParam = args.removeConfigArgs(FALSE_VALUES_PARAM)).isEmpty()) {
            this.falseValues.clear();
            for (String val : falseValuesParam) {
                String falseVal;
                String string = falseVal = this.caseSensitive ? val : val.toLowerCase(Locale.ROOT);
                if (this.trueValues.contains(falseVal)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Param 'falseValue' contains a value also in param 'trueValue': '" + val + "'");
                }
                this.falseValues.add(falseVal);
            }
        }
        super.init(args);
    }

    @Override
    public FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return fieldName -> {
            IndexSchema schema = core.getLatestSchema();
            FieldType type = schema.getFieldTypeNoEx(fieldName);
            return null == type || type instanceof BoolField;
        };
    }

    public static Object parsePossibleBoolean(Object srcVal, boolean caseSensitive, Set<String> trueValues, Set<String> falseValues) {
        if (srcVal instanceof CharSequence) {
            String stringVal;
            String string = stringVal = caseSensitive ? srcVal.toString() : srcVal.toString().toLowerCase(Locale.ROOT);
            if (trueValues.contains(stringVal)) {
                return true;
            }
            if (falseValues.contains(stringVal)) {
                return false;
            }
            return null;
        }
        if (srcVal instanceof Boolean) {
            return srcVal;
        }
        return null;
    }
}

