/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.PreAnalyzedField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreAnalyzedUpdateProcessor
extends FieldMutatingUpdateProcessor {
    private PreAnalyzedField parser;
    private IndexSchema schema;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PreAnalyzedUpdateProcessor(FieldMutatingUpdateProcessor.FieldNameSelector sel, UpdateRequestProcessor next, IndexSchema schema, PreAnalyzedField parser) {
        super(sel, next);
        this.schema = schema;
        this.parser = parser;
    }

    @Override
    protected SolrInputField mutate(SolrInputField src) {
        SchemaField sf = this.schema.getFieldOrNull(src.getName());
        if (sf == null) {
            return null;
        }
        FieldType type = PreAnalyzedField.createFieldType(sf);
        if (type == null) {
            return null;
        }
        SolrInputField res = new SolrInputField(src.getName());
        for (Object o : src) {
            if (o == null) continue;
            Field pre = (Field)this.parser.createField(sf, o);
            if (pre != null) {
                res.addValue(pre);
                continue;
            }
            log.warn("Could not parse field {} - using original value as is: {}", (Object)src.getName(), o);
            res.addValue(o);
        }
        return res;
    }
}

