/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.Cache;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.SimpleUpdateProcessorFactory;
import org.apache.solr.util.ConcurrentLRUCache;

public class TemplateUpdateProcessorFactory
extends SimpleUpdateProcessorFactory {
    private Cache<String, Resolved> templateCache = new ConcurrentLRUCache<String, Resolved>(1000, 800, 900, 10, false, false, null);
    public static final String NAME = "template";
    public static final Pattern DOLLAR_BRACES_PLACEHOLDER_PATTERN = Pattern.compile("[$][{](.*?)[}]");
    public static final Pattern BRACES_PLACEHOLDER_PATTERN = Pattern.compile("[{](.*?)[}]");

    @Override
    protected void process(AddUpdateCommand cmd, SolrQueryRequest req, SolrQueryResponse rsp) {
        String[] vals = this.getParams("field");
        SolrInputDocument doc = cmd.getSolrInputDocument();
        if (vals != null && vals.length > 0) {
            for (String val : vals) {
                if (val == null || val.isEmpty()) continue;
                int idx = val.indexOf(58);
                if (idx == -1) {
                    throw new RuntimeException("'field' must be of the format <field-name>:<the-template-string>");
                }
                String fName = val.substring(0, idx);
                String template = val.substring(idx + 1);
                doc.addField(fName, TemplateUpdateProcessorFactory.replaceTokens(template, this.templateCache, s -> {
                    Object v = doc.getFieldValue((String)s);
                    return v == null ? "" : v;
                }, BRACES_PLACEHOLDER_PATTERN));
            }
        }
    }

    @Override
    protected String getMyName() {
        return NAME;
    }

    public static Resolved getResolved(String template, Cache<String, Resolved> cache, Pattern pattern) {
        Resolved r;
        Resolved resolved = r = cache == null ? null : cache.get(template);
        if (r == null) {
            r = new Resolved();
            Matcher m = pattern.matcher(template);
            while (m.find()) {
                String variable = m.group(1);
                r.startIndexes.add(m.start(0));
                r.endOffsets.add(m.end(0));
                r.variables.add(variable);
            }
            if (cache != null) {
                cache.put(template, r);
            }
        }
        return r;
    }

    public static List<String> getVariables(String template, Cache<String, Resolved> cache, Pattern pattern) {
        Resolved r = TemplateUpdateProcessorFactory.getResolved(template, cache, pattern);
        if (r == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(r.variables);
    }

    public static String replaceTokens(String template, Cache<String, Resolved> cache, Function<String, Object> fun, Pattern pattern) {
        if (template == null) {
            return null;
        }
        Resolved r = TemplateUpdateProcessorFactory.getResolved(template, cache, pattern);
        if (r.startIndexes != null) {
            StringBuilder sb = new StringBuilder(template);
            for (int i = r.startIndexes.size() - 1; i >= 0; --i) {
                String replacement = fun.apply(r.variables.get(i)).toString();
                sb.replace(r.startIndexes.get(i), r.endOffsets.get(i), replacement);
            }
            return sb.toString();
        }
        return template;
    }

    public static class Resolved {
        public List<Integer> startIndexes = new ArrayList<Integer>(2);
        public List<Integer> endOffsets = new ArrayList<Integer>(2);
        public List<String> variables = new ArrayList<String>(2);
    }
}

