/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.util.TimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionThrottle {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile Long lastActionStartedAt;
    private volatile Long minMsBetweenActions;
    private final String name;
    private final TimeSource timeSource;

    public ActionThrottle(String name, long minMsBetweenActions) {
        this(name, minMsBetweenActions, TimeSource.NANO_TIME);
    }

    public ActionThrottle(String name, long minMsBetweenActions, TimeSource timeSource) {
        this.name = name;
        this.minMsBetweenActions = minMsBetweenActions;
        this.timeSource = timeSource;
    }

    public ActionThrottle(String name, long minMsBetweenActions, long lastActionStartedAt) {
        this(name, minMsBetweenActions, lastActionStartedAt, TimeSource.NANO_TIME);
    }

    public ActionThrottle(String name, long minMsBetweenActions, long lastActionStartedAt, TimeSource timeSource) {
        this.name = name;
        this.minMsBetweenActions = minMsBetweenActions;
        this.lastActionStartedAt = lastActionStartedAt;
        this.timeSource = timeSource;
    }

    public void reset() {
        this.lastActionStartedAt = null;
    }

    public void markAttemptingAction() {
        this.lastActionStartedAt = this.timeSource.getTimeNs();
    }

    public void minimumWaitBetweenActions() {
        if (this.lastActionStartedAt == null) {
            return;
        }
        long diff = this.timeSource.getTimeNs() - this.lastActionStartedAt;
        int diffMs = (int)TimeUnit.MILLISECONDS.convert(diff, TimeUnit.NANOSECONDS);
        long minNsBetweenActions = TimeUnit.NANOSECONDS.convert(this.minMsBetweenActions, TimeUnit.MILLISECONDS);
        log.debug("The last {} attempt started {}ms ago.", (Object)this.name, (Object)diffMs);
        int sleep = 0;
        if (diffMs > 0 && diff < minNsBetweenActions) {
            sleep = (int)TimeUnit.MILLISECONDS.convert(minNsBetweenActions - diff, TimeUnit.NANOSECONDS);
        } else if (diffMs == 0) {
            sleep = this.minMsBetweenActions.intValue();
        }
        if (sleep > 0) {
            log.info("Throttling {} attempts - waiting for {}ms", (Object)this.name, (Object)sleep);
            try {
                this.timeSource.sleep(sleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Long getLastActionStartedAt() {
        return this.lastActionStartedAt;
    }
}

