/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteReplicaCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public DeleteReplicaCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        this.deleteReplica(clusterState, message, results, null);
    }

    void deleteReplica(ClusterState clusterState, ZkNodeProps message, NamedList results, Runnable onComplete) throws KeeperException, InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("deleteReplica() : {}", (Object)Utils.toJSONString(message));
        }
        boolean parallel = message.getBool("parallel", false);
        if (message.getStr("count") != null) {
            this.deleteReplicaBasedOnCount(clusterState, message, results, onComplete, parallel);
            return;
        }
        this.ocmh.checkRequired(message, "collection", "shard", "replica");
        String extCollectionName = message.getStr("collection");
        String shard = message.getStr("shard");
        String replicaName = message.getStr("replica");
        boolean followAliases = message.getBool("followAliases", false);
        String collectionName = followAliases ? this.ocmh.cloudManager.getClusterStateProvider().resolveSimpleAlias(extCollectionName) : extCollectionName;
        DocCollection coll = clusterState.getCollection(collectionName);
        Slice slice = coll.getSlice(shard);
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid shard name : " + shard + " in collection : " + collectionName);
        }
        this.deleteCore(slice, collectionName, replicaName, message, shard, results, onComplete, parallel);
    }

    void deleteReplicaBasedOnCount(ClusterState clusterState, ZkNodeProps message, NamedList results, Runnable onComplete, boolean parallel) throws KeeperException, InterruptedException {
        this.ocmh.checkRequired(message, "collection", "count");
        int count = Integer.parseInt(message.getStr("count"));
        String collectionName = message.getStr("collection");
        String shard = message.getStr("shard");
        DocCollection coll = clusterState.getCollection(collectionName);
        Slice slice = null;
        if (shard != null && (slice = coll.getSlice(shard)) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid shard name : " + shard + " in collection : " + collectionName);
        }
        HashMap<Slice, Set<String>> shardToReplicasMapping = new HashMap<Slice, Set<String>>();
        if (slice != null) {
            Set<String> replicasToBeDeleted = this.pickReplicasTobeDeleted(slice, shard, collectionName, count);
            shardToReplicasMapping.put(slice, replicasToBeDeleted);
        } else {
            Collection<Slice> allSlices = coll.getSlices();
            for (Slice individualSlice : allSlices) {
                Set<String> replicasToBeDeleted = this.pickReplicasTobeDeleted(individualSlice, individualSlice.getName(), collectionName, count);
                shardToReplicasMapping.put(individualSlice, replicasToBeDeleted);
            }
        }
        for (Map.Entry entry : shardToReplicasMapping.entrySet()) {
            Slice shardSlice = (Slice)entry.getKey();
            String shardId = shardSlice.getName();
            Set replicas = (Set)entry.getValue();
            for (String replica : replicas) {
                log.debug("Deleting replica {}  for shard {} based on count {}", new Object[]{replica, shardId, count});
                this.deleteCore(shardSlice, collectionName, replica, message, shard, results, onComplete, parallel);
            }
            results.add("shard_id", shardId);
            results.add("replicas_deleted", replicas);
        }
    }

    private Set<String> pickReplicasTobeDeleted(Slice slice, String shard, String collectionName, int count) {
        this.validateReplicaAvailability(slice, shard, collectionName, count);
        Collection<Replica> allReplicas = slice.getReplicas();
        HashSet<String> replicasToBeRemoved = new HashSet<String>();
        Replica leader = slice.getLeader();
        for (Replica replica : allReplicas) {
            if (count == 0) break;
            if (leader.getCoreName().equals(replica.getCoreName())) continue;
            replicasToBeRemoved.add(replica.getName());
            --count;
        }
        return replicasToBeRemoved;
    }

    private void validateReplicaAvailability(Slice slice, String shard, String collectionName, int count) {
        if (slice != null) {
            Collection<Replica> allReplicasForShard = slice.getReplicas();
            if (allReplicasForShard == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No replicas found  in shard/collection: " + shard + "/" + collectionName);
            }
            if (allReplicasForShard.size() == 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There is only one replica available in shard/collection: " + shard + "/" + collectionName + ". Cannot delete that.");
            }
            if (allReplicasForShard.size() <= count) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There are lesser num replicas requested to be deleted than are available in shard/collection : " + shard + "/" + collectionName + " Requested: " + count + " Available: " + allReplicasForShard.size() + ".");
            }
        }
    }

    void deleteCore(Slice slice, String collectionName, String replicaName, ZkNodeProps message, String shard, NamedList results, Runnable onComplete, boolean parallel) throws KeeperException, InterruptedException {
        block9: {
            Replica replica = slice.getReplica(replicaName);
            if (replica == null) {
                ArrayList<String> l = new ArrayList<String>();
                for (Replica r : slice.getReplicas()) {
                    l.add(r.getName());
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid replica : " + replicaName + " in shard/collection : " + shard + "/" + collectionName + " available replicas are " + StrUtils.join(l, ','));
            }
            if (Boolean.parseBoolean(message.getStr("onlyIfDown")) && replica.getState() != Replica.State.DOWN) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Attempted to remove replica : " + collectionName + "/" + shard + "/" + replicaName + " with onlyIfDown='true', but state is '" + replica.getStr("state") + "'");
            }
            ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler(this.ocmh.overseer.getCoreContainer().getUpdateShardHandler().getDefaultHttpClient());
            String core = replica.getStr("core");
            String asyncId = message.getStr("async");
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("action", CoreAdminParams.CoreAdminAction.UNLOAD.toString());
            params.add("core", core);
            params.set("deleteIndex", message.getBool("deleteIndex", true));
            params.set("deleteInstanceDir", message.getBool("deleteInstanceDir", true));
            params.set("deleteDataDir", message.getBool("deleteDataDir", true));
            params.set("deleteMetricsHistory", message.getBool("deleteMetricsHistory", true));
            boolean isLive = this.ocmh.zkStateReader.getClusterState().getLiveNodes().contains(replica.getNodeName());
            OverseerCollectionMessageHandler.ShardRequestTracker shardRequestTracker = this.ocmh.asyncRequestTracker(asyncId);
            if (isLive) {
                shardRequestTracker.sendShardRequest(replica.getNodeName(), params, shardHandler);
            }
            Callable<Boolean> callable = () -> {
                try {
                    if (isLive) {
                        shardRequestTracker.processResponses(results, shardHandler, false, null);
                        if (this.ocmh.waitForCoreNodeGone(collectionName, shard, replicaName, 30000)) {
                            Boolean bl = Boolean.TRUE;
                            return bl;
                        }
                    }
                    this.ocmh.deleteCoreNode(collectionName, replicaName, replica, core);
                    if (this.ocmh.waitForCoreNodeGone(collectionName, shard, replicaName, 30000)) {
                        Boolean bl = Boolean.TRUE;
                        return bl;
                    }
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                catch (Exception e) {
                    results.add("failure", "Could not complete delete " + e.getMessage());
                    throw e;
                }
                finally {
                    if (onComplete != null) {
                        onComplete.run();
                    }
                }
            };
            if (!parallel) {
                try {
                    if (!callable.call().booleanValue()) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not remove replica : " + collectionName + "/" + shard + "/" + replicaName);
                    }
                    break block9;
                }
                catch (InterruptedException | KeeperException e) {
                    throw e;
                }
                catch (Exception ex) {
                    throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Error waiting for corenode gone", (Throwable)ex);
                }
            }
            this.ocmh.tpe.submit(callable);
        }
    }
}

