/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.util.stats.MetricUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerStatusCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public OverseerStatusCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        String leaderNode = OverseerTaskProcessor.getLeaderNode(zkStateReader.getZkClient());
        results.add("leader", leaderNode);
        Stat stat = new Stat();
        zkStateReader.getZkClient().getData("/overseer/queue", null, stat, true);
        results.add("overseer_queue_size", stat.getNumChildren());
        stat = new Stat();
        zkStateReader.getZkClient().getData("/overseer/queue-work", null, stat, true);
        results.add("overseer_work_queue_size", stat.getNumChildren());
        stat = new Stat();
        zkStateReader.getZkClient().getData("/overseer/collection-queue-work", null, stat, true);
        results.add("overseer_collection_queue_size", stat.getNumChildren());
        NamedList<SimpleOrderedMap<Object>> overseerStats = new NamedList<SimpleOrderedMap<Object>>();
        NamedList<SimpleOrderedMap<Object>> collectionStats = new NamedList<SimpleOrderedMap<Object>>();
        NamedList<SimpleOrderedMap<Object>> stateUpdateQueueStats = new NamedList<SimpleOrderedMap<Object>>();
        NamedList<SimpleOrderedMap<Object>> workQueueStats = new NamedList<SimpleOrderedMap<Object>>();
        NamedList<SimpleOrderedMap<Object>> collectionQueueStats = new NamedList<SimpleOrderedMap<Object>>();
        Stats stats = this.ocmh.stats;
        for (Map.Entry<String, Stats.Stat> entry : stats.getStats().entrySet()) {
            int errors;
            String key = entry.getKey();
            SimpleOrderedMap<Object> lst = new SimpleOrderedMap<Object>();
            if (key.startsWith("collection_")) {
                collectionStats.add(key.substring(11), lst);
                int successes = stats.getSuccessCount(entry.getKey());
                errors = stats.getErrorCount(entry.getKey());
                lst.add("requests", successes);
                lst.add("errors", errors);
                List<Stats.FailedOp> failureDetails = stats.getFailureDetails(key);
                if (failureDetails != null) {
                    ArrayList failures = new ArrayList();
                    for (Stats.FailedOp failedOp : failureDetails) {
                        SimpleOrderedMap<Object> fail = new SimpleOrderedMap<Object>();
                        fail.add("request", failedOp.req.getProperties());
                        fail.add("response", failedOp.resp.getResponse());
                        failures.add(fail);
                    }
                    lst.add("recent_failures", failures);
                }
            } else if (key.startsWith("/overseer/queue_")) {
                stateUpdateQueueStats.add(key.substring(16), lst);
            } else if (key.startsWith("/overseer/queue-work_")) {
                workQueueStats.add(key.substring(21), lst);
            } else if (key.startsWith("/overseer/collection-queue-work_")) {
                collectionQueueStats.add(key.substring(32), lst);
            } else {
                overseerStats.add(key, lst);
                int successes = stats.getSuccessCount(entry.getKey());
                errors = stats.getErrorCount(entry.getKey());
                lst.add("requests", successes);
                lst.add("errors", errors);
            }
            Timer timer = entry.getValue().requestTime;
            MetricUtils.addMetrics(lst, timer);
        }
        results.add("overseer_operations", overseerStats);
        results.add("collection_operations", collectionStats);
        results.add("overseer_queue", stateUpdateQueueStats);
        results.add("overseer_internal_queue", workQueueStats);
        results.add("collection_queue", collectionQueueStats);
    }
}

