/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventProcessorStage;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerListenerBase;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.util.PropertiesUtil;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTriggerListener
extends TriggerListenerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String urlTemplate;
    private String payloadTemplate;
    private String contentType;
    private Map<String, String> headerTemplates = new HashMap<String, String>();
    private int timeout = 60000;
    private boolean followRedirects;

    public HttpTriggerListener() {
        TriggerUtils.requiredProperties(this.requiredProperties, this.validProperties, "url");
        TriggerUtils.validProperties(this.validProperties, "payload", "contentType", "timeout", "followRedirects");
        this.validPropertyPrefixes.add("header.");
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, AutoScalingConfig.TriggerListenerConfig config) throws TriggerValidationException {
        super.configure(loader, cloudManager, config);
        this.urlTemplate = (String)config.properties.get("url");
        this.payloadTemplate = (String)config.properties.get("payload");
        this.contentType = (String)config.properties.get("contentType");
        config.properties.forEach((k, v) -> {
            if (k.startsWith("header.")) {
                this.headerTemplates.put(k.substring(7), String.valueOf(v));
            }
        });
        this.timeout = PropertiesUtil.toInteger(String.valueOf(config.properties.get("timeout")), 60000);
        this.followRedirects = PropertiesUtil.toBoolean(String.valueOf(config.properties.get("followRedirects")));
    }

    @Override
    public void onEvent(TriggerEvent event, TriggerEventProcessorStage stage, String actionName, ActionContext context, Throwable error, String message) {
        String type;
        String payload;
        Properties properties = new Properties();
        properties.setProperty("stage", stage.toString());
        if (actionName == null) {
            actionName = "";
        }
        properties.setProperty("actionName", actionName);
        if (context != null) {
            context.getProperties().forEach((k, v) -> properties.setProperty("context." + k, String.valueOf(v)));
        }
        if (error != null) {
            properties.setProperty("error", error.toString());
        } else {
            properties.setProperty("error", "");
        }
        if (message != null) {
            properties.setProperty("message", message);
        } else {
            properties.setProperty("message", "");
        }
        properties.setProperty("event.id", event.getId());
        properties.setProperty("event.source", event.getSource());
        properties.setProperty("event.eventTime", String.valueOf(event.eventTime));
        properties.setProperty("event.eventType", event.getEventType().toString());
        event.getProperties().forEach((k, v) -> properties.setProperty("event.properties." + k, String.valueOf(v)));
        properties.setProperty("config.name", this.config.name);
        properties.setProperty("config.trigger", this.config.trigger);
        properties.setProperty("config.listenerClass", this.config.listenerClass);
        properties.setProperty("config.beforeActions", String.join((CharSequence)",", this.config.beforeActions));
        properties.setProperty("config.afterActions", String.join((CharSequence)",", this.config.afterActions));
        StringJoiner joiner = new StringJoiner(",");
        this.config.stages.forEach(s -> joiner.add(s.toString()));
        properties.setProperty("config.stages", joiner.toString());
        this.config.properties.forEach((k, v) -> properties.setProperty("config.properties." + k, String.valueOf(v)));
        String url = PropertiesUtil.substituteProperty(this.urlTemplate, properties);
        if (this.payloadTemplate != null) {
            payload = PropertiesUtil.substituteProperty(this.payloadTemplate, properties);
            type = this.contentType != null ? this.contentType : "application/json";
        } else {
            payload = Utils.toJSONString(properties);
            type = "application/json";
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.headerTemplates.forEach((k, v) -> {
            String headerVal = PropertiesUtil.substituteProperty(v, properties);
            if (!headerVal.isEmpty()) {
                headers.put((String)k, headerVal);
            }
        });
        headers.put("Content-Type", type);
        try {
            this.cloudManager.httpRequest(url, SolrRequest.METHOD.POST, headers, payload, this.timeout, this.followRedirects);
        }
        catch (IOException e) {
            log.warn("Exception sending request for event {}", (Object)event, (Object)e);
        }
    }
}

