/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.TriggerActionBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InactiveShardPlanAction
extends TriggerActionBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String TTL_PROP = "ttl";
    public static final int DEFAULT_TTL_SECONDS = 172800;
    private int cleanupTTL;

    public InactiveShardPlanAction() {
        TriggerUtils.validProperties(this.validProperties, TTL_PROP);
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        super.configure(loader, cloudManager, properties);
        String cleanupStr = String.valueOf(properties.getOrDefault(TTL_PROP, String.valueOf(172800)));
        try {
            this.cleanupTTL = Integer.parseInt(cleanupStr);
        }
        catch (Exception e) {
            throw new TriggerValidationException(this.getName(), TTL_PROP, "invalid value '" + cleanupStr + "': " + e.toString());
        }
        if (this.cleanupTTL < 0) {
            throw new TriggerValidationException(this.getName(), TTL_PROP, "invalid value '" + cleanupStr + "', should be > 0. ");
        }
    }

    @Override
    public void process(TriggerEvent event, ActionContext context) throws Exception {
        SolrCloudManager cloudManager = context.getCloudManager();
        ClusterState state = cloudManager.getClusterStateProvider().getClusterState();
        LinkedHashMap cleanup = new LinkedHashMap();
        LinkedHashMap inactive = new LinkedHashMap();
        LinkedHashMap staleLocks = new LinkedHashMap();
        state.forEachCollection(coll -> coll.getSlices().forEach(s -> {
            if (Slice.State.INACTIVE.equals((Object)s.getState())) {
                inactive.computeIfAbsent(coll.getName(), c -> new ArrayList()).add(s.getName());
                String tstampStr = s.getStr("stateTimestamp");
                if (tstampStr == null || tstampStr.isEmpty()) {
                    return;
                }
                long timestamp = Long.parseLong(tstampStr);
                long currentTime = cloudManager.getTimeSource().getEpochTimeNs();
                long delta = TimeUnit.NANOSECONDS.toSeconds(currentTime - timestamp);
                if (log.isDebugEnabled()) {
                    log.debug("{}/{}: tstamp={}, time={}, delta={}", new Object[]{coll.getName(), s.getName(), timestamp, currentTime, delta});
                }
                if (delta > (long)this.cleanupTTL) {
                    if (log.isDebugEnabled()) {
                        log.debug("-- delete inactive {} / {}", (Object)coll.getName(), (Object)s.getName());
                    }
                    List operations = (List)context.getProperties().computeIfAbsent("operations", k -> new ArrayList());
                    operations.add(CollectionAdminRequest.deleteShard(coll.getName(), s.getName()));
                    cleanup.computeIfAbsent(coll.getName(), c -> new ArrayList()).add(s.getName());
                }
            }
            String parentPath = "/collections/" + coll.getName();
            try {
                List locks = cloudManager.getDistribStateManager().listData(parentPath).stream().filter(name -> name.endsWith("-splitting")).collect(Collectors.toList());
                for (String lock : locks) {
                    try {
                        String lockPath = parentPath + "/" + lock;
                        Map<String, Object> lockData = Utils.getJson(cloudManager.getDistribStateManager(), lockPath);
                        String tstampStr = (String)lockData.get("stateTimestamp");
                        if (tstampStr == null || tstampStr.isEmpty()) {
                            return;
                        }
                        long timestamp = Long.parseLong(tstampStr);
                        long currentTime = cloudManager.getTimeSource().getEpochTimeNs();
                        long delta = TimeUnit.NANOSECONDS.toSeconds(currentTime - timestamp);
                        if (log.isDebugEnabled()) {
                            log.debug("{}/{}: locktstamp={}, time={}, delta={}", new Object[]{coll.getName(), lock, timestamp, currentTime, delta});
                        }
                        if (delta > (long)this.cleanupTTL) {
                            if (log.isDebugEnabled()) {
                                log.debug("-- delete inactive split lock for {}/{}, delta={}", new Object[]{coll.getName(), lock, delta});
                            }
                            cloudManager.getDistribStateManager().removeData(lockPath, -1);
                            lockData.put("currentTimeNs", currentTime);
                            lockData.put("deltaSec", delta);
                            lockData.put("ttlSec", this.cleanupTTL);
                            staleLocks.put(coll.getName() + "/" + lock, lockData);
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("-- lock {}/{} still active (delta={})", new Object[]{coll.getName(), lock, delta});
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
            }
            catch (Exception e) {
                log.warn("Exception checking for inactive shard split locks in {}", (Object)parentPath, (Object)e);
            }
        }));
        LinkedHashMap results = new LinkedHashMap();
        if (!cleanup.isEmpty()) {
            results.put("inactive", inactive);
            results.put("cleanup", cleanup);
        }
        if (!staleLocks.isEmpty()) {
            results.put("staleLocks", staleLocks);
        }
        if (!results.isEmpty()) {
            context.getProperties().put(this.getName(), results);
        }
    }
}

