/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.util.Utils;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class SnapshotClusterStateProvider
implements ClusterStateProvider {
    final Set<String> liveNodes;
    final ClusterState clusterState;
    final Map<String, Object> clusterProperties;

    public SnapshotClusterStateProvider(ClusterStateProvider other) throws Exception {
        this.liveNodes = Collections.unmodifiableSet(new HashSet<String>(other.getLiveNodes()));
        ClusterState otherState = other.getClusterState();
        this.clusterState = new ClusterState(otherState.getZNodeVersion(), this.liveNodes, otherState.getCollectionsMap());
        this.clusterProperties = new HashMap<String, Object>(other.getClusterProperties());
    }

    public SnapshotClusterStateProvider(Map<String, Object> snapshot) {
        Objects.requireNonNull(snapshot);
        this.liveNodes = Collections.unmodifiableSet(new HashSet(snapshot.getOrDefault("liveNodes", Collections.emptySet())));
        this.clusterProperties = snapshot.getOrDefault("clusterProperties", Collections.emptyMap());
        HashMap<String, Object> stateMap = new HashMap<String, Object>(snapshot.getOrDefault("clusterState", Collections.emptyMap()));
        Number version = (Number)stateMap.remove("version");
        this.clusterState = ClusterState.load(version != null ? Integer.valueOf(version.intValue()) : null, stateMap, this.liveNodes, "/clusterstate.json");
    }

    public Map<String, Object> getSnapshot() {
        HashMap<String, Object> snapshot = new HashMap<String, Object>();
        snapshot.put("liveNodes", this.liveNodes);
        if (this.clusterProperties != null) {
            snapshot.put("clusterProperties", this.clusterProperties);
        }
        HashMap<String, Integer> stateMap = new HashMap<String, Integer>();
        snapshot.put("clusterState", stateMap);
        stateMap.put("version", this.clusterState.getZNodeVersion());
        this.clusterState.forEachCollection(coll -> {
            CharArr out = new CharArr();
            JSONWriter writer = new JSONWriter(out, 2);
            coll.write(writer);
            String json = out.toString();
            try {
                stateMap.put(coll.getName(), (Integer)Utils.fromJSON(json.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("should not happen!", e);
            }
        });
        return snapshot;
    }

    @Override
    public ClusterState.CollectionRef getState(String collection) {
        return this.clusterState.getCollectionRef(collection);
    }

    @Override
    public Set<String> getLiveNodes() {
        return this.liveNodes;
    }

    @Override
    public List<String> resolveAlias(String alias) {
        throw new UnsupportedOperationException("resolveAlias");
    }

    @Override
    public Map<String, String> getAliasProperties(String alias) {
        throw new UnsupportedOperationException("getAliasProperties");
    }

    @Override
    public ClusterState getClusterState() throws IOException {
        return this.clusterState;
    }

    @Override
    public Map<String, Object> getClusterProperties() {
        return this.clusterProperties;
    }

    @Override
    public String getPolicyNameByCollection(String coll) {
        DocCollection collection = this.clusterState.getCollectionOrNull(coll);
        return collection == null ? null : (String)collection.getProperties().get("policy");
    }

    @Override
    public void connect() {
    }

    @Override
    public void close() throws IOException {
    }
}

