/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetProperties {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_FILENAME = "configsetprops.json";
    public static final String IMMUTABLE_CONFIGSET_ARG = "immutable";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedList readFromResourceLoader(SolrResourceLoader loader, String name) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(loader.openResource(name), StandardCharsets.UTF_8);
        }
        catch (SolrResourceNotFoundException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Did not find ConfigSet properties, assuming default properties: ", (Throwable)ex);
            }
            return null;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to load reader for ConfigSet properties: " + name, (Throwable)ex);
        }
        try {
            NamedList namedList = ConfigSetProperties.readFromInputStream(reader);
            return namedList;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static NamedList readFromInputStream(InputStreamReader reader) {
        try {
            Object object = Utils.fromJSON(reader);
            if (!(object instanceof Map)) {
                String objectClass = object == null ? "null" : object.getClass().getName();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid JSON type " + objectClass + ", expected Map");
            }
            NamedList namedList = new NamedList((Map)object);
            return namedList;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to load ConfigSet properties", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }
}

