/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.lang.invoke.MethodHandles;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.CdcrStateManager;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class CdcrLeaderStateManager
extends CdcrStateManager {
    private boolean amILeader = false;
    private LeaderStateWatcher wrappedWatcher;
    private Watcher watcher;
    private SolrCore core;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    CdcrLeaderStateManager(SolrCore core) {
        this.core = core;
        try {
            SolrZkClient zkClient = core.getCoreContainer().getZkController().getZkClient();
            ClusterState clusterState = core.getCoreContainer().getZkController().getClusterState();
            this.watcher = this.initWatcher(zkClient);
            if (this.isLeaderRegistered(zkClient, clusterState)) {
                this.checkIfIAmLeader();
            }
        }
        catch (InterruptedException | KeeperException e) {
            log.warn("Failed fetching initial leader state and setting watch", e);
        }
    }

    private boolean isLeaderRegistered(SolrZkClient zkClient, ClusterState clusterState) throws KeeperException, InterruptedException {
        return zkClient.exists(this.getZnodePath(), this.watcher, true) != null;
    }

    private Watcher initWatcher(SolrZkClient zkClient) {
        this.wrappedWatcher = new LeaderStateWatcher();
        return zkClient.wrapWatcher(this.wrappedWatcher);
    }

    private void checkIfIAmLeader() throws KeeperException, InterruptedException {
        SolrZkClient zkClient = this.core.getCoreContainer().getZkController().getZkClient();
        ZkNodeProps props = ZkNodeProps.load(zkClient.getData(this.getZnodePath(), null, null, true));
        if (props != null) {
            this.setAmILeader(props.get("core").equals(this.core.getName()));
        }
    }

    private String getZnodePath() {
        String myShardId = this.core.getCoreDescriptor().getCloudDescriptor().getShardId();
        String myCollection = this.core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        return "/collections/" + myCollection + "/leaders/" + myShardId + "/leader";
    }

    void setAmILeader(boolean amILeader) {
        if (this.amILeader != amILeader) {
            this.amILeader = amILeader;
            this.callback();
        }
    }

    boolean amILeader() {
        return this.amILeader;
    }

    void shutdown() {
        if (this.wrappedWatcher != null) {
            this.wrappedWatcher.cancel();
        }
    }

    private class LeaderStateWatcher
    implements Watcher {
        private boolean isCancelled = false;

        private LeaderStateWatcher() {
        }

        void cancel() {
            this.isCancelled = true;
        }

        public void process(WatchedEvent event) {
            if (this.isCancelled) {
                return;
            }
            String collectionName = CdcrLeaderStateManager.this.core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
            String shard = CdcrLeaderStateManager.this.core.getCoreDescriptor().getCloudDescriptor().getShardId();
            log.debug("The leader state has changed: {} @ {}:{}", new Object[]{event, collectionName, shard});
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            try {
                log.info("Received new leader state @ {}:{}", (Object)collectionName, (Object)shard);
                SolrZkClient zkClient = CdcrLeaderStateManager.this.core.getCoreContainer().getZkController().getZkClient();
                ClusterState clusterState = CdcrLeaderStateManager.this.core.getCoreContainer().getZkController().getClusterState();
                if (CdcrLeaderStateManager.this.isLeaderRegistered(zkClient, clusterState)) {
                    CdcrLeaderStateManager.this.checkIfIAmLeader();
                }
            }
            catch (InterruptedException | KeeperException e) {
                log.warn("Failed updating leader state and setting watch @ {}: {}", new Object[]{collectionName, shard, e});
            }
        }
    }
}

