/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.Map;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class PluginInfoHandler
extends RequestHandlerBase {
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        boolean stats = params.getBool("stats", false);
        rsp.add("plugins", PluginInfoHandler.getSolrInfoBeans(req.getCore(), stats));
        rsp.setHttpCaching(false);
    }

    private static SimpleOrderedMap<Object> getSolrInfoBeans(SolrCore core, boolean stats) {
        SimpleOrderedMap<Object> list = new SimpleOrderedMap<Object>();
        for (SolrInfoBean.Category cat : SolrInfoBean.Category.values()) {
            SimpleOrderedMap category = new SimpleOrderedMap();
            list.add(cat.name(), category);
            Map<String, SolrInfoBean> reg = core.getInfoRegistry();
            for (Map.Entry<String, SolrInfoBean> entry : reg.entrySet()) {
                SolrInfoBean m = entry.getValue();
                if (m.getCategory() != cat) continue;
                String na = "Not Declared";
                SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
                category.add(entry.getKey(), info);
                info.add("name", m.getName() != null ? m.getName() : na);
                info.add("description", m.getDescription() != null ? m.getDescription() : na);
                if (!stats) continue;
                info.add("stats", m.getMetricsSnapshot());
            }
        }
        return list;
    }

    @Override
    public String getDescription() {
        return "Registry";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }
}

