/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.JsonTextWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.search.ReturnFields;

public class JSONWriter
extends TextResponseWriter
implements JsonTextWriter {
    static final int JSON_NL_STYLE_COUNT = 5;
    static final String JSON_WRAPPER_FUNCTION = "json.wrf";
    protected final String namedListStyle;
    protected String wrapperFunction;

    public JSONWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        this(writer, req, rsp, req.getParams().get(JSON_WRAPPER_FUNCTION), req.getParams().get("json.nl", "flat").intern());
    }

    public JSONWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp, String wrapperFunction, String namedListStyle) {
        super(writer, req, rsp);
        this.wrapperFunction = wrapperFunction;
        this.namedListStyle = namedListStyle;
    }

    private JSONWriter(Writer writer, boolean indent, String namedListStyle) throws IOException {
        super(writer, indent);
        this.namedListStyle = namedListStyle;
    }

    public static void write(Writer writer, boolean indent, String namedListStyle, Object val) throws IOException {
        JSONWriter jw = new JSONWriter(writer, indent, namedListStyle);
        jw.writeVal(null, val);
        jw.close();
    }

    @Override
    public String getNamedListStyle() {
        return this.namedListStyle;
    }

    public void writeResponse() throws IOException {
        if (this.wrapperFunction != null) {
            this._writeStr(this.wrapperFunction + "(");
        }
        this.writeNamedList(null, this.rsp.getValues());
        if (this.wrapperFunction != null) {
            this._writeChar(')');
        }
        this._writeChar('\n');
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
        if (idx > 0) {
            this.writeArraySeparator();
        }
        this.indent();
        this.writeMapOpener(doc.size());
        this.incLevel();
        boolean first = true;
        for (String fname : doc.getFieldNames()) {
            if (returnFields != null && !returnFields.wantsField(fname)) continue;
            if (first) {
                first = false;
            } else {
                this.writeMapSeparator();
            }
            this.indent();
            this.writeKey(fname, true);
            Object val = doc.getFieldValue(fname);
            this.writeVal(fname, val);
        }
        if (doc.hasChildDocuments()) {
            if (!first) {
                this.writeMapSeparator();
                this.indent();
            }
            this.writeKey("_childDocuments_", true);
            this.writeArrayOpener(doc.getChildDocumentCount());
            List<SolrDocument> childDocs = doc.getChildDocuments();
            for (int i = 0; i < childDocs.size(); ++i) {
                this.writeSolrDocument(null, childDocs.get(i), null, i);
            }
            this.writeArrayCloser();
        }
        this.decLevel();
        this.writeMapCloser();
    }

    @Override
    @Deprecated
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore) throws IOException {
        this.writeMapOpener(this.headerSize(maxScore, null));
        this.incLevel();
        this.writeKey("numFound", false);
        this.writeLong(null, numFound);
        this.writeMapSeparator();
        this.writeKey("start", false);
        this.writeLong(null, start);
        if (maxScore != null) {
            this.writeMapSeparator();
            this.writeKey("maxScore", false);
            this.writeFloat(null, maxScore.floatValue());
        }
        this.writeMapSeparator();
        this.writeKey("docs", false);
        this.writeArrayOpener(size);
        this.incLevel();
    }

    @Override
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore, Boolean numFoundExact) throws IOException {
        this.writeMapOpener(this.headerSize(maxScore, numFoundExact));
        this.incLevel();
        this.writeKey("numFound", false);
        this.writeLong(null, numFound);
        this.writeMapSeparator();
        this.writeKey("start", false);
        this.writeLong(null, start);
        if (maxScore != null) {
            this.writeMapSeparator();
            this.writeKey("maxScore", false);
            this.writeFloat(null, maxScore.floatValue());
        }
        if (numFoundExact != null) {
            this.writeMapSeparator();
            this.writeKey("numFoundExact", false);
            this.writeBool((String)null, numFoundExact);
        }
        this.writeMapSeparator();
        this.writeKey("docs", false);
        this.writeArrayOpener(size);
        this.incLevel();
    }

    protected int headerSize(Float maxScore, Boolean numFoundExact) {
        int headerSize = 3;
        if (maxScore != null) {
            ++headerSize;
        }
        if (numFoundExact != null) {
            ++headerSize;
        }
        return headerSize;
    }

    @Override
    public void writeEndDocumentList() throws IOException {
        this.decLevel();
        this.writeArrayCloser();
        this.decLevel();
        this.indent();
        this.writeMapCloser();
    }

    @Override
    public void _writeChar(char c) throws IOException {
        this.writer.write(c);
    }

    @Override
    public void _writeStr(String s) throws IOException {
        this.writer.write(s);
    }
}

