/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.FunctionScoreQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class BoostQParserPlugin
extends QParserPlugin {
    public static final String NAME = "boost";
    public static String BOOSTFUNC = "b";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){
            QParser baseParser;
            ValueSource vs;
            String b;

            @Override
            public Query parse() throws SyntaxError {
                this.b = this.localParams.get(BOOSTFUNC);
                this.baseParser = this.subQuery(this.localParams.get("v"), null);
                Query q = this.baseParser.getQuery();
                if (this.b == null) {
                    return q;
                }
                Query bq = this.subQuery(this.b, "func").getQuery();
                this.vs = bq instanceof FunctionQuery ? ((FunctionQuery)bq).getValueSource() : new QueryValueSource(bq, 0.0f);
                return FunctionScoreQuery.boostByValue((Query)q, (DoubleValuesSource)this.vs.asDoubleValuesSource());
            }

            @Override
            public String[] getDefaultHighlightFields() {
                return this.baseParser.getDefaultHighlightFields();
            }

            @Override
            public Query getHighlightQuery() throws SyntaxError {
                return this.baseParser.getHighlightQuery();
            }

            @Override
            public void addDebugInfo(NamedList<Object> debugInfo) {
                this.baseParser.addDebugInfo(debugInfo);
                debugInfo.add("boost_str", this.b);
                debugInfo.add("boost_parsed", this.vs);
            }
        };
    }
}

