/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessor;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetModule;
import org.apache.solr.search.facet.FacetQuery;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.ReadOnlyCountSlotAcc;
import org.apache.solr.search.facet.SlotAcc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatednessAgg
extends AggValueSource {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String RELATEDNESS = "relatedness";
    private static final String FG_POP = "foreground_popularity";
    private static final String BG_POP = "background_popularity";
    public static final String SWEEP_COLLECTION = "sweep_collection";
    private static final String FG_SIZE = "foreground_size";
    private static final String FG_COUNT = "foreground_count";
    private static final String BG_SIZE = "background_size";
    private static final String BG_COUNT = "background_count";
    protected final Query fgQ;
    protected final Query bgQ;
    protected double min_pop = 0.0;
    private Boolean useSweep;
    public static final String NAME = "relatedness";
    private static final boolean DEFAULT_SWEEP_COLLECTION = true;
    private static final String IMPLIED_KEY = "implied";

    public RelatednessAgg(Query fgQ, Query bgQ) {
        super("relatedness");
        this.fgQ = fgQ;
        this.bgQ = bgQ;
        if (null == fgQ || null == bgQ) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "relatedness aggregate function requires both foreground & background to be real (non-null) queries");
        }
    }

    public void setOpts(QParser parser) {
        boolean isShard = parser.getReq().getParams().getBool("isShard", false);
        SolrParams opts = parser.getLocalParams();
        if (null == opts) {
            this.useSweep = true;
        } else {
            this.useSweep = opts.getBool(SWEEP_COLLECTION, true);
            if (!isShard) {
                this.min_pop = opts.getDouble("min_popularity", 0.0);
            }
        }
    }

    public String description() {
        return this.name + "(fgQ=" + this.fgQ + ",bgQ=" + this.bgQ + ",min_pop=" + this.min_pop + ",useSweep=" + this.useSweep + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (!Objects.equals(((Object)((Object)this)).getClass(), o.getClass())) {
            return false;
        }
        RelatednessAgg that = (RelatednessAgg)((Object)o);
        return Objects.equals(this.fgQ, that.fgQ) && Objects.equals(this.bgQ, that.bgQ) && this.min_pop == that.min_pop;
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.fgQ, this.bgQ, this.min_pop);
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        throw new UnsupportedOperationException("NOT IMPLEMENTED " + this.name + " " + (Object)((Object)this));
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        ArrayList<Query> fgFilters = new ArrayList<Query>(3);
        fgFilters.add(this.fgQ);
        FacetContext ctx = fcontext;
        while (ctx != null) {
            if (null == ctx.filter) {
                assert (null == ctx.parent && fcontext == ctx || null == ctx.parent.parent && null == ctx.parent.filter);
                break;
            }
            fgFilters.add(ctx.filter);
            ctx = ctx.parent;
        }
        DocSet fgSet = fcontext.searcher.getDocSet(fgFilters);
        DocSet bgSet = fcontext.searcher.getDocSet(this.bgQ);
        return new SKGSlotAcc(this, fcontext, numSlots, fgSet, bgSet);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger(this);
    }

    public static double computeRelatedness(long fg_count, long fg_size, long bg_count, long bg_size) {
        double fg_size_d = fg_size;
        double bg_size_d = bg_size;
        double bg_prob = (double)bg_count / bg_size_d;
        double num = (double)fg_count - fg_size_d * bg_prob;
        double denom = Math.sqrt(fg_size_d * bg_prob * (1.0 - bg_prob));
        denom = denom == 0.0 ? 1.0E-10 : denom;
        double z = num / denom;
        double result = 0.2 * RelatednessAgg.sigmoidHelper(z, -80.0, 50.0) + 0.2 * RelatednessAgg.sigmoidHelper(z, -30.0, 30.0) + 0.2 * RelatednessAgg.sigmoidHelper(z, 0.0, 30.0) + 0.2 * RelatednessAgg.sigmoidHelper(z, 30.0, 30.0) + 0.2 * RelatednessAgg.sigmoidHelper(z, 80.0, 50.0);
        return RelatednessAgg.roundTo5Digits(result);
    }

    public static double roundTo5Digits(double val) {
        return (double)Math.round(val * 100000.0) / 100000.0;
    }

    private static double sigmoidHelper(double x, double offset, double scale) {
        return (x + offset) / (scale + Math.abs(x + offset));
    }

    private static final class Merger
    extends FacetModule.FacetSortableMerger {
        private final BucketData mergedData;

        public Merger(RelatednessAgg agg) {
            this.mergedData = new BucketData(agg);
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            NamedList shardData = (NamedList)facetResult;
            boolean shardImplied = Optional.ofNullable((Boolean)shardData.remove(RelatednessAgg.IMPLIED_KEY)).orElse(false);
            this.mergedData.incSizes((Long)shardData.remove(RelatednessAgg.FG_SIZE), (Long)shardData.remove(RelatednessAgg.BG_SIZE));
            if (!shardImplied) {
                this.mergedData.incCounts((Long)shardData.remove(RelatednessAgg.FG_COUNT), (Long)shardData.remove(RelatednessAgg.BG_COUNT));
            } else {
                assert (shardImplied);
                assert (null == shardData.remove(RelatednessAgg.FG_COUNT));
                assert (null == shardData.remove(RelatednessAgg.BG_COUNT));
            }
        }

        @Override
        public int compareTo(FacetModule.FacetSortableMerger other, FacetRequest.SortDirection direction) {
            assert (other instanceof Merger);
            Merger that = (Merger)other;
            return this.mergedData.compareTo(that.mergedData);
        }

        @Override
        public Object getMergedResult() {
            return this.mergedData.externalize(false);
        }
    }

    private static class BucketData
    implements Comparable<BucketData> {
        private RelatednessAgg agg;
        private long fg_size = 0L;
        private long bg_size = 0L;
        private long fg_count = 0L;
        private long bg_count = 0L;
        private boolean implied;
        private double relatedness = Double.NaN;
        private double fg_pop;
        private double bg_pop;

        public BucketData(RelatednessAgg agg) {
            this.agg = agg;
            this.implied = true;
        }

        public BucketData(long fg_count, long fg_size, long bg_count, long bg_size, double relatedness) {
            this.fg_count = fg_count;
            this.fg_size = fg_size;
            this.fg_pop = RelatednessAgg.roundTo5Digits((double)fg_count / (double)bg_size);
            this.bg_count = bg_count;
            this.bg_size = bg_size;
            this.bg_pop = RelatednessAgg.roundTo5Digits((double)bg_count / (double)bg_size);
            this.relatedness = relatedness;
        }

        public void incCounts(long fgInc, long bgInc) {
            this.implied = false;
            this.relatedness = Double.NaN;
            this.fg_count += fgInc;
            this.bg_count += bgInc;
        }

        public void incSizes(long fgInc, long bgInc) {
            this.relatedness = Double.NaN;
            this.fg_size += fgInc;
            this.bg_size += bgInc;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getClass(), this.implied, this.fg_count, this.bg_count, this.fg_size, this.bg_size, this.agg});
        }

        public boolean equals(Object other) {
            if (!Objects.equals(this.getClass(), other.getClass())) {
                return false;
            }
            BucketData that = (BucketData)other;
            return this.implied == that.implied && this.fg_count == that.fg_count && this.bg_count == that.bg_count && this.fg_size == that.fg_size && this.bg_size == that.bg_size && Objects.equals((Object)this.agg, (Object)that.agg);
        }

        private void computeDerivedValues() {
            if (!Double.isNaN(this.relatedness)) {
                return;
            }
            this.fg_pop = RelatednessAgg.roundTo5Digits((double)this.fg_count / (double)this.bg_size);
            this.bg_pop = RelatednessAgg.roundTo5Digits((double)this.bg_count / (double)this.bg_size);
            if (0.0 < this.agg.min_pop && (this.fg_pop < this.agg.min_pop || this.bg_pop < this.agg.min_pop)) {
                this.relatedness = Double.NEGATIVE_INFINITY;
                return;
            }
            this.relatedness = RelatednessAgg.computeRelatedness(this.fg_count, this.fg_size, this.bg_count, this.bg_size);
        }

        private double getRelatedness() {
            this.computeDerivedValues();
            return this.relatedness;
        }

        private double getForegroundPopularity() {
            this.computeDerivedValues();
            return this.fg_pop;
        }

        private double getBackgroundPopularity() {
            this.computeDerivedValues();
            return this.bg_pop;
        }

        @Override
        public int compareTo(BucketData that) {
            int r = Double.compare(this.getRelatedness(), that.getRelatedness());
            if (0 == r) {
                r = Long.compare(this.fg_count, that.fg_count);
            }
            if (0 == r) {
                r = Long.compare(this.bg_count, that.bg_count);
            }
            return r;
        }

        public SimpleOrderedMap externalize(boolean isShardRequest) {
            SimpleOrderedMap<Constable> result = new SimpleOrderedMap<Constable>();
            assert (0L == this.fg_count || !this.implied) : "Implied bucket has non-zero fg_count";
            assert (0L == this.bg_count || !this.implied) : "Implied bucket has non-zero bg_count";
            if (isShardRequest) {
                result.add(RelatednessAgg.FG_SIZE, Long.valueOf(this.fg_size));
                result.add(RelatednessAgg.BG_SIZE, Long.valueOf(this.bg_size));
                if (this.implied) {
                    result.add(RelatednessAgg.IMPLIED_KEY, Boolean.TRUE);
                } else {
                    result.add(RelatednessAgg.FG_COUNT, Long.valueOf(this.fg_count));
                    result.add(RelatednessAgg.BG_COUNT, Long.valueOf(this.bg_count));
                }
            } else {
                if (this.implied) {
                    return null;
                }
                result.add("relatedness", Double.valueOf(this.getRelatedness()));
                result.add(RelatednessAgg.FG_POP, Double.valueOf(this.getForegroundPopularity()));
                result.add(RelatednessAgg.BG_POP, Double.valueOf(this.getBackgroundPopularity()));
            }
            return result;
        }
    }

    private static final class SKGSlotAcc
    extends SlotAcc
    implements SlotAcc.SweepableSlotAcc<SlotAcc> {
        private final RelatednessAgg agg;
        private BucketData[] slotvalues;
        private final DocSet fgSet;
        private final DocSet bgSet;
        private final long fgSize;
        private final long bgSize;

        public SKGSlotAcc(RelatednessAgg agg, FacetContext fcontext, int numSlots, DocSet fgSet, DocSet bgSet) throws IOException {
            super(fcontext);
            this.agg = agg;
            this.fgSet = fgSet;
            this.bgSet = bgSet;
            this.fgSize = fgSet.size();
            this.bgSize = bgSet.size();
            this.slotvalues = new BucketData[numSlots];
            this.reset();
        }

        @Override
        public SKGSlotAcc registerSweepingAccs(SlotAcc.SweepingCountSlotAcc baseSweepingAcc) {
            if (!this.agg.useSweep.booleanValue()) {
                return this;
            }
            ReadOnlyCountSlotAcc fgCount = baseSweepingAcc.add(this.key + "!fg", this.fgSet, this.slotvalues.length);
            ReadOnlyCountSlotAcc bgCount = baseSweepingAcc.add(this.key + "!bg", this.bgSet, this.slotvalues.length);
            SweepSKGSlotAcc readOnlyReplacement = new SweepSKGSlotAcc(this.agg.min_pop, this.fcontext, this.slotvalues.length, this.fgSize, this.bgSize, fgCount, bgCount);
            readOnlyReplacement.key = this.key;
            baseSweepingAcc.registerMapping(this, readOnlyReplacement);
            return null;
        }

        private void processSlot(int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            BucketData slotVal;
            assert (null != slotContext);
            this.slotvalues[slot] = slotVal = new BucketData(this.agg);
            SlotAcc.SlotContext ctx = slotContext.apply(slot);
            if (ctx.isAllBuckets()) {
                return;
            }
            Query slotQ = ctx.getSlotQuery();
            if (null == slotQ) {
                assert (this.fcontext.processor.freq instanceof FacetQuery) : this.fcontext.processor.freq;
                assert (null == this.fcontext.parent);
                assert (null == this.fcontext.filter);
            }
            DocSet slotSet = null == slotQ ? this.fcontext.base : this.fcontext.searcher.getDocSet(slotQ);
            slotVal.incSizes(this.fgSize, this.bgSize);
            slotVal.incCounts(this.fgSet.intersectionSize(slotSet), this.bgSet.intersectionSize(slotSet));
        }

        @Override
        public void collect(int perSegDocId, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            if (null == this.slotvalues[slot]) {
                this.processSlot(slot, slotContext);
            }
        }

        @Override
        public int collect(DocSet docs, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            assert (null == this.slotvalues[slot]);
            this.processSlot(slot, slotContext);
            return docs.size();
        }

        @Override
        public int compare(int slotA, int slotB) {
            BucketData a = this.slotvalues[slotA];
            BucketData b = this.slotvalues[slotB];
            assert (null != a);
            assert (null != b);
            return a.compareTo(b);
        }

        @Override
        public Object getValue(int slotNum) {
            BucketData slotVal = this.slotvalues[slotNum];
            if (null == slotVal) {
                slotVal = new BucketData(this.agg);
                slotVal.incSizes(this.fgSize, this.bgSize);
            }
            SimpleOrderedMap res = slotVal.externalize(this.fcontext.isShard());
            return res;
        }

        @Override
        public void reset() {
            Arrays.fill(this.slotvalues, null);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.slotvalues = resizer.resize(this.slotvalues, null);
        }

        @Override
        public void close() throws IOException {
            this.slotvalues = null;
        }
    }

    private static final class SweepSKGSlotAcc
    extends SlotAcc {
        private final int minCount;
        private final long fgSize;
        private final long bgSize;
        private final ReadOnlyCountSlotAcc fgCount;
        private final ReadOnlyCountSlotAcc bgCount;
        private double[] relatedness;
        private static final int NO_ALL_BUCKETS = -2;
        private static final int ALL_BUCKETS_UNINITIALIZED = -1;
        private int allBucketsSlot;

        public SweepSKGSlotAcc(double minPopularity, FacetContext fcontext, int numSlots, long fgSize, long bgSize, ReadOnlyCountSlotAcc fgCount, ReadOnlyCountSlotAcc bgCount) {
            super(fcontext);
            this.minCount = (int)Math.ceil(minPopularity * (double)bgSize);
            this.fgSize = fgSize;
            this.bgSize = bgSize;
            this.fgCount = fgCount;
            this.bgCount = bgCount;
            this.relatedness = new double[numSlots];
            Arrays.fill(this.relatedness, 0, numSlots, Double.NaN);
            this.allBucketsSlot = -2;
            if (fcontext.processor instanceof FacetFieldProcessor && ((FacetField)((FacetFieldProcessor)fcontext.processor).freq).allBuckets) {
                this.allBucketsSlot = -1;
            }
        }

        @Override
        public void collect(int perSegDocId, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            throw new UnsupportedOperationException("collect() not supported, this SlotAcc impl only usable for sweeping");
        }

        @Override
        public int collect(DocSet docs, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            throw new UnsupportedOperationException("collect() not supported, this SlotAcc impl only usable for sweeping");
        }

        private double getRelatedness(int slot) {
            double cachedRelatedness = this.relatedness[slot];
            if (Double.isNaN(cachedRelatedness)) {
                long fg_count = this.fgCount.getCount(slot);
                long bg_count = this.bgCount.getCount(slot);
                if (this.minCount > 0 && (fg_count < (long)this.minCount || bg_count < (long)this.minCount)) {
                    this.relatedness[slot] = Double.NEGATIVE_INFINITY;
                    return Double.NEGATIVE_INFINITY;
                }
                this.relatedness[slot] = RelatednessAgg.computeRelatedness(fg_count, this.fgSize, bg_count, this.bgSize);
                return this.relatedness[slot];
            }
            return cachedRelatedness;
        }

        @Override
        public int compare(int slotA, int slotB) {
            int r = Double.compare(this.getRelatedness(slotA), this.getRelatedness(slotB));
            if (0 == r) {
                r = Long.compare(this.fgCount.getCount(slotA), this.fgCount.getCount(slotB));
            }
            if (0 == r) {
                r = Long.compare(this.bgCount.getCount(slotA), this.bgCount.getCount(slotB));
            }
            return r;
        }

        @Override
        public Object getValue(int slotNum) {
            if (-2 != this.allBucketsSlot && (-1 == this.allBucketsSlot || this.allBucketsSlot == slotNum)) {
                assert (this.fcontext.processor instanceof FacetFieldProcessor) : "code changed, non FacetFieldProcessor sweeping w/allBuckets?!?";
                this.allBucketsSlot = ((FacetFieldProcessor)this.fcontext.processor).allBucketsAcc.collectAccSlot;
            }
            BucketData slotVal = slotNum == this.allBucketsSlot ? new BucketData(null) : new BucketData(this.fgCount.getCount(slotNum), this.fgSize, this.bgCount.getCount(slotNum), this.bgSize, this.getRelatedness(slotNum));
            return slotVal.externalize(this.fcontext.isShard());
        }

        @Override
        public void reset() throws IOException {
            Arrays.fill(this.relatedness, Double.NaN);
            if (this.allBucketsSlot != -2) {
                this.allBucketsSlot = -1;
            }
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.relatedness = resizer.resize(this.relatedness, Double.NaN);
        }

        @Override
        public void close() throws IOException {
            this.relatedness = null;
        }
    }
}

