/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.shardresultserializer;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.command.QueryCommand;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.distributed.command.TopGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformer;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopGroupsResultTransformer
implements ShardResultTransformer<List<Command>, Map<String, ?>> {
    private final ResponseBuilder rb;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TopGroupsResultTransformer(ResponseBuilder rb) {
        this.rb = rb;
    }

    @Override
    public NamedList transform(List<Command> data) throws IOException {
        NamedList<NamedList> result = new NamedList<NamedList>();
        IndexSchema schema = this.rb.req.getSearcher().getSchema();
        for (Command command : data) {
            NamedList commandResult;
            if (TopGroupsFieldCommand.class.isInstance(command)) {
                TopGroupsFieldCommand fieldCommand = (TopGroupsFieldCommand)command;
                SchemaField groupField = schema.getField(fieldCommand.getKey());
                commandResult = this.serializeTopGroups(fieldCommand.result(), groupField);
            } else if (QueryCommand.class.isInstance(command)) {
                QueryCommand queryCommand = (QueryCommand)command;
                commandResult = this.serializeTopDocs(queryCommand.result());
            } else {
                commandResult = null;
            }
            result.add(command.getKey(), commandResult);
        }
        return result;
    }

    @Override
    public Map<String, ?> transformToNative(NamedList<NamedList> shardResponse, Sort groupSort, Sort withinGroupSort, String shard) {
        HashMap<String, QueryCommandResult> result = new HashMap<String, QueryCommandResult>();
        IndexSchema schema = this.rb.req.getSearcher().getSchema();
        for (Map.Entry<String, NamedList> entry : shardResponse) {
            String key = entry.getKey();
            NamedList commandResult = entry.getValue();
            Integer totalGroupedHitCount = (Integer)commandResult.get("totalGroupedHitCount");
            Number totalHits = (Number)commandResult.get("totalHits");
            if (totalHits != null) {
                Integer matches = (Integer)commandResult.get("matches");
                Float maxScore = (Float)commandResult.get("maxScore");
                if (maxScore == null) {
                    maxScore = Float.valueOf(Float.NaN);
                }
                List documents = (List)commandResult.get("documents");
                ScoreDoc[] scoreDocs = this.transformToNativeShardDoc(documents, groupSort, shard, schema);
                Object topDocs = withinGroupSort.equals((Object)Sort.RELEVANCE) ? new TopDocs(new TotalHits(totalHits.longValue(), TotalHits.Relation.EQUAL_TO), scoreDocs) : new TopFieldDocs(new TotalHits(totalHits.longValue(), TotalHits.Relation.EQUAL_TO), scoreDocs, withinGroupSort.getSort());
                result.put(key, new QueryCommandResult((TopDocs)topDocs, matches, maxScore.floatValue()));
                continue;
            }
            Integer totalHitCount = (Integer)commandResult.get("totalHitCount");
            ArrayList<GroupDocs> groupDocs = new ArrayList<GroupDocs>();
            for (int i = 2; i < commandResult.size(); ++i) {
                String groupValue = commandResult.getName(i);
                NamedList groupResult = (NamedList)commandResult.getVal(i);
                Number totalGroupHits = (Number)groupResult.get("totalHits");
                Float maxScore = (Float)groupResult.get("maxScore");
                if (maxScore == null) {
                    maxScore = Float.valueOf(Float.NaN);
                }
                List documents = (List)groupResult.get("documents");
                ScoreDoc[] scoreDocs = this.transformToNativeShardDoc(documents, withinGroupSort, shard, schema);
                BytesRef groupValueRef = groupValue != null ? new BytesRef((CharSequence)groupValue) : null;
                groupDocs.add(new GroupDocs(Float.NaN, maxScore.floatValue(), new TotalHits(totalGroupHits.longValue(), TotalHits.Relation.EQUAL_TO), scoreDocs, (Object)groupValueRef, null));
            }
            GroupDocs[] groupDocsArr = groupDocs.toArray(new GroupDocs[groupDocs.size()]);
            TopGroups topGroups = new TopGroups(groupSort.getSort(), withinGroupSort.getSort(), totalHitCount.intValue(), totalGroupedHitCount.intValue(), groupDocsArr, Float.NaN);
            result.put(key, (QueryCommandResult)topGroups);
        }
        return result;
    }

    protected ScoreDoc[] transformToNativeShardDoc(List<NamedList<Object>> documents, Sort groupSort, String shard, IndexSchema schema) {
        ScoreDoc[] scoreDocs = new ScoreDoc[documents.size()];
        int j = 0;
        for (NamedList<Object> document : documents) {
            Object docId = document.get("id");
            if (docId != null) {
                docId = docId.toString();
            } else {
                log.error("doc {} has null 'id'", document);
            }
            Float score = (Float)document.get("score");
            if (score == null) {
                score = Float.valueOf(Float.NaN);
            }
            Object[] sortValues = null;
            Object sortValuesVal = document.get("sortValues");
            if (sortValuesVal != null) {
                sortValues = ((List)sortValuesVal).toArray();
                for (int k = 0; k < sortValues.length; ++k) {
                    SchemaField field = groupSort.getSort()[k].getField() != null ? schema.getFieldOrNull(groupSort.getSort()[k].getField()) : null;
                    sortValues[k] = ShardResultTransformerUtils.unmarshalSortValue(sortValues[k], field);
                }
            } else {
                log.debug("doc {} has null 'sortValues'", document);
            }
            scoreDocs[j++] = new ShardDoc(score.floatValue(), sortValues, docId, shard);
        }
        return scoreDocs;
    }

    protected NamedList serializeTopGroups(TopGroups<BytesRef> data, SchemaField groupField) throws IOException {
        NamedList<Serializable> result = new NamedList<Serializable>();
        result.add("totalGroupedHitCount", Integer.valueOf(data.totalGroupedHitCount));
        result.add("totalHitCount", Integer.valueOf(data.totalHitCount));
        if (data.totalGroupCount != null) {
            result.add("totalGroupCount", data.totalGroupCount);
        }
        IndexSchema schema = this.rb.req.getSearcher().getSchema();
        SchemaField uniqueField = schema.getUniqueKeyField();
        for (GroupDocs searchGroup : data.groups) {
            NamedList<Serializable> groupResult = new NamedList<Serializable>();
            assert (searchGroup.totalHits.relation == TotalHits.Relation.EQUAL_TO);
            groupResult.add("totalHits", Long.valueOf(searchGroup.totalHits.value));
            if (!Float.isNaN(searchGroup.maxScore)) {
                groupResult.add("maxScore", Float.valueOf(searchGroup.maxScore));
            }
            ArrayList documents = new ArrayList();
            for (int i = 0; i < searchGroup.scoreDocs.length; ++i) {
                NamedList<Object> document = new NamedList<Object>();
                documents.add(document);
                Document doc = this.retrieveDocument(uniqueField, searchGroup.scoreDocs[i].doc);
                document.add("id", uniqueField.getType().toExternal(doc.getField(uniqueField.getName())));
                if (!Float.isNaN(searchGroup.scoreDocs[i].score)) {
                    document.add("score", Float.valueOf(searchGroup.scoreDocs[i].score));
                }
                if (!(searchGroup.scoreDocs[i] instanceof FieldDoc)) continue;
                FieldDoc fieldDoc = (FieldDoc)searchGroup.scoreDocs[i];
                Object[] convertedSortValues = new Object[fieldDoc.fields.length];
                for (int j = 0; j < fieldDoc.fields.length; ++j) {
                    SchemaField field;
                    Object sortValue = fieldDoc.fields[j];
                    Sort withinGroupSort = this.rb.getGroupingSpec().getWithinGroupSortSpec().getSort();
                    SchemaField schemaField = field = withinGroupSort.getSort()[j].getField() != null ? schema.getFieldOrNull(withinGroupSort.getSort()[j].getField()) : null;
                    if (field != null) {
                        FieldType fieldType = field.getType();
                        if (sortValue != null) {
                            sortValue = fieldType.marshalSortValue(sortValue);
                        }
                    }
                    convertedSortValues[j] = sortValue;
                }
                document.add("sortValues", convertedSortValues);
            }
            groupResult.add("documents", documents);
            String groupValue = searchGroup.groupValue != null ? groupField.getType().indexedToReadable((BytesRef)searchGroup.groupValue, new CharsRefBuilder()).toString() : null;
            result.add(groupValue, groupResult);
        }
        return result;
    }

    protected NamedList serializeTopDocs(QueryCommandResult result) throws IOException {
        NamedList<Serializable> queryResult = new NamedList<Serializable>();
        queryResult.add("matches", Integer.valueOf(result.getMatches()));
        TopDocs topDocs = result.getTopDocs();
        assert (topDocs.totalHits.relation == TotalHits.Relation.EQUAL_TO);
        queryResult.add("totalHits", Long.valueOf(topDocs.totalHits.value));
        if (!Float.isNaN(result.getMaxScore())) {
            queryResult.add("maxScore", Float.valueOf(result.getMaxScore()));
        }
        ArrayList documents = new ArrayList();
        queryResult.add("documents", documents);
        IndexSchema schema = this.rb.req.getSearcher().getSchema();
        SchemaField uniqueField = schema.getUniqueKeyField();
        for (ScoreDoc scoreDoc : result.getTopDocs().scoreDocs) {
            NamedList<Object> document = new NamedList<Object>();
            documents.add(document);
            Document doc = this.retrieveDocument(uniqueField, scoreDoc.doc);
            document.add("id", uniqueField.getType().toExternal(doc.getField(uniqueField.getName())));
            if (!Float.isNaN(scoreDoc.score)) {
                document.add("score", Float.valueOf(scoreDoc.score));
            }
            if (!FieldDoc.class.isInstance(scoreDoc)) continue;
            FieldDoc fieldDoc = (FieldDoc)scoreDoc;
            Object[] convertedSortValues = new Object[fieldDoc.fields.length];
            for (int j = 0; j < fieldDoc.fields.length; ++j) {
                Object sortValue = fieldDoc.fields[j];
                Sort groupSort = this.rb.getGroupingSpec().getGroupSortSpec().getSort();
                SchemaField field = groupSort.getSort()[j].getField() != null ? schema.getFieldOrNull(groupSort.getSort()[j].getField()) : null;
                convertedSortValues[j] = ShardResultTransformerUtils.marshalSortValue(sortValue, field);
            }
            document.add("sortValues", convertedSortValues);
        }
        return queryResult;
    }

    private Document retrieveDocument(SchemaField uniqueField, int doc) throws IOException {
        return this.rb.req.getSearcher().doc(doc, Collections.singleton(uniqueField.getName()));
    }
}

