/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.endresulttransformer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;

public class GroupedEndResultTransformer
implements EndResultTransformer {
    private final SolrIndexSearcher searcher;

    public GroupedEndResultTransformer(SolrIndexSearcher searcher) {
        this.searcher = searcher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void transform(Map<String, ?> result, ResponseBuilder rb, EndResultTransformer.SolrDocumentSource solrDocumentSource) {
        SimpleOrderedMap commands = new SimpleOrderedMap();
        SortSpec withinGroupSortSpec = rb.getGroupingSpec().getWithinGroupSortSpec();
        for (Map.Entry<String, ?> entry : result.entrySet()) {
            SimpleOrderedMap<Serializable> command;
            Object value = entry.getValue();
            if (TopGroups.class.isInstance(value)) {
                TopGroups topGroups = (TopGroups)value;
                command = new SimpleOrderedMap<Serializable>();
                command.add("matches", Integer.valueOf(rb.totalHitCount));
                Integer totalGroupCount = rb.mergedGroupCounts.get(entry.getKey());
                if (totalGroupCount != null) {
                    command.add("ngroups", totalGroupCount);
                }
                ArrayList groups = new ArrayList();
                SchemaField groupField = this.searcher.getSchema().getField(entry.getKey());
                FieldType groupFieldType = groupField.getType();
                for (GroupDocs group : topGroups.groups) {
                    SimpleOrderedMap<Object> groupResult = new SimpleOrderedMap<Object>();
                    if (group.groupValue != null) {
                        List<IndexableField> fields = groupField.createFields(((BytesRef)group.groupValue).utf8ToString());
                        if (!CollectionUtils.isNotEmpty(fields)) throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Couldn't create schema field for grouping, group value: " + ((BytesRef)group.groupValue).utf8ToString() + ", field: " + groupField);
                        groupResult.add("groupValue", groupFieldType.toObject(fields.get(0)));
                    } else {
                        groupResult.add("groupValue", null);
                    }
                    SolrDocumentList docList = new SolrDocumentList();
                    assert (group.totalHits.relation == TotalHits.Relation.EQUAL_TO);
                    docList.setNumFound(group.totalHits.value);
                    if (!Float.isNaN(group.maxScore)) {
                        docList.setMaxScore(Float.valueOf(group.maxScore));
                    }
                    docList.setStart(withinGroupSortSpec.getOffset());
                    GroupedEndResultTransformer.retrieveAndAdd(docList, solrDocumentSource, group.scoreDocs);
                    groupResult.add("doclist", docList);
                    groups.add(groupResult);
                }
                command.add("groups", groups);
                commands.add(entry.getKey(), command);
                continue;
            }
            if (!QueryCommandResult.class.isInstance(value)) continue;
            QueryCommandResult queryCommandResult = (QueryCommandResult)value;
            command = new SimpleOrderedMap();
            command.add("matches", Integer.valueOf(queryCommandResult.getMatches()));
            SolrDocumentList docList = new SolrDocumentList();
            TopDocs topDocs = queryCommandResult.getTopDocs();
            assert (topDocs.totalHits.relation == TotalHits.Relation.EQUAL_TO);
            docList.setNumFound(topDocs.totalHits.value);
            if (!Float.isNaN(queryCommandResult.getMaxScore())) {
                docList.setMaxScore(Float.valueOf(queryCommandResult.getMaxScore()));
            }
            docList.setStart(withinGroupSortSpec.getOffset());
            GroupedEndResultTransformer.retrieveAndAdd(docList, solrDocumentSource, queryCommandResult.getTopDocs().scoreDocs);
            command.add("doclist", docList);
            commands.add(entry.getKey(), command);
        }
        rb.rsp.add("grouped", commands);
    }

    private static void retrieveAndAdd(SolrDocumentList solrDocumentList, EndResultTransformer.SolrDocumentSource solrDocumentSource, ScoreDoc[] scoreDocs) {
        for (ScoreDoc scoreDoc : scoreDocs) {
            SolrDocument solrDocument = solrDocumentSource.retrieve(scoreDoc);
            if (solrDocument == null) continue;
            solrDocumentList.add(solrDocument);
        }
    }
}

