/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.HdfsTransactionLog;
import org.apache.solr.update.TransactionLog;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.util.HdfsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsUpdateLog
extends UpdateLog {
    private final Object fsLock = new Object();
    private FileSystem fs;
    private volatile Path tlogDir;
    private final String confDir;
    private Integer tlogDfsReplication;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean debug = log.isDebugEnabled();
    public static AtomicLong INIT_FAILED_LOGS_COUNT = new AtomicLong();

    public HdfsUpdateLog() {
        this(null);
    }

    public HdfsUpdateLog(String confDir) {
        this.confDir = confDir;
    }

    @Override
    public void init(PluginInfo info) {
        super.init(info);
        this.tlogDfsReplication = (Integer)info.initArgs.get("tlogDfsReplication");
        if (this.tlogDfsReplication == null) {
            this.tlogDfsReplication = 3;
        }
        log.info("Initializing HdfsUpdateLog: tlogDfsReplication={}", (Object)this.tlogDfsReplication);
    }

    private Configuration getConf(Path path) {
        String fsScheme;
        Configuration conf = new Configuration();
        if (this.confDir != null) {
            HdfsUtil.addHdfsResources(conf, this.confDir);
        }
        if ((fsScheme = path.toUri().getScheme()) != null) {
            conf.setBoolean("fs." + fsScheme + ".impl.disable.cache", true);
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(UpdateHandler uhandler, SolrCore core) {
        String ulogDir = core.getCoreDescriptor().getUlogDir();
        this.uhandler = uhandler;
        Object object = this.fsLock;
        synchronized (object) {
            if (this.fs == null) {
                if (ulogDir != null) {
                    this.dataDir = ulogDir;
                }
                if (this.dataDir == null || this.dataDir.length() == 0) {
                    this.dataDir = core.getDataDir();
                }
                if (!core.getDirectoryFactory().isAbsolute(this.dataDir)) {
                    try {
                        this.dataDir = core.getDirectoryFactory().getDataHome(core.getCoreDescriptor());
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                    }
                }
                try {
                    Path dataDirPath = new Path(this.dataDir);
                    this.fs = FileSystem.get((URI)dataDirPath.toUri(), (Configuration)this.getConf(dataDirPath));
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
            if (this.debug) {
                log.debug("UpdateHandler init: tlogDir={}, next id={}  this is a reopen or double init ... nothing else to do.", (Object)this.tlogDir, (Object)this.id);
            }
            this.versionInfo.reload();
            return;
        }
        this.tlogDir = new Path(this.dataDir, TLOG_NAME);
        while (true) {
            try {
                if (!this.fs.exists(this.tlogDir)) {
                    boolean success = this.fs.mkdirs(this.tlogDir);
                    if (success) break;
                    throw new RuntimeException("Could not create directory:" + this.tlogDir);
                }
                this.fs.mkdirs(this.tlogDir);
            }
            catch (RemoteException e) {
                if (e.getClassName().equals("org.apache.hadoop.hdfs.server.namenode.SafeModeException")) {
                    log.warn("The NameNode is in SafeMode - Solr will wait 5 seconds and try again.");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.interrupted();
                    }
                    continue;
                }
                throw new RuntimeException("Problem creating directory: " + this.tlogDir, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem creating directory: " + this.tlogDir, e);
            }
            break;
        }
        String[] oldBufferTlog = HdfsUpdateLog.getBufferLogList(this.fs, this.tlogDir);
        if (oldBufferTlog != null && oldBufferTlog.length != 0) {
            this.existOldBufferLog = true;
        }
        this.tlogFiles = HdfsUpdateLog.getLogList(this.fs, this.tlogDir);
        this.id = this.getLastLogId() + 1L;
        if (this.debug) {
            log.debug("UpdateHandler init: tlogDir={}, existing tlogs={}, next id={}", new Object[]{this.tlogDir, Arrays.asList(this.tlogFiles), this.id});
        }
        HdfsTransactionLog oldLog = null;
        for (String oldLogName : this.tlogFiles) {
            Path f = new Path(this.tlogDir, oldLogName);
            try {
                oldLog = new HdfsTransactionLog(this.fs, f, null, true, this.tlogDfsReplication);
                this.addOldLog(oldLog, false);
            }
            catch (Exception e) {
                INIT_FAILED_LOGS_COUNT.incrementAndGet();
                SolrException.log(log, "Failure to open existing log file (non fatal) " + f, e);
                try {
                    this.fs.delete(f, false);
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        for (TransactionLog ll : this.logs) {
            if (this.newestLogsOnStartup.size() < 2) {
                this.newestLogsOnStartup.addFirst(ll);
                continue;
            }
            log.info("Closing output for old non-recovery log {}", (Object)ll);
            ll.closeOutput();
        }
        try {
            this.versionInfo = new VersionInfo(this, this.numVersionBuckets);
        }
        catch (SolrException e) {
            log.error("Unable to use updateLog: ", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to use updateLog: " + e.getMessage(), (Throwable)e);
        }
        try (UpdateLog.RecentUpdates startingUpdates = this.getRecentUpdates();){
            int i;
            this.startingVersions = startingUpdates.getVersions(this.getNumRecordsToKeep());
            for (i = startingUpdates.deleteList.size() - 1; i >= 0; --i) {
                UpdateLog.DeleteUpdate du = startingUpdates.deleteList.get(i);
                this.oldDeletes.put(new BytesRef(du.id), new UpdateLog.LogPtr(-1L, du.version));
            }
            for (i = startingUpdates.deleteByQueryList.size() - 1; i >= 0; --i) {
                UpdateLog.Update update = startingUpdates.deleteByQueryList.get(i);
                List dbq = (List)update.log.lookup(update.pointer);
                long version = (Long)dbq.get(1);
                String q = (String)dbq.get(2);
                this.trackDeleteByQuery(q, version);
            }
        }
        core.getCoreMetricManager().registerMetricProducer(SolrInfoBean.Category.TLOG.toString(), this);
    }

    @Override
    public String getLogDir() {
        return this.tlogDir.toUri().toString();
    }

    public static String[] getBufferLogList(FileSystem fs, Path tlogDir) {
        FileStatus[] fileStatuses;
        String prefix = BUFFER_TLOG_NAME + '.';
        assert (fs != null);
        try {
            fileStatuses = fs.listStatus(tlogDir, path -> path.getName().startsWith(prefix));
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed on listing old buffer tlog", (Throwable)e);
        }
        String[] names = new String[fileStatuses.length];
        for (int i = 0; i < fileStatuses.length; ++i) {
            names[i] = fileStatuses[i].getPath().getName();
        }
        return names;
    }

    public static String[] getLogList(FileSystem fs, Path tlogDir) {
        FileStatus[] fileStatuses;
        final String prefix = TLOG_NAME + '.';
        assert (fs != null);
        try {
            fileStatuses = fs.listStatus(tlogDir, new PathFilter(){

                public boolean accept(Path path) {
                    return path.getName().startsWith(prefix);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object[] names = new String[fileStatuses.length];
        for (int i = 0; i < fileStatuses.length; ++i) {
            names[i] = fileStatuses[i].getPath().getName();
        }
        Arrays.sort(names);
        return names;
    }

    @Override
    public void close(boolean committed) {
        this.close(committed, false);
    }

    @Override
    public void close(boolean committed, boolean deleteOnClose) {
        try {
            super.close(committed, deleteOnClose);
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.fs);
        }
    }

    @Override
    protected void ensureBufferTlog() {
        if (this.bufferTlog != null) {
            return;
        }
        String newLogName = String.format(Locale.ROOT, LOG_FILENAME_PATTERN, BUFFER_TLOG_NAME, System.nanoTime());
        this.bufferTlog = new HdfsTransactionLog(this.fs, new Path(this.tlogDir, newLogName), this.globalStrings, this.tlogDfsReplication);
        this.bufferTlog.isBuffer = true;
    }

    @Override
    protected void deleteBufferLogs() {
        String[] oldBufferTlog = HdfsUpdateLog.getBufferLogList(this.fs, this.tlogDir);
        if (oldBufferTlog != null && oldBufferTlog.length != 0) {
            for (String oldBufferLogName : oldBufferTlog) {
                Path f = new Path(this.tlogDir, oldBufferLogName);
                try {
                    boolean s = this.fs.delete(f, false);
                    if (s) continue;
                    log.error("Could not remove old buffer tlog file:{}", (Object)f);
                }
                catch (IOException e) {
                    log.error("Could not remove old buffer tlog file:{}", (Object)f, (Object)e);
                }
            }
        }
    }

    @Override
    protected void ensureLog() {
        if (this.tlog == null) {
            String newLogName = String.format(Locale.ROOT, LOG_FILENAME_PATTERN, TLOG_NAME, this.id);
            HdfsTransactionLog ntlog = new HdfsTransactionLog(this.fs, new Path(this.tlogDir, newLogName), this.globalStrings, this.tlogDfsReplication);
            this.tlog = ntlog;
        }
    }

    @Override
    public void clearLog(SolrCore core, PluginInfo ulogPluginInfo) {
        if (ulogPluginInfo == null) {
            return;
        }
        Path tlogDir = new Path(this.getTlogDir(core, ulogPluginInfo));
        try {
            if (this.fs != null && this.fs.exists(tlogDir)) {
                String[] files;
                for (String file : files = this.getLogList(tlogDir)) {
                    Path f = new Path(tlogDir, file);
                    boolean s = this.fs.delete(f, false);
                    if (s) continue;
                    log.error("Could not remove tlog file:{}", (Object)f);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void preSoftCommit(CommitUpdateCommand cmd) {
        this.debug = log.isDebugEnabled();
        super.preSoftCommit(cmd);
    }

    public String[] getLogList(Path tlogDir) throws FileNotFoundException, IOException {
        final String prefix = TLOG_NAME + '.';
        FileStatus[] files = this.fs.listStatus(tlogDir, new PathFilter(){

            public boolean accept(Path name) {
                return name.getName().startsWith(prefix);
            }
        });
        ArrayList<String> fileList = new ArrayList<String>(files.length);
        for (FileStatus file : files) {
            fileList.add(file.getPath().getName());
        }
        return fileList.toArray(new String[0]);
    }

    @Override
    public String toString() {
        return "HDFSUpdateLog{state=" + (Object)((Object)this.getState()) + ", tlog=" + this.tlog + "}";
    }
}

