/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.Collection;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class NestedUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        boolean storeParent = NestedUpdateProcessorFactory.shouldStoreDocParent(req.getSchema());
        boolean storePath = NestedUpdateProcessorFactory.shouldStoreDocPath(req.getSchema());
        if (!storeParent && !storePath) {
            return next;
        }
        return new NestedUpdateProcessor(req, storeParent, storePath, next);
    }

    private static boolean shouldStoreDocParent(IndexSchema schema) {
        return schema.getFields().containsKey("_nest_parent_");
    }

    private static boolean shouldStoreDocPath(IndexSchema schema) {
        return schema.getFields().containsKey("_nest_path_");
    }

    private static class NestedUpdateProcessor
    extends UpdateRequestProcessor {
        private static final String PATH_SEP_CHAR = "/";
        private static final String NUM_SEP_CHAR = "#";
        private static final String SINGULAR_VALUE_CHAR = "";
        private boolean storePath;
        private boolean storeParent;
        private String uniqueKeyFieldName;

        NestedUpdateProcessor(SolrQueryRequest req, boolean storeParent, boolean storePath, UpdateRequestProcessor next) {
            super(next);
            this.storeParent = storeParent;
            this.storePath = storePath;
            this.uniqueKeyFieldName = req.getSchema().getUniqueKeyField().getName();
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            SolrInputDocument doc = cmd.getSolrInputDocument();
            this.processDocChildren(doc, null);
            super.processAdd(cmd);
        }

        private boolean processDocChildren(SolrInputDocument doc, String fullPath) {
            boolean isNested = false;
            for (SolrInputField field : doc.values()) {
                int childNum = 0;
                boolean isSingleVal = !(field.getValue() instanceof Collection);
                for (Object val : field) {
                    if (!(val instanceof SolrInputDocument)) break;
                    String fieldName = field.getName();
                    if (fieldName.contains(PATH_SEP_CHAR)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field name: '" + fieldName + "' contains: '" + PATH_SEP_CHAR + "' , which is reserved for the nested URP");
                    }
                    String sChildNum = isSingleVal ? SINGULAR_VALUE_CHAR : String.valueOf(childNum);
                    SolrInputDocument cDoc = (SolrInputDocument)val;
                    if (!cDoc.containsKey(this.uniqueKeyFieldName)) {
                        String parentDocId = doc.getField(this.uniqueKeyFieldName).getFirstValue().toString();
                        cDoc.setField(this.uniqueKeyFieldName, this.generateChildUniqueId(parentDocId, fieldName, sChildNum));
                    }
                    if (!isNested) {
                        isNested = true;
                    }
                    String lastKeyPath = PATH_SEP_CHAR + fieldName + NUM_SEP_CHAR + sChildNum;
                    String childDocPath = fullPath == null ? lastKeyPath : fullPath + lastKeyPath;
                    this.processChildDoc(cDoc, doc, childDocPath);
                    ++childNum;
                }
            }
            return isNested;
        }

        private void processChildDoc(SolrInputDocument sdoc, SolrInputDocument parent, String fullPath) {
            if (this.storePath) {
                this.setPathField(sdoc, fullPath);
            }
            if (this.storeParent) {
                this.setParentKey(sdoc, parent);
            }
            this.processDocChildren(sdoc, fullPath);
        }

        private String generateChildUniqueId(String parentId, String childKey, String childNum) {
            return parentId + PATH_SEP_CHAR + childKey + NUM_SEP_CHAR + childNum;
        }

        private void setParentKey(SolrInputDocument sdoc, SolrInputDocument parent) {
            sdoc.setField("_nest_parent_", parent.getFieldValue(this.uniqueKeyFieldName));
        }

        private void setPathField(SolrInputDocument sdoc, String fullPath) {
            sdoc.setField("_nest_path_", fullPath);
        }
    }
}

