/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.IgnoreRandomChains;

@IgnoreRandomChains(reason="LUCENE-10361: KoreanNumberFilter messes up offsets")
public class KoreanNumberFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttr = this.addAttribute(OffsetAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);
    private final PositionIncrementAttribute posIncrAttr = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAttr = this.addAttribute(PositionLengthAttribute.class);
    private static char NO_NUMERAL = (char)65535;
    private static char[] numerals = new char[65536];
    private static char[] exponents;
    private AttributeSource.State state;
    private StringBuilder numeral;
    private int fallThroughTokens;
    private boolean exhausted = false;

    public KoreanNumberFilter(TokenStream input) {
        super(input);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.state != null) {
            this.restoreState(this.state);
            this.state = null;
            return true;
        }
        if (this.exhausted) {
            return false;
        }
        if (!this.input.incrementToken()) {
            this.exhausted = true;
            return false;
        }
        if (this.keywordAttr.isKeyword()) {
            return true;
        }
        if (this.fallThroughTokens > 0) {
            --this.fallThroughTokens;
            return true;
        }
        if (this.posIncrAttr.getPositionIncrement() == 0) {
            this.fallThroughTokens = this.posLengthAttr.getPositionLength() - 1;
            return true;
        }
        boolean moreTokens = true;
        boolean composedNumberToken = false;
        int startOffset = 0;
        int endOffset = 0;
        AttributeSource.State preCompositionState = this.captureState();
        String term = this.termAttr.toString();
        boolean numeralTerm = this.isNumeral(term);
        while (moreTokens && numeralTerm) {
            if (!composedNumberToken) {
                startOffset = this.offsetAttr.startOffset();
                composedNumberToken = true;
            }
            endOffset = this.offsetAttr.endOffset();
            moreTokens = this.input.incrementToken();
            if (!moreTokens) {
                this.exhausted = true;
            }
            if (this.posIncrAttr.getPositionIncrement() == 0) {
                this.fallThroughTokens = this.posLengthAttr.getPositionLength() - 1;
                this.state = this.captureState();
                this.restoreState(preCompositionState);
                return moreTokens;
            }
            this.numeral.append(term);
            if (!moreTokens) continue;
            term = this.termAttr.toString();
            numeralTerm = this.isNumeral(term) || this.isNumeralPunctuation(term);
        }
        if (composedNumberToken) {
            if (moreTokens) {
                this.state = this.captureState();
            }
            String normalizedNumber = this.normalizeNumber(this.numeral.toString());
            this.termAttr.setEmpty();
            this.termAttr.append(normalizedNumber);
            this.offsetAttr.setOffset(startOffset, endOffset);
            this.numeral = new StringBuilder();
            return true;
        }
        return moreTokens;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.fallThroughTokens = 0;
        this.numeral = new StringBuilder();
        this.state = null;
        this.exhausted = false;
    }

    public String normalizeNumber(String number) {
        try {
            BigDecimal normalizedNumber = this.parseNumber(new NumberBuffer(number));
            if (normalizedNumber == null) {
                return number;
            }
            return normalizedNumber.stripTrailingZeros().toPlainString();
        }
        catch (ArithmeticException | NumberFormatException e) {
            return number;
        }
    }

    private BigDecimal parseNumber(NumberBuffer buffer) {
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal result = this.parseLargePair(buffer);
        if (result == null) {
            return null;
        }
        while (result != null) {
            sum = sum.add(result);
            result = this.parseLargePair(buffer);
        }
        return sum;
    }

    private BigDecimal parseLargePair(NumberBuffer buffer) {
        BigDecimal first = this.parseMediumNumber(buffer);
        BigDecimal second = this.parseLargeHangulNumeral(buffer);
        if (first == null && second == null) {
            return null;
        }
        if (second == null) {
            return first;
        }
        if (first == null) {
            return second;
        }
        return first.multiply(second);
    }

    private BigDecimal parseMediumNumber(NumberBuffer buffer) {
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal result = this.parseMediumPair(buffer);
        if (result == null) {
            return null;
        }
        while (result != null) {
            sum = sum.add(result);
            result = this.parseMediumPair(buffer);
        }
        return sum;
    }

    private BigDecimal parseMediumPair(NumberBuffer buffer) {
        BigDecimal first = this.parseBasicNumber(buffer);
        BigDecimal second = this.parseMediumHangulNumeral(buffer);
        if (first == null && second == null) {
            return null;
        }
        if (second == null) {
            return first;
        }
        if (first == null) {
            return second;
        }
        return first.multiply(second);
    }

    private BigDecimal parseBasicNumber(NumberBuffer buffer) {
        StringBuilder builder = new StringBuilder();
        for (int i = buffer.position(); i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (this.isArabicNumeral(c)) {
                builder.append(this.arabicNumeralValue(c));
            } else if (this.isHangulNumeral(c)) {
                builder.append(this.HangulNumeralValue(c));
            } else if (this.isDecimalPoint(c)) {
                builder.append(".");
            } else if (!this.isThousandSeparator(c)) break;
            buffer.advance();
        }
        if (builder.length() == 0) {
            return null;
        }
        return new BigDecimal(builder.toString());
    }

    public BigDecimal parseLargeHangulNumeral(NumberBuffer buffer) {
        int i = buffer.position();
        if (i >= buffer.length()) {
            return null;
        }
        char c = buffer.charAt(i);
        char power = exponents[c];
        if (power > '\u0003') {
            buffer.advance();
            return BigDecimal.TEN.pow(power);
        }
        return null;
    }

    public BigDecimal parseMediumHangulNumeral(NumberBuffer buffer) {
        int i = buffer.position();
        if (i >= buffer.length()) {
            return null;
        }
        char c = buffer.charAt(i);
        char power = exponents[c];
        if ('\u0001' <= power && power <= '\u0003') {
            buffer.advance();
            return BigDecimal.TEN.pow(power);
        }
        return null;
    }

    public boolean isNumeral(String input) {
        for (int i = 0; i < input.length(); ++i) {
            if (this.isNumeral(input.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isNumeral(char c) {
        return this.isArabicNumeral(c) || this.isHangulNumeral(c) || exponents[c] > '\u0000';
    }

    public boolean isNumeralPunctuation(String input) {
        for (int i = 0; i < input.length(); ++i) {
            if (this.isNumeralPunctuation(input.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isNumeralPunctuation(char c) {
        return this.isDecimalPoint(c) || this.isThousandSeparator(c);
    }

    public boolean isArabicNumeral(char c) {
        return this.isHalfWidthArabicNumeral(c) || this.isFullWidthArabicNumeral(c);
    }

    private boolean isHalfWidthArabicNumeral(char c) {
        return '0' <= c && c <= '9';
    }

    private boolean isFullWidthArabicNumeral(char c) {
        return '\uff10' <= c && c <= '\uff19';
    }

    private int arabicNumeralValue(char c) {
        int offset = this.isHalfWidthArabicNumeral(c) ? 48 : 65296;
        return c - offset;
    }

    private boolean isHangulNumeral(char c) {
        return numerals[c] != NO_NUMERAL;
    }

    private int HangulNumeralValue(char c) {
        return numerals[c];
    }

    private boolean isDecimalPoint(char c) {
        return c == '.' || c == '\uff0e';
    }

    private boolean isThousandSeparator(char c) {
        return c == ',' || c == '\uff0c';
    }

    static {
        Arrays.fill(numerals, NO_NUMERAL);
        KoreanNumberFilter.numerals[50689] = '\u0000';
        KoreanNumberFilter.numerals[51068] = '\u0001';
        KoreanNumberFilter.numerals[51060] = 2;
        KoreanNumberFilter.numerals[49340] = 3;
        KoreanNumberFilter.numerals[49324] = 4;
        KoreanNumberFilter.numerals[50724] = 5;
        KoreanNumberFilter.numerals[50977] = 6;
        KoreanNumberFilter.numerals[52832] = 7;
        KoreanNumberFilter.numerals[54036] = 8;
        KoreanNumberFilter.numerals[44396] = 9;
        exponents = new char[65536];
        Arrays.fill(exponents, '\u0000');
        KoreanNumberFilter.exponents[49901] = '\u0001';
        KoreanNumberFilter.exponents[48177] = 2;
        KoreanNumberFilter.exponents[52380] = 3;
        KoreanNumberFilter.exponents[47564] = 4;
        KoreanNumberFilter.exponents[50613] = 8;
        KoreanNumberFilter.exponents[51312] = 12;
        KoreanNumberFilter.exponents[44221] = 16;
        KoreanNumberFilter.exponents[54644] = 20;
    }

    public static class NumberBuffer {
        private int position;
        private String string;

        public NumberBuffer(String string) {
            this.string = string;
            this.position = 0;
        }

        public char charAt(int index) {
            return this.string.charAt(index);
        }

        public int length() {
            return this.string.length();
        }

        public void advance() {
            ++this.position;
        }

        public int position() {
            return this.position;
        }
    }
}

