/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.ko.dict.BinaryDictionary;
import org.apache.lucene.analysis.ko.dict.CharacterDefinition;
import org.apache.lucene.analysis.ko.dict.Dictionary;
import org.apache.lucene.util.IOUtils;

public final class UnknownDictionary
extends BinaryDictionary {
    private final CharacterDefinition characterDefinition = CharacterDefinition.getInstance();

    @Deprecated(forRemoval=true, since="9.1")
    public UnknownDictionary(BinaryDictionary.ResourceScheme scheme, String resourcePath) throws IOException {
        super(() -> BinaryDictionary.getResource(scheme, resourcePath + "$targetMap.dat"), () -> BinaryDictionary.getResource(scheme, resourcePath + "$posDict.dat"), () -> BinaryDictionary.getResource(scheme, resourcePath + "$buffer.dat"));
    }

    public UnknownDictionary(Path targetMapFile, Path posDictFile, Path dictFile) throws IOException {
        super(() -> Files.newInputStream(targetMapFile, new OpenOption[0]), () -> Files.newInputStream(posDictFile, new OpenOption[0]), () -> Files.newInputStream(dictFile, new OpenOption[0]));
    }

    public UnknownDictionary(URL targetMapUrl, URL posDictUrl, URL dictUrl) throws IOException {
        super(() -> targetMapUrl.openStream(), () -> posDictUrl.openStream(), () -> dictUrl.openStream());
    }

    private UnknownDictionary() throws IOException {
        super(() -> UnknownDictionary.getClassResource("$targetMap.dat"), () -> UnknownDictionary.getClassResource("$posDict.dat"), () -> UnknownDictionary.getClassResource("$buffer.dat"));
    }

    private static InputStream getClassResource(String suffix) throws IOException {
        String resourcePath = UnknownDictionary.class.getSimpleName() + suffix;
        return IOUtils.requireResourceNonNull(UnknownDictionary.class.getResourceAsStream(resourcePath), resourcePath);
    }

    public CharacterDefinition getCharacterDefinition() {
        return this.characterDefinition;
    }

    public static UnknownDictionary getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String getReading(int wordId) {
        return null;
    }

    @Override
    public Dictionary.Morpheme[] getMorphemes(int wordId, char[] surfaceForm, int off, int len) {
        return null;
    }

    private static class SingletonHolder {
        static final UnknownDictionary INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new UnknownDictionary();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load UnknownDictionary.", ioe);
            }
        }
    }
}

