/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.analysis.ko.dict.ConnectionCosts;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.OutputStreamDataOutput;

final class ConnectionCostsWriter {
    private final ByteBuffer costs;
    private final int forwardSize;
    private final int backwardSize;

    ConnectionCostsWriter(int forwardSize, int backwardSize) {
        this.forwardSize = forwardSize;
        this.backwardSize = backwardSize;
        this.costs = ByteBuffer.allocateDirect(2 * backwardSize * forwardSize);
    }

    public void add(int forwardId, int backwardId, int cost) {
        int offset = (backwardId * this.forwardSize + forwardId) * 2;
        this.costs.putShort(offset, (short)cost);
    }

    public void write(Path baseDir) throws IOException {
        Files.createDirectories(baseDir, new FileAttribute[0]);
        String fileName = ConnectionCosts.class.getName().replace('.', '/') + ".dat";
        try (OutputStream os = Files.newOutputStream(baseDir.resolve(fileName), new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput(bos);
            CodecUtil.writeHeader(out, "ko_cc", 1);
            out.writeVInt(this.forwardSize);
            out.writeVInt(this.backwardSize);
            short last = 0;
            for (int i = 0; i < this.costs.limit() / 2; ++i) {
                short cost = this.costs.getShort(i * 2);
                int delta = cost - last;
                out.writeZInt(delta);
                last = cost;
            }
        }
    }
}

