/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.memory.FSTTermOutputs;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.OffHeapFSTStore;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

public class FSTTermsReader
extends FieldsProducer {
    private final TreeMap<String, TermsReader> fields = new TreeMap();
    private final PostingsReaderBase postingsReader;
    private final IndexInput fstTermsInput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSTTermsReader(SegmentReadState state, PostingsReaderBase postingsReader) throws IOException {
        String termsFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "tfp");
        this.postingsReader = postingsReader;
        IndexInput in = this.fstTermsInput = state.directory.openInput(termsFileName, IOContext.LOAD);
        boolean success = false;
        try {
            CodecUtil.checkIndexHeader(in, "FSTTerms", 2, 2, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.checksumEntireFile(in);
            this.postingsReader.init(in, state);
            this.seekDir(in);
            FieldInfos fieldInfos = state.fieldInfos;
            int numFields = in.readVInt();
            for (int i = 0; i < numFields; ++i) {
                int fieldNumber = in.readVInt();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(fieldNumber);
                long numTerms = in.readVLong();
                long sumTotalTermFreq = in.readVLong();
                long sumDocFreq = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? sumTotalTermFreq : in.readVLong();
                int docCount = in.readVInt();
                TermsReader current = new TermsReader(fieldInfo, in, numTerms, sumTotalTermFreq, sumDocFreq, docCount);
                TermsReader previous = this.fields.put(fieldInfo.name, current);
                this.checkFieldSummary(state.segmentInfo, in, current, previous);
            }
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(in);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(in);
    }

    private void seekDir(IndexInput in) throws IOException {
        in.seek(in.length() - (long)CodecUtil.footerLength() - 8L);
        in.seek(in.readLong());
    }

    private void checkFieldSummary(SegmentInfo info, IndexInput in, TermsReader field, TermsReader previous) throws IOException {
        if (field.docCount < 0 || field.docCount > info.maxDoc()) {
            throw new CorruptIndexException("invalid docCount: " + field.docCount + " maxDoc: " + info.maxDoc(), in);
        }
        if (field.sumDocFreq < (long)field.docCount) {
            throw new CorruptIndexException("invalid sumDocFreq: " + field.sumDocFreq + " docCount: " + field.docCount, in);
        }
        if (field.sumTotalTermFreq < field.sumDocFreq) {
            throw new CorruptIndexException("invalid sumTotalTermFreq: " + field.sumTotalTermFreq + " sumDocFreq: " + field.sumDocFreq, in);
        }
        if (previous != null) {
            throw new CorruptIndexException("duplicate fields: " + field.fieldInfo.name, in);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    @Override
    public Terms terms(String field) throws IOException {
        assert (field != null);
        return this.fields.get(field);
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.postingsReader, this.fstTermsInput);
        }
        finally {
            this.fields.clear();
        }
    }

    static <T> void walk(FST<T> fst) throws IOException {
        ArrayList queue = new ArrayList();
        BitSet seen = new BitSet();
        FST.BytesReader reader = fst.getBytesReader();
        FST.Arc<T> startArc = fst.getFirstArc(new FST.Arc());
        queue.add(startArc);
        block0: while (!queue.isEmpty()) {
            FST.Arc arc = (FST.Arc)queue.remove(0);
            long node = arc.target();
            if (!FST.targetHasArcs(arc) || seen.get((int)node)) continue;
            seen.set((int)node);
            fst.readFirstRealTargetArc(node, arc, reader);
            while (true) {
                queue.add(new FST.Arc().copyFrom(arc));
                if (arc.isLast()) continue block0;
                fst.readNextRealArc(arc, reader);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fields.size() + ",delegate=" + this.postingsReader + ")";
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.postingsReader.checkIntegrity();
    }

    final class TermsReader
    extends Terms {
        final FieldInfo fieldInfo;
        final long numTerms;
        final long sumTotalTermFreq;
        final long sumDocFreq;
        final int docCount;
        final FST<FSTTermOutputs.TermData> dict;

        TermsReader(FieldInfo fieldInfo, IndexInput in, long numTerms, long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            this.fieldInfo = fieldInfo;
            this.numTerms = numTerms;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            OffHeapFSTStore offHeapFSTStore = new OffHeapFSTStore();
            FSTTermOutputs outputs = new FSTTermOutputs(fieldInfo);
            this.dict = new FST<FSTTermOutputs.TermData>(FST.readMetadata(in, outputs), in, offHeapFSTStore);
            in.skipBytes(offHeapFSTStore.size());
        }

        public String toString() {
            return "FSTTerms(terms=" + this.numTerms + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
        }

        @Override
        public boolean hasFreqs() {
            return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        @Override
        public boolean hasOffsets() {
            return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        @Override
        public boolean hasPositions() {
            return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        @Override
        public boolean hasPayloads() {
            return this.fieldInfo.hasPayloads();
        }

        @Override
        public long size() {
            return this.numTerms;
        }

        @Override
        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        @Override
        public int getDocCount() throws IOException {
            return this.docCount;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new SegmentTermsEnum();
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
                throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
            }
            return new IntersectTermsEnum(compiled, startTerm);
        }

        private final class IntersectTermsEnum
        extends BaseTermsEnum {
            BytesRefBuilder term;
            boolean decoded;
            boolean pending;
            Frame[] stack;
            int level;
            int metaUpto;
            final FST<FSTTermOutputs.TermData> fst;
            final FST.BytesReader fstReader;
            final Outputs<FSTTermOutputs.TermData> fstOutputs;
            final ByteRunAutomaton fsa;

            IntersectTermsEnum(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                this.fst = TermsReader.this.dict;
                this.fstReader = this.fst.getBytesReader();
                this.fstOutputs = TermsReader.this.dict.outputs;
                this.fsa = compiled.runAutomaton;
                this.level = -1;
                this.stack = new Frame[16];
                for (int i = 0; i < this.stack.length; ++i) {
                    this.stack[i] = new Frame();
                }
                this.loadVirtualFrame(this.newFrame());
                ++this.level;
                this.pushFrame(this.loadFirstFrame(this.newFrame()));
                this.meta = null;
                this.metaUpto = 1;
                this.decoded = false;
                this.pending = false;
                if (startTerm == null) {
                    this.pending = this.isAccept(this.topFrame());
                } else {
                    this.doSeekCeil(startTerm);
                    this.pending = (this.term == null || !startTerm.equals(this.term.get())) && this.isValid(this.topFrame()) && this.isAccept(this.topFrame());
                }
            }

            @Override
            public BytesRef term() throws IOException {
                return this.term == null ? null : this.term.get();
            }

            @Override
            void decodeMetaData() throws IOException {
                assert (this.term != null);
                if (!this.decoded) {
                    if (this.meta.bytes != null) {
                        this.bytesReader.reset(this.meta.bytes, 0, this.meta.bytes.length);
                    }
                    FSTTermsReader.this.postingsReader.decodeTerm(this.bytesReader, TermsReader.this.fieldInfo, this.state, true);
                    this.decoded = true;
                }
            }

            void loadMetaData() {
                Frame last = this.stack[this.metaUpto];
                while (this.metaUpto != this.level) {
                    ++this.metaUpto;
                    Frame next = this.stack[this.metaUpto];
                    next.output = this.fstOutputs.add(next.output, last.output);
                    last = next;
                }
                this.meta = last.fstArc.isFinal() ? this.fstOutputs.add(last.output, last.fstArc.nextFinalOutput()) : last.output;
                this.state.docFreq = this.meta.docFreq;
                this.state.totalTermFreq = this.meta.totalTermFreq;
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef target) throws IOException {
                this.decoded = false;
                this.doSeekCeil(target);
                this.loadMetaData();
                if (this.term == null) {
                    return TermsEnum.SeekStatus.END;
                }
                return this.term.get().equals(target) ? TermsEnum.SeekStatus.FOUND : TermsEnum.SeekStatus.NOT_FOUND;
            }

            @Override
            public BytesRef next() throws IOException {
                if (this.pending) {
                    this.pending = false;
                    this.loadMetaData();
                    return this.term();
                }
                this.decoded = false;
                block0: while (this.level > 0) {
                    Frame frame = this.newFrame();
                    if (this.loadExpandFrame(this.topFrame(), frame) != null) {
                        this.pushFrame(frame);
                        if (!this.isAccept(frame)) continue;
                        break;
                    }
                    frame = this.popFrame();
                    while (this.level > 0) {
                        if (this.loadNextFrame(this.topFrame(), frame) != null) {
                            this.pushFrame(frame);
                            if (!this.isAccept(frame)) continue block0;
                            break block0;
                        }
                        frame = this.popFrame();
                    }
                    return null;
                }
                this.loadMetaData();
                return this.term();
            }

            private BytesRef doSeekCeil(BytesRef target) throws IOException {
                int upto;
                Frame frame = null;
                int limit = target.length;
                for (upto = 0; upto < limit; ++upto) {
                    frame = this.newFrame();
                    int label = target.bytes[target.offset + upto] & 0xFF;
                    frame = this.loadCeilFrame(label, this.topFrame(), frame);
                    if (frame == null || frame.fstArc.label() != label) break;
                    assert (this.isValid(frame));
                    this.pushFrame(frame);
                }
                if (upto == limit) {
                    return this.term();
                }
                if (frame != null) {
                    this.pushFrame(frame);
                    return this.isAccept(frame) ? this.term() : this.next();
                }
                while (this.level > 0) {
                    frame = this.popFrame();
                    while (this.level > 0 && !this.canRewind(frame)) {
                        frame = this.popFrame();
                    }
                    if (this.loadNextFrame(this.topFrame(), frame) == null) continue;
                    this.pushFrame(frame);
                    return this.isAccept(frame) ? this.term() : this.next();
                }
                return null;
            }

            Frame loadVirtualFrame(Frame frame) {
                frame.output = this.fstOutputs.getNoOutput();
                frame.fsaState = -1;
                return frame;
            }

            Frame loadFirstFrame(Frame frame) throws IOException {
                frame.fstArc = this.fst.getFirstArc(frame.fstArc);
                frame.output = frame.fstArc.output();
                frame.fsaState = 0;
                return frame;
            }

            Frame loadExpandFrame(Frame top, Frame frame) throws IOException {
                if (!this.canGrow(top)) {
                    return null;
                }
                frame.fstArc = this.fst.readFirstRealTargetArc(top.fstArc.target(), frame.fstArc, this.fstReader);
                frame.fsaState = this.fsa.step(top.fsaState, frame.fstArc.label());
                if (frame.fsaState == -1) {
                    return this.loadNextFrame(top, frame);
                }
                frame.output = frame.fstArc.output();
                return frame;
            }

            Frame loadNextFrame(Frame top, Frame frame) throws IOException {
                if (!this.canRewind(frame)) {
                    return null;
                }
                while (!frame.fstArc.isLast()) {
                    frame.fstArc = this.fst.readNextRealArc(frame.fstArc, this.fstReader);
                    frame.fsaState = this.fsa.step(top.fsaState, frame.fstArc.label());
                    if (frame.fsaState == -1) continue;
                }
                if (frame.fsaState == -1) {
                    return null;
                }
                frame.output = frame.fstArc.output();
                return frame;
            }

            Frame loadCeilFrame(int label, Frame top, Frame frame) throws IOException {
                FST.Arc<FSTTermOutputs.TermData> arc = frame.fstArc;
                if ((arc = Util.readCeilArc(label, this.fst, top.fstArc, arc, this.fstReader)) == null) {
                    return null;
                }
                frame.fsaState = this.fsa.step(top.fsaState, arc.label());
                if (frame.fsaState == -1) {
                    return this.loadNextFrame(top, frame);
                }
                frame.output = frame.fstArc.output();
                return frame;
            }

            boolean isAccept(Frame frame) {
                return this.fsa.isAccept(frame.fsaState) && frame.fstArc.isFinal();
            }

            boolean isValid(Frame frame) {
                return frame.fsaState != -1;
            }

            boolean canGrow(Frame frame) {
                return frame.fsaState != -1 && FST.targetHasArcs(frame.fstArc);
            }

            boolean canRewind(Frame frame) {
                return !frame.fstArc.isLast();
            }

            void pushFrame(Frame frame) {
                this.term = this.grow(frame.fstArc.label());
                ++this.level;
            }

            Frame popFrame() {
                this.term = this.shrink();
                --this.level;
                this.metaUpto = this.metaUpto > this.level ? this.level : this.metaUpto;
                return this.stack[this.level + 1];
            }

            Frame newFrame() {
                if (this.level + 1 == this.stack.length) {
                    Frame[] temp = new Frame[ArrayUtil.oversize(this.level + 2, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                    System.arraycopy(this.stack, 0, temp, 0, this.stack.length);
                    for (int i = this.stack.length; i < temp.length; ++i) {
                        temp[i] = new Frame();
                    }
                    this.stack = temp;
                }
                return this.stack[this.level + 1];
            }

            Frame topFrame() {
                return this.stack[this.level];
            }

            BytesRefBuilder grow(int label) {
                if (this.term == null) {
                    this.term = new BytesRefBuilder();
                } else {
                    this.term.append((byte)label);
                }
                return this.term;
            }

            BytesRefBuilder shrink() {
                if (this.term.length() == 0) {
                    this.term = null;
                } else {
                    this.term.setLength(this.term.length() - 1);
                }
                return this.term;
            }

            private final class Frame {
                FST.Arc<FSTTermOutputs.TermData> fstArc = new FST.Arc();
                FSTTermOutputs.TermData output;
                int fsaState = -1;

                Frame() {
                }

                public String toString() {
                    return "arc=" + this.fstArc + " state=" + this.fsaState;
                }
            }
        }

        private final class SegmentTermsEnum
        extends BaseTermsEnum {
            BytesRef term;
            final BytesRefFSTEnum<FSTTermOutputs.TermData> fstEnum;
            boolean decoded;
            boolean seekPending;

            SegmentTermsEnum() throws IOException {
                this.fstEnum = new BytesRefFSTEnum<FSTTermOutputs.TermData>(TermsReader.this.dict);
                this.decoded = false;
                this.seekPending = false;
                this.meta = null;
            }

            @Override
            public BytesRef term() throws IOException {
                return this.term;
            }

            @Override
            void decodeMetaData() throws IOException {
                if (!this.decoded && !this.seekPending) {
                    if (this.meta.bytes != null) {
                        this.bytesReader.reset(this.meta.bytes, 0, this.meta.bytes.length);
                    }
                    FSTTermsReader.this.postingsReader.decodeTerm(this.bytesReader, TermsReader.this.fieldInfo, this.state, true);
                    this.decoded = true;
                }
            }

            void updateEnum(BytesRefFSTEnum.InputOutput<FSTTermOutputs.TermData> pair) {
                if (pair == null) {
                    this.term = null;
                } else {
                    this.term = pair.input;
                    this.meta = (FSTTermOutputs.TermData)pair.output;
                    this.state.docFreq = this.meta.docFreq;
                    this.state.totalTermFreq = this.meta.totalTermFreq;
                }
                this.decoded = false;
                this.seekPending = false;
            }

            @Override
            public BytesRef next() throws IOException {
                if (this.seekPending) {
                    this.seekPending = false;
                    TermsEnum.SeekStatus status = this.seekCeil(this.term);
                    assert (status == TermsEnum.SeekStatus.FOUND);
                }
                this.updateEnum(this.fstEnum.next());
                return this.term;
            }

            @Override
            public boolean seekExact(BytesRef target) throws IOException {
                this.updateEnum(this.fstEnum.seekExact(target));
                return this.term != null;
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef target) throws IOException {
                this.updateEnum(this.fstEnum.seekCeil(target));
                if (this.term == null) {
                    return TermsEnum.SeekStatus.END;
                }
                return this.term.equals(target) ? TermsEnum.SeekStatus.FOUND : TermsEnum.SeekStatus.NOT_FOUND;
            }

            @Override
            public void seekExact(BytesRef target, TermState otherState) {
                if (!target.equals(this.term)) {
                    this.state.copyFrom(otherState);
                    this.term = BytesRef.deepCopyOf(target);
                    this.seekPending = true;
                }
            }
        }

        abstract class BaseTermsEnum
        extends org.apache.lucene.index.BaseTermsEnum {
            final BlockTermState state;
            FSTTermOutputs.TermData meta;
            ByteArrayDataInput bytesReader;

            abstract void decodeMetaData() throws IOException;

            BaseTermsEnum() throws IOException {
                this.state = FSTTermsReader.this.postingsReader.newTermState();
                this.bytesReader = new ByteArrayDataInput();
            }

            @Override
            public TermState termState() throws IOException {
                this.decodeMetaData();
                return this.state.clone();
            }

            @Override
            public int docFreq() throws IOException {
                return this.state.docFreq;
            }

            @Override
            public long totalTermFreq() throws IOException {
                return this.state.totalTermFreq == -1L ? (long)this.state.docFreq : this.state.totalTermFreq;
            }

            @Override
            public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                this.decodeMetaData();
                return FSTTermsReader.this.postingsReader.postings(TermsReader.this.fieldInfo, this.state, reuse, flags);
            }

            @Override
            public ImpactsEnum impacts(int flags) throws IOException {
                this.decodeMetaData();
                return FSTTermsReader.this.postingsReader.impacts(TermsReader.this.fieldInfo, this.state, flags);
            }

            @Override
            public void seekExact(long ord) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long ord() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

