/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextKnnVectorsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;

public class SimpleTextKnnVectorsReader
extends KnnVectorsReader {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SimpleTextKnnVectorsReader.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    private static final BytesRef EMPTY = new BytesRef("");
    private final SegmentReadState readState;
    private final IndexInput dataIn;
    private final BytesRefBuilder scratch = new BytesRefBuilder();
    private final Map<String, FieldEntry> fieldEntries = new HashMap<String, FieldEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SimpleTextKnnVectorsReader(SegmentReadState readState) throws IOException {
        this.readState = readState;
        String metaFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "gri");
        String vectorFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "vec");
        boolean success = false;
        try {
            try (ChecksumIndexInput in = readState.directory.openChecksumInput(metaFileName, IOContext.DEFAULT);){
                int fieldNumber = this.readInt(in, SimpleTextKnnVectorsWriter.FIELD_NUMBER);
                while (fieldNumber != -1) {
                    String fieldName = this.readString(in, SimpleTextKnnVectorsWriter.FIELD_NAME);
                    long vectorDataOffset = this.readLong(in, SimpleTextKnnVectorsWriter.VECTOR_DATA_OFFSET);
                    long vectorDataLength = this.readLong(in, SimpleTextKnnVectorsWriter.VECTOR_DATA_LENGTH);
                    int dimension = this.readInt(in, SimpleTextKnnVectorsWriter.VECTOR_DIMENSION);
                    int size = this.readInt(in, SimpleTextKnnVectorsWriter.SIZE);
                    int[] docIds = new int[size];
                    for (int i = 0; i < size; ++i) {
                        docIds[i] = this.readInt(in, EMPTY);
                    }
                    assert (!this.fieldEntries.containsKey(fieldName));
                    this.fieldEntries.put(fieldName, new FieldEntry(dimension, vectorDataOffset, vectorDataLength, docIds));
                    fieldNumber = this.readInt(in, SimpleTextKnnVectorsWriter.FIELD_NUMBER);
                }
                SimpleTextUtil.checkFooter(in);
                this.dataIn = readState.directory.openInput(vectorFileName, IOContext.DEFAULT);
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this);
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldInfo info = this.readState.fieldInfos.fieldInfo(field);
        if (info == null) {
            return null;
        }
        int dimension = info.getVectorDimension();
        if (dimension == 0) {
            throw new IllegalStateException("KNN vectors readers should not be called on fields that don't enable KNN vectors");
        }
        FieldEntry fieldEntry = this.fieldEntries.get(field);
        if (fieldEntry == null) {
            return null;
        }
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + field + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        IndexInput bytesSlice = this.dataIn.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        return new SimpleTextFloatVectorValues(fieldEntry, bytesSlice);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        FieldInfo info = this.readState.fieldInfos.fieldInfo(field);
        if (info == null) {
            return null;
        }
        int dimension = info.getVectorDimension();
        if (dimension == 0) {
            throw new IllegalStateException("KNN vectors readers should not be called on fields that don't enable KNN vectors");
        }
        FieldEntry fieldEntry = this.fieldEntries.get(field);
        if (fieldEntry == null) {
            return null;
        }
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + field + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        IndexInput bytesSlice = this.dataIn.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        return new SimpleTextByteVectorValues(fieldEntry, bytesSlice);
    }

    @Override
    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        int doc;
        FloatVectorValues values = this.getFloatVectorValues(field);
        if (target.length != values.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + target.length + " differs from field dimension: " + values.dimension());
        }
        FieldInfo info = this.readState.fieldInfos.fieldInfo(field);
        VectorSimilarityFunction vectorSimilarity = info.getVectorSimilarityFunction();
        while ((doc = values.nextDoc()) != Integer.MAX_VALUE) {
            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
            if (knnCollector.earlyTerminated()) break;
            float[] vector = values.vectorValue();
            float score = vectorSimilarity.compare(vector, target);
            knnCollector.collect(doc, score);
            knnCollector.incVisitedCount(1);
        }
    }

    @Override
    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        int doc;
        ByteVectorValues values = this.getByteVectorValues(field);
        if (target.length != values.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + target.length + " differs from field dimension: " + values.dimension());
        }
        FieldInfo info = this.readState.fieldInfos.fieldInfo(field);
        VectorSimilarityFunction vectorSimilarity = info.getVectorSimilarityFunction();
        while ((doc = values.nextDoc()) != Integer.MAX_VALUE) {
            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
            if (knnCollector.earlyTerminated()) break;
            byte[] vector = values.vectorValue();
            float score = vectorSimilarity.compare(vector, target);
            knnCollector.collect(doc, score);
            knnCollector.incVisitedCount(1);
        }
    }

    @Override
    public void checkIntegrity() throws IOException {
        IndexInput clone = this.dataIn.clone();
        clone.seek(0L);
        long footerStartPos = this.dataIn.length() - (long)(SimpleTextUtil.CHECKSUM.length + 21);
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(clone);
        if (footerStartPos == 0L) {
            SimpleTextUtil.checkFooter(input);
            return;
        }
        do {
            SimpleTextUtil.readLine(input, this.scratch);
        } while (((IndexInput)input).getFilePointer() < footerStartPos);
        if (((IndexInput)input).getFilePointer() != footerStartPos) {
            throw new CorruptIndexException("SimpleText failure: footer does not start at expected position current=" + ((IndexInput)input).getFilePointer() + " vs expected=" + footerStartPos, input);
        }
        SimpleTextUtil.checkFooter(input);
    }

    @Override
    public long ramBytesUsed() {
        long totalBytes = BASE_RAM_BYTES_USED;
        totalBytes += RamUsageEstimator.sizeOf(this.scratch.bytes());
        totalBytes += RamUsageEstimator.sizeOfMap(this.fieldEntries, RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class));
        for (FieldEntry entry : this.fieldEntries.values()) {
            totalBytes += RamUsageEstimator.sizeOf(entry.ordToDoc);
        }
        return totalBytes;
    }

    @Override
    public void close() throws IOException {
        this.dataIn.close();
    }

    private int readInt(IndexInput in, BytesRef field) throws IOException {
        SimpleTextUtil.readLine(in, this.scratch);
        return this.parseInt(field);
    }

    private long readLong(IndexInput in, BytesRef field) throws IOException {
        SimpleTextUtil.readLine(in, this.scratch);
        return this.parseLong(field);
    }

    private String readString(IndexInput in, BytesRef field) throws IOException {
        SimpleTextUtil.readLine(in, this.scratch);
        return this.stripPrefix(field);
    }

    private boolean startsWith(BytesRef prefix) {
        return StringHelper.startsWith(this.scratch.get(), prefix);
    }

    private int parseInt(BytesRef prefix) {
        assert (this.startsWith(prefix));
        return Integer.parseInt(this.stripPrefix(prefix));
    }

    private long parseLong(BytesRef prefix) {
        assert (this.startsWith(prefix));
        return Long.parseLong(this.stripPrefix(prefix));
    }

    private String stripPrefix(BytesRef prefix) {
        int prefixLen = prefix.length;
        return new String(this.scratch.bytes(), prefixLen, this.scratch.length() - prefixLen, StandardCharsets.UTF_8);
    }

    private static class SimpleTextByteVectorValues
    extends ByteVectorValues
    implements RandomAccessVectorValues<BytesRef> {
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final FieldEntry entry;
        private final IndexInput in;
        private final BytesRef binaryValue;
        private final byte[][] values;
        int curOrd;

        SimpleTextByteVectorValues(FieldEntry entry, IndexInput in) throws IOException {
            this.entry = entry;
            this.in = in;
            this.values = new byte[entry.size()][entry.dimension];
            this.binaryValue = new BytesRef(entry.dimension);
            this.binaryValue.length = this.binaryValue.bytes.length;
            this.curOrd = -1;
            this.readAllVectors();
        }

        @Override
        public int dimension() {
            return this.entry.dimension;
        }

        @Override
        public int size() {
            return this.entry.size();
        }

        @Override
        public byte[] vectorValue() {
            this.binaryValue.bytes = this.values[this.curOrd];
            return this.binaryValue.bytes;
        }

        @Override
        public RandomAccessVectorValues<BytesRef> copy() {
            return this;
        }

        @Override
        public int docID() {
            if (this.curOrd == -1) {
                return -1;
            }
            if (this.curOrd >= this.entry.size()) {
                return Integer.MAX_VALUE;
            }
            return this.entry.ordToDoc[this.curOrd];
        }

        @Override
        public int nextDoc() throws IOException {
            if (++this.curOrd < this.entry.size()) {
                return this.docID();
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        private void readAllVectors() throws IOException {
            for (byte[] value : this.values) {
                this.readVector(value);
            }
        }

        private void readVector(byte[] value) throws IOException {
            SimpleTextUtil.readLine(this.in, this.scratch);
            String s = new BytesRef(this.scratch.bytes(), 1, this.scratch.length() - 2).utf8ToString();
            String[] floatStrings = s.split(",");
            assert (floatStrings.length == value.length) : " read " + s + " when expecting " + value.length + " floats";
            for (int i = 0; i < floatStrings.length; ++i) {
                value[i] = (byte)Float.parseFloat(floatStrings[i]);
            }
        }

        @Override
        public BytesRef vectorValue(int targetOrd) throws IOException {
            this.binaryValue.bytes = this.values[this.curOrd];
            return this.binaryValue;
        }
    }

    private static class SimpleTextFloatVectorValues
    extends FloatVectorValues
    implements RandomAccessVectorValues<float[]> {
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final FieldEntry entry;
        private final IndexInput in;
        private final float[][] values;
        int curOrd;

        SimpleTextFloatVectorValues(FieldEntry entry, IndexInput in) throws IOException {
            this.entry = entry;
            this.in = in;
            this.values = new float[entry.size()][entry.dimension];
            this.curOrd = -1;
            this.readAllVectors();
        }

        @Override
        public int dimension() {
            return this.entry.dimension;
        }

        @Override
        public int size() {
            return this.entry.size();
        }

        @Override
        public float[] vectorValue() {
            return this.values[this.curOrd];
        }

        @Override
        public RandomAccessVectorValues<float[]> copy() {
            return this;
        }

        @Override
        public int docID() {
            if (this.curOrd == -1) {
                return -1;
            }
            if (this.curOrd >= this.entry.size()) {
                return Integer.MAX_VALUE;
            }
            return this.entry.ordToDoc[this.curOrd];
        }

        @Override
        public int nextDoc() throws IOException {
            if (++this.curOrd < this.entry.size()) {
                return this.docID();
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        private void readAllVectors() throws IOException {
            for (float[] value : this.values) {
                this.readVector(value);
            }
        }

        private void readVector(float[] value) throws IOException {
            SimpleTextUtil.readLine(this.in, this.scratch);
            String s = new BytesRef(this.scratch.bytes(), 1, this.scratch.length() - 2).utf8ToString();
            String[] floatStrings = s.split(",");
            assert (floatStrings.length == value.length) : " read " + s + " when expecting " + value.length + " floats";
            for (int i = 0; i < floatStrings.length; ++i) {
                value[i] = Float.parseFloat(floatStrings[i]);
            }
        }

        @Override
        public float[] vectorValue(int targetOrd) throws IOException {
            return this.values[targetOrd];
        }
    }

    private static class FieldEntry {
        final int dimension;
        final long vectorDataOffset;
        final long vectorDataLength;
        final int[] ordToDoc;

        FieldEntry(int dimension, long vectorDataOffset, long vectorDataLength, int[] ordToDoc) {
            this.dimension = dimension;
            this.vectorDataOffset = vectorDataOffset;
            this.vectorDataLength = vectorDataLength;
            this.ordToDoc = ordToDoc;
        }

        int size() {
            return this.ordToDoc.length;
        }
    }
}

