/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextBKDWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.bkd.BKDConfig;

class SimpleTextPointsWriter
extends PointsWriter {
    public static final BytesRef NUM_DATA_DIMS = new BytesRef("num data dims ");
    public static final BytesRef NUM_INDEX_DIMS = new BytesRef("num index dims ");
    public static final BytesRef BYTES_PER_DIM = new BytesRef("bytes per dim ");
    public static final BytesRef MAX_LEAF_POINTS = new BytesRef("max leaf points ");
    public static final BytesRef INDEX_COUNT = new BytesRef("index count ");
    public static final BytesRef BLOCK_COUNT = new BytesRef("block count ");
    public static final BytesRef BLOCK_DOC_ID = new BytesRef("  doc ");
    public static final BytesRef BLOCK_FP = new BytesRef("  block fp ");
    public static final BytesRef BLOCK_VALUE = new BytesRef("  block value ");
    public static final BytesRef SPLIT_COUNT = new BytesRef("split count ");
    public static final BytesRef SPLIT_DIM = new BytesRef("  split dim ");
    public static final BytesRef SPLIT_VALUE = new BytesRef("  split value ");
    public static final BytesRef FIELD_COUNT = new BytesRef("field count ");
    public static final BytesRef FIELD_FP_NAME = new BytesRef("  field fp name ");
    public static final BytesRef FIELD_FP = new BytesRef("  field fp ");
    public static final BytesRef MIN_VALUE = new BytesRef("min value ");
    public static final BytesRef MAX_VALUE = new BytesRef("max value ");
    public static final BytesRef POINT_COUNT = new BytesRef("point count ");
    public static final BytesRef DOC_COUNT = new BytesRef("doc count ");
    public static final BytesRef END = new BytesRef("END");
    private IndexOutput dataOut;
    final BytesRefBuilder scratch = new BytesRefBuilder();
    final SegmentWriteState writeState;
    final Map<String, Long> indexFPs = new HashMap<String, Long>();

    public SimpleTextPointsWriter(SegmentWriteState writeState) throws IOException {
        String fileName = IndexFileNames.segmentFileName(writeState.segmentInfo.name, writeState.segmentSuffix, "dim");
        this.dataOut = writeState.directory.createOutput(fileName, writeState.context);
        this.writeState = writeState;
    }

    @Override
    public void writeField(FieldInfo fieldInfo, PointsReader reader) throws IOException {
        PointValues.PointTree values = reader.getValues(fieldInfo.name).getPointTree();
        BKDConfig config = new BKDConfig(fieldInfo.getPointDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), 512);
        try (final SimpleTextBKDWriter writer = new SimpleTextBKDWriter(this.writeState.segmentInfo.maxDoc(), this.writeState.directory, this.writeState.segmentInfo.name, config, 16.0, values.size());){
            values.visitDocValues(new PointValues.IntersectVisitor(){

                @Override
                public void visit(int docID) {
                    throw new IllegalStateException();
                }

                @Override
                public void visit(int docID, byte[] packedValue) throws IOException {
                    writer.add(packedValue, docID);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            });
            if (writer.getPointCount() > 0L) {
                this.indexFPs.put(fieldInfo.name, writer.finish(this.dataOut));
            }
        }
    }

    @Override
    public void finish() throws IOException {
        SimpleTextUtil.write(this.dataOut, END);
        SimpleTextUtil.writeNewline(this.dataOut);
        SimpleTextUtil.writeChecksum(this.dataOut, this.scratch);
    }

    @Override
    public void close() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.close();
            this.dataOut = null;
            String fileName = IndexFileNames.segmentFileName(this.writeState.segmentInfo.name, this.writeState.segmentSuffix, "dii");
            try (IndexOutput indexOut = this.writeState.directory.createOutput(fileName, this.writeState.context);){
                int count = this.indexFPs.size();
                this.write(indexOut, FIELD_COUNT);
                this.write(indexOut, Integer.toString(count));
                this.newline(indexOut);
                for (Map.Entry<String, Long> ent : this.indexFPs.entrySet()) {
                    this.write(indexOut, FIELD_FP_NAME);
                    this.write(indexOut, ent.getKey());
                    this.newline(indexOut);
                    this.write(indexOut, FIELD_FP);
                    this.write(indexOut, Long.toString(ent.getValue()));
                    this.newline(indexOut);
                }
                SimpleTextUtil.writeChecksum(indexOut, this.scratch);
            }
        }
    }

    private void write(IndexOutput out, String s) throws IOException {
        SimpleTextUtil.write(out, s, this.scratch);
    }

    private void write(IndexOutput out, BytesRef b) throws IOException {
        SimpleTextUtil.write(out, b);
    }

    private void newline(IndexOutput out) throws IOException {
        SimpleTextUtil.writeNewline(out);
    }
}

