/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

public class SimpleTextStoredFieldsWriter
extends StoredFieldsWriter {
    private int numDocsWritten = 0;
    private IndexOutput out;
    static final String FIELDS_EXTENSION = "fld";
    static final BytesRef TYPE_STRING = new BytesRef("string");
    static final BytesRef TYPE_BINARY = new BytesRef("binary");
    static final BytesRef TYPE_INT = new BytesRef("int");
    static final BytesRef TYPE_LONG = new BytesRef("long");
    static final BytesRef TYPE_FLOAT = new BytesRef("float");
    static final BytesRef TYPE_DOUBLE = new BytesRef("double");
    static final BytesRef END = new BytesRef("END");
    static final BytesRef DOC = new BytesRef("doc ");
    static final BytesRef FIELD = new BytesRef("  field ");
    static final BytesRef NAME = new BytesRef("    name ");
    static final BytesRef TYPE = new BytesRef("    type ");
    static final BytesRef VALUE = new BytesRef("    value ");
    private final BytesRefBuilder scratch = new BytesRefBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleTextStoredFieldsWriter(Directory directory, String segment, IOContext context) throws IOException {
        boolean success = false;
        try {
            this.out = directory.createOutput(IndexFileNames.segmentFileName(segment, "", FIELDS_EXTENSION), context);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void startDocument() throws IOException {
        this.write(DOC);
        this.write(Integer.toString(this.numDocsWritten));
        this.newLine();
        ++this.numDocsWritten;
    }

    @Override
    public void writeField(FieldInfo info, int value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_INT);
        this.newLine();
        this.write(VALUE);
        this.write(Integer.toString(value));
        this.newLine();
    }

    @Override
    public void writeField(FieldInfo info, long value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_LONG);
        this.newLine();
        this.write(VALUE);
        this.write(Long.toString(value));
        this.newLine();
    }

    @Override
    public void writeField(FieldInfo info, float value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_FLOAT);
        this.newLine();
        this.write(VALUE);
        this.write(Float.toString(value));
        this.newLine();
    }

    @Override
    public void writeField(FieldInfo info, double value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_DOUBLE);
        this.newLine();
        this.write(VALUE);
        this.write(Double.toString(value));
        this.newLine();
    }

    @Override
    public void writeField(FieldInfo info, BytesRef value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_BINARY);
        this.newLine();
        this.write(VALUE);
        this.write(value);
        this.newLine();
    }

    @Override
    public void writeField(FieldInfo info, String value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_STRING);
        this.newLine();
        this.write(VALUE);
        this.write(value);
        this.newLine();
    }

    private void writeField(FieldInfo info) throws IOException {
        this.write(FIELD);
        this.write(Integer.toString(info.number));
        this.newLine();
        this.write(NAME);
        this.write(info.name);
        this.newLine();
    }

    @Override
    public void finish(int numDocs) throws IOException {
        if (this.numDocsWritten != numDocs) {
            throw new RuntimeException("mergeFields produced an invalid result: docCount is " + numDocs + " but only saw " + this.numDocsWritten + " file=" + this.out.toString() + "; now aborting this merge to prevent index corruption");
        }
        this.write(END);
        this.newLine();
        SimpleTextUtil.writeChecksum(this.out, this.scratch);
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.out);
        }
        finally {
            this.out = null;
        }
    }

    private void write(String s) throws IOException {
        SimpleTextUtil.write(this.out, s, this.scratch);
    }

    private void write(BytesRef bytes) throws IOException {
        SimpleTextUtil.write(this.out, bytes);
    }

    private void newLine() throws IOException {
        SimpleTextUtil.writeNewline(this.out);
    }

    @Override
    public long ramBytesUsed() {
        return 4L;
    }
}

