/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.OffHeapFSTStore;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class FSTDictionary
implements IndexDictionary {
    protected final FST<Long> fst;

    protected FSTDictionary(FST<Long> fst) {
        this.fst = fst;
    }

    @Override
    public void write(DataOutput output, BlockEncoder blockEncoder) throws IOException {
        if (blockEncoder == null) {
            this.fst.save(output, output);
        } else {
            ByteBuffersDataOutput bytesDataOutput = ByteBuffersDataOutput.newResettableInstance();
            this.fst.save(bytesDataOutput, bytesDataOutput);
            BlockEncoder.WritableBytes encodedBytes = blockEncoder.encode(bytesDataOutput.toDataInput(), bytesDataOutput.size());
            output.writeVLong(encodedBytes.size());
            encodedBytes.writeTo(output);
        }
    }

    protected static FSTDictionary read(DataInput input, BlockDecoder blockDecoder, boolean isFSTOnHeap) throws IOException {
        DataInput fstDataInput;
        if (blockDecoder == null) {
            fstDataInput = input;
        } else {
            long numBytes = input.readVLong();
            BytesRef decodedBytes = blockDecoder.decode(input, numBytes);
            fstDataInput = new ByteArrayDataInput(decodedBytes.bytes, 0, decodedBytes.length);
            isFSTOnHeap = true;
        }
        PositiveIntOutputs fstOutputs = PositiveIntOutputs.getSingleton();
        FST.FSTMetadata<Long> metadata = FST.readMetadata(fstDataInput, fstOutputs);
        FST<Long> fst = isFSTOnHeap ? new FST<Long>(metadata, fstDataInput) : new FST<Long>(metadata, fstDataInput, new OffHeapFSTStore());
        return new FSTDictionary(fst);
    }

    @Override
    public Browser browser() {
        return new Browser();
    }

    public static class Builder
    implements IndexDictionary.Builder {
        protected final FSTCompiler<Long> fstCompiler;
        protected final IntsRefBuilder scratchInts;

        public Builder() throws IOException {
            PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
            this.fstCompiler = new FSTCompiler.Builder<Long>(FST.INPUT_TYPE.BYTE1, outputs).build();
            this.scratchInts = new IntsRefBuilder();
        }

        @Override
        public void add(BytesRef blockKey, long blockFilePointer) throws IOException {
            this.fstCompiler.add(Util.toIntsRef(blockKey, this.scratchInts), blockFilePointer);
        }

        @Override
        public FSTDictionary build() throws IOException {
            return new FSTDictionary(this.fstCompiler.compile());
        }
    }

    public static class BrowserSupplier
    implements IndexDictionary.BrowserSupplier {
        protected final IndexInput dictionaryInput;
        protected final BlockDecoder blockDecoder;
        protected final boolean isFSTOnHeap;
        protected IndexDictionary dictionary;

        public BrowserSupplier(IndexInput dictionaryInput, long dictionaryStartFP, BlockDecoder blockDecoder, boolean isFSTOnHeap) throws IOException {
            this.dictionaryInput = dictionaryInput.clone();
            this.dictionaryInput.seek(dictionaryStartFP);
            this.blockDecoder = blockDecoder;
            this.isFSTOnHeap = isFSTOnHeap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IndexDictionary.Browser get() throws IOException {
            if (this.dictionary == null) {
                BrowserSupplier browserSupplier = this;
                synchronized (browserSupplier) {
                    if (this.dictionary == null) {
                        this.dictionary = FSTDictionary.read(this.dictionaryInput, this.blockDecoder, this.isFSTOnHeap);
                    }
                }
            }
            return this.dictionary.browser();
        }
    }

    protected class Browser
    implements IndexDictionary.Browser {
        protected final BytesRefFSTEnum<Long> fstEnum;

        protected Browser() {
            this.fstEnum = new BytesRefFSTEnum<Long>(FSTDictionary.this.fst);
        }

        @Override
        public long seekBlock(BytesRef term) throws IOException {
            BytesRefFSTEnum.InputOutput<Long> seekFloor = this.fstEnum.seekFloor(term);
            return seekFloor == null ? -1L : (Long)seekFloor.output;
        }
    }
}

